@echo off
echo Import H05B (produced by H-SAF 
echo Retrieved from https://filetransfer.itc.nl/pub/mpe/HSAF_H05B/
echo original ILWIS files not deleted so these can be used for further dedicated analysis
echo.
echo.

set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8
set irfanviewdir=%9

cd\
%OutputDrive%
cd %OutputDir%

echo your current working directory = %OutputDrive%\%OutputDir%
echo.
echo.


"%UtilDir%\wget\wget.exe" https://filetransfer.itc.nl/pub/mpe/HSAF_H05B/MPEG_H05B_%shortfilename1%.zip


if not exist "%OutputDrive%\%OutputDir%\MPEG_H05B_%shortfilename1%.zip"  goto MESSAGE

GOTO START

:MESSAGE
echo The input file was not found in the archive.
echo Check your Date stamp settings
echo Your current Date stamp used is %shortfilename1%
echo Data is retrieved from https://filetransfer.itc.nl/pub/mpe/HSAF_H05B/
echo Check also manually if the data exists on ftp archive (see link above)
echo Internet has a transient nature - addresses might not be valid or has changed after some time

pause

GOTO END

:START
echo.
echo.
echo Retrieved rainfall data is resampled and exported to a PNG for display in Google Earth
echo After inspecting the rainfall in Google Earth close Google Earth to continue
echo.
echo. 

echo off
"%UtilDir%\7z" e MPEG_H05B_%shortfilename1%.zip MPEG_H05B_%shortfilename1%_24.mp* 

"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\MPEG_H05B_%shortfilename1%_24.mpr %OutputDrive%\%OutputDir%\mpe_georef.grf 

copy %UtilDir%\mpegoogle.grf >NUL
copy %UtilDir%\world_mpegoogle.grf >NUL

echo.
echo. 
echo Be patient while file is transformed for visualization in Google Earth

"%IlwDir%\ilwis.exe" -C  mpe%shortfilename1%_latlon:=MapResample(%OutputDrive%\%OutputDir%\MPEG_H05B_%shortfilename1%_24,mpegoogle.grf,bicubic)


"%IlwDir%\ilwis.exe" -C mpe%shortfilename1%_latlon_red:=min(255,max(0,iff(mpe%shortfilename1%_latlon.mpr le 2,0+(64-0)*(mpe%shortfilename1%_latlon.mpr-0)/(2-0),iff(mpe%shortfilename1%_latlon.mpr le 5,64+(24-64)*(mpe%shortfilename1%_latlon.mpr-2)/(5-2),iff(mpe%shortfilename1%_latlon.mpr le 12,24+(255-24)*(mpe%shortfilename1%_latlon.mpr-5)/(12-5),iff(mpe%shortfilename1%_latlon.mpr le 20,255+(255-255)*(mpe%shortfilename1%_latlon.mpr-12)/(20-12), iff(mpe%shortfilename1%_latlon.mpr le 200,255+(255-255)*(mpe%shortfilename1%_latlon.mpr-20)/(200-20),150)))))))

"%IlwDir%\ilwis.exe" -C mpe%shortfilename1%_latlon_green:=min(255,max(0,iff(mpe%shortfilename1%_latlon.mpr le 2,0+(104-0)*(mpe%shortfilename1%_latlon.mpr-0)/(2-0),iff(mpe%shortfilename1%_latlon.mpr le 5,104+(204-104)*(mpe%shortfilename1%_latlon.mpr-2)/(5-2),iff(mpe%shortfilename1%_latlon.mpr le 12,204+(255-204)*(mpe%shortfilename1%_latlon.mpr-5)/(12-5),iff(mpe%shortfilename1%_latlon.mpr le 20,255+(136-255)*(mpe%shortfilename1%_latlon.mpr-12)/(20-12), iff(mpe%shortfilename1%_latlon.mpr le 200,136+(0-136)*(mpe%shortfilename1%_latlon.mpr-20)/(200-20),0)))))))

"%IlwDir%\ilwis.exe" -C mpe%shortfilename1%_latlon_blue:=min(255,max(0,iff(mpe%shortfilename1%_latlon.mpr le 2,255+(225-255)*(mpe%shortfilename1%_latlon.mpr-0)/(2-0),iff(mpe%shortfilename1%_latlon.mpr le 5,225+(224-225)*(mpe%shortfilename1%_latlon.mpr-2)/(5-2),iff(mpe%shortfilename1%_latlon.mpr le 12,224+(0-224)*(mpe%shortfilename1%_latlon.mpr-5)/(12-5),iff(mpe%shortfilename1%_latlon.mpr le 20,0+(0-0)*(mpe%shortfilename1%_latlon.mpr-12)/(20-12),iff(mpe%shortfilename1%_latlon.mpr le 200,0+(0-0)*(mpe%shortfilename1%_latlon.mpr-20)/(200-20),0)))))))

"%IlwDir%\ilwis.exe" -C mpe%shortfilename1%_latlon_alpha:=ifundef(mpe%shortfilename1%_latlon.mpr,0,255)


rem Create a MapList with the bands properly ordered so that it can be exported to PNG

"%IlwDir%\ilwis.exe" -C crmaplist mpe%shortfilename1%_latlon.mpl mpe%shortfilename1%_latlon_red.mpr mpe%shortfilename1%_latlon_green.mpr mpe%shortfilename1%_latlon_blue.mpr mpe%shortfilename1%_latlon_alpha.mpr



rem export to PNG
"%gdalDir%\gdal_translate" -of PNG -ot Byte mpe%shortfilename1%_latlon.mpl mpe%shortfilename1%_latlon.png

rem generate KML file
echo ^<?xml version="1.0" encoding="UTF-8"?^> > mpe%shortfilename1%_latlon.kml
echo ^<kml xmlns="http://www.opengis.net/kml/2.2" xmlns:gx="http://www.google.com/kml/ext/2.2"^> >> mpe%shortfilename1%_latlon.kml
echo ^<Document^> >> mpe%shortfilename1%_latlon.kml

echo ^<name^>mpe%shortfilename1%_latlon^</name^> >> mpe%shortfilename1%_latlon.kml
echo ^<description^>Google raster overlay of image mpe%shortfilename1%_latlon.png^</description^>  >> mpe%shortfilename1%_latlon.kml
echo ^<GroundOverlay^> >> mpe%shortfilename1%_latlon.kml
echo ^<name^>Raster data^</name^> >> mpe%shortfilename1%_latlon.kml
echo ^<LatLonBox^> >> mpe%shortfilename1%_latlon.kml
echo ^<north^>60^</north^> >> mpe%shortfilename1%_latlon.kml
echo ^<south^>-60^</south^> >> mpe%shortfilename1%_latlon.kml
echo ^<east^>60^</east^> >> mpe%shortfilename1%_latlon.kml
echo ^<west^>-60^</west^> >> mpe%shortfilename1%_latlon.kml
echo ^</LatLonBox^> >> mpe%shortfilename1%_latlon.kml
echo ^<Icon^> >> mpe%shortfilename1%_latlon.kml
echo ^<href^>%OutputDrive%\%OutputDir%\mpe%shortfilename1%_latlon.png^</href^> >> mpe%shortfilename1%_latlon.kml
echo ^</Icon^> >> mpe%shortfilename1%_latlon.kml
echo ^</GroundOverlay^> >> mpe%shortfilename1%_latlon.kml

echo ^<ScreenOverlay^> >> mpe%shortfilename1%_latlon.kml
echo ^<name^>Legend in mm/day^</name^> >> mpe%shortfilename1%_latlon.kml
echo ^<Icon^> ^<href^>%IlwDir%\Extensions\GEONETCast-Toolbox\util\leg_mpe2.png^</href^> >> mpe%shortfilename1%_latlon.kml
echo ^</Icon^> >> mpe%shortfilename1%_latlon.kml >> mpe%shortfilename1%_latlon.kml
echo ^<overlayXY x="0" y="0" xunits="fraction" yunits="fraction"/^> >> mpe%shortfilename1%_latlon.kml 
echo ^<screenXY x="25" y="95" xunits="pixels" yunits="pixels"/^> >> mpe%shortfilename1%_latlon.kml 
echo ^<rotationXY x="0.5" y="0.5" xunits="fraction" yunits="fraction"/^> >> mpe%shortfilename1%_latlon.kml 
echo ^<size x="0" y="0" xunits="pixels" yunits="pixels"/^> >> mpe%shortfilename1%_latlon.kml
echo ^</ScreenOverlay^> >> mpe%shortfilename1%_latlon.kml >> mpe%shortfilename1%_latlon.kml

echo ^<Placemark id="MPE"^> >> mpe%shortfilename1%_latlon.kml
echo ^<name^>Aggregated accumulated precipitation Map (mm/day) for %shortfilename1% ^</name^> >> mpe%shortfilename1%_latlon.kml
echo ^<Snippet^>Aggregation period from 00:00 - 23:45 UTC ^</Snippet^> >> mpe%shortfilename1%_latlon.kml
echo ^<description^>^<![CDATA[ >> mpe%shortfilename1%_latlon.kml
echo ^<head^> >> mpe%shortfilename1%_latlon.kml
echo ^<style type="text/css"^> >> mpe%shortfilename1%_latlon.kml
echo #text {font-family:Verdana, Arial, Helvetica;} >> mpe%shortfilename1%_latlon.kml
echo ^</style^> >> mpe%shortfilename1%_latlon.kml
echo ^</head^> >> mpe%shortfilename1%_latlon.kml
echo ^<body^> >> mpe%shortfilename1%_latlon.kml
echo ^<div style="width:100%%;background-color:#406200;height:155px;margin-bottom:10px;"^> >> mpe%shortfilename1%_latlon.kml
echo ^<div style="float:left;"^> >> mpe%shortfilename1%_latlon.kml
echo ^<a href="https://www.itc.nl/about-itc/organization/scientific-departments/water-resources/geonetcast/" target="_blank"^>^<img src="https://1348661504.rsc.cdn77.org/.publisher/sd/utwente_base/ws2016/img/itc/itc-logo@2x.png" alt="MPE" title="MPE" style="float:left;margin:10px;" /^>^</a^> >> mpe%shortfilename1%_latlon.kml
echo ^</div^> >> mpe%shortfilename1%_latlon.kml
echo ^<div style="float:right;margin:5px;"^> >> mpe%shortfilename1%_latlon.kml
echo ^<span class="glyphicon glyphicon-globe" style="color:#fff"^>^</span^> ^<span style="color:#fff"^>HTTPS download address:^</span^> >> mpe%shortfilename1%_latlon.kml
echo ^<br /^>^<a href="ftp://ftp.itc.nl/pub/mpe/" target="_blank" style="color:#fff"^>^<abbr title="https://filetransfer.itc.nl/pub/mpe/HSAF_H05B"^>https://filetransfer.itc.nl/pub/mpe/HSAF_H05B^</abbr^>^</a^> >> mpe%shortfilename1%_latlon.kml
echo ^<br /^>^<span class="glyphicon glyphicon-envelope" style="color:#fff"^>^</span^> ^<span style="color:#fff"^>E-mail Address:^</span^> >> mpe%shortfilename1%_latlon.kml

echo ^<br /^>^<a href="mailto:b.h.p.maathuis@utwente.nl" style="color:#fff"^>b.h.p.maathuis@utwente.nl^</a^> >> mpe%shortfilename1%_latlon.kml
echo ^</div^> >> mpe%shortfilename1%_latlon.kml
echo ^</div^> >> mpe%shortfilename1%_latlon.kml
echo ^<h2^>Accumulated precipitation at ground by blended MW and IR^</h2^> >> mpe%shortfilename1%_latlon.kml
echo ^<strong^>Product H05B (P-AC-G-SEVIRI over the full disk area) is based on frequent precipitation measurements as retrieved by blending LEO MW-derived precipitation rate measurements and GEO IR imagery.^</strong^> >> mpe%shortfilename1%_latlon.kml
echo ^<p^>This product has replaced the MPE product and is available from 20190701 on a daily basis (as from 03:00 UTC - for the previous day!).For further information, consult the H-SAF Website: http://hsaf.meteoam.it, or the product user manual at http://hsaf.meteoam.it/documents/PUM/SAF_HSAF_PUM-05B_1_1.pdf^</p^> >> mpe%shortfilename1%_latlon.kml
echo ^<p^>Source http://navigator.eumetsat.int^</p^> >> mpe%shortfilename1%_latlon.kml
echo ^<p^>Source http://hsaf.meteoam.it^</p^> >> mpe%shortfilename1%_latlon.kml

echo ^</div^> >> mpe%shortfilename1%_latlon.kml
echo ^<h2^>Data processing: ^</h2^> >> mpe%shortfilename1%_latlon.kml
echo ^<p^>At ITC these  products are processed and transformed into an ILWIS file format containing the 24 hour precipitation amount in mm/24hr (from 00:00 to 23:45 UTC). These files are compressed and subsequently transferred to a HTTPS site (https://filetransfer.itc.nl/pub/mpe/HSAF_H05B). The accumulated 24 hour precipitation map is retrieved, decompressed and transformed into a PNG format (with a transparent layer for the areas that have not received precipitation). A KML file is created and executed which invokes Google Earth to start and display the results. These applications assume that Google Earth is locally available.^</p^> >> mpe%shortfilename1%_latlon.kml
echo ^</div^> >> mpe%shortfilename1%_latlon.kml
echo ^</body^> >> mpe%shortfilename1%_latlon.kml
echo ^</html^> >> mpe%shortfilename1%_latlon.kml
echo ]]^>^</description^> >> mpe%shortfilename1%_latlon.kml
echo ^<gx:balloonVisibility^>1^</gx:balloonVisibility^> >> mpe%shortfilename1%_latlon.kml
echo ^<styleUrl^>#default^</styleUrl^> >> mpe%shortfilename1%_latlon.kml

echo ^</Placemark^> >> mpe%shortfilename1%_latlon.kml

echo ^</Document^> >> mpe%shortfilename1%_latlon.kml
echo ^</kml^> >> mpe%shortfilename1%_latlon.kml


rem start Google-Earth with the KML file
mpe%shortfilename1%_latlon.kml



rem cleanup obsolete temporary files
del mpe%shortfilename1%_latlon.mpl 
del mpe%shortfilename1%_latlon_alpha.mp* 
del mpe%shortfilename1%_latlon_blue.mp* 
del mpe%shortfilename1%_latlon_green.mp* 
del mpe%shortfilename1%_latlon_red.mp* 
del mpe%shortfilename1%_latlon.mp* 
del mpe%shortfilename1%_latlon.png.aux.xml 
del MPEG_H05B_%shortfilename1%.zip
del mpe%shortfilename1%_latlon.kml
del mpe%shortfilename1%_latlon.png
del mpegoogle.grf
del world_mpegoogle.grf

:END
"%IlwDir%\ilwis.exe" -C closeall