@echo off

echo Ascat ocean vector winds
echo Wind speed at 10 meters (m s-1)
echo Wind direction at 10 meters (degree from true north)
echo File name format METOP A: ascat_20130219_065100_metopa_32883_eps_o_coa_ovw.l2_bufr
echo FIle name format METOP B: ascat_20130910_082700_metopb_05081_eps_o_coa_ovw.l2_bufr
echo FIle name format METOP C: ascat_20200324_013300_metopc_07147_eps_o_coa_ovw.l2_bufr
echo Currently for METOP A, B and C, only the coa product
rem test is ascat_20200503_081500_metopa_70248_eps_o_coa_ovw.l2_bufr

set longfilename=%1
echo %longfilename%
set shortfilename1=%longfilename:~0,34%

set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8


cd\
%OutputDrive%
cd %OutputDir%


echo Your working directory = %OutputDrive%\%OutputDir%*


copy "%InputDrive%\%InputDir%\%longfilename%" "%OutputDrive%\%OutputDir%\*.*"

if exist "%OutputDrive%\%OutputDir%\%longfilename%" GOTO START1 


:START1
if not exist "%OutputDrive%\%OutputDir%\%longfilename%" goto MESSAGE

echo The file(s) "%InputDrive%\%InputDir%\%longfilename%" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date -satellite and orbit number stamp used is %shortfilename1:~6,34%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START


ren "%OutputDrive%\%OutputDir%\%longfilename%" ovw_%shortfilename1%



echo.
echo.
echo Renamed input file = ovw_%shortfilename1%
echo.
echo.

copy ovw_%shortfilename1% "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract" > NUL

cd /d "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract"

bufrextract.exe ovw_%shortfilename1% -oddump.csv >NUL 2>NUL

cd /d "%OutputDrive%\%OutputDir%"

copy "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\dump.csv" > NUL

del "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\dump.csv"
del "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\ovw_%shortfilename1%"

findstr /b /v "0" dump.csv > dump1.csv
findstr /b /v "#" dump1.csv > dump2.csv 


copy "%IlwDir%\Extensions\GEONETCast-Toolbox\util\ConvertCSV.class 

java ConvertCSV 15 14 86 87 < dump2.csv > dump3.csv 


echo off
echo.
echo.
echo Importing data from BUFR file into ILWIS 
echo.



"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\ovw_%shortfilename1%'.tbt:=table(%OutputDrive%\%OutputDir%\dump3.csv,Comma,Convert,none,X(value.dom{-180:180:0.00001}),Y(value.dom{-90:90:0.00001}),WindSpeed(value.dom{0:1000:0.1}),winddirection(value.dom{0:360:0.1}));
"%IlwDir%\ilwis.exe" -C tabcalc '%OutputDrive%\%OutputDir%\ovw_%shortfilename1%'.tbt wind_dir_cor{dom=value;vr=0:360:0.01}:=iff(winddirection gt 180,180-(360-winddirection),iff(winddirection le 180,winddirection+180,winddirection));

"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\ovw_%shortfilename1%'.mpp:=PointMapFromTable(%OutputDrive%\%OutputDir%\ovw_%shortfilename1%,LatlonWGS84,pnt);



del dump*.csv
del ConvertCSV.class
del ovw_%shortfilename1%


:END
"%IlwDir%\ilwis.exe" -C closeall