@Echo off
echo CSR-import
echo Merging of files (type BUFR)
echo Only percentage cloud cover is transformed into a grid map
echo For the undefined grid no information is avaialble from the source bufr data file
echo Use is made of the MSG projection 
echo Data is resampled from point to grid using a grid resolution of 48 km
rem file name convention L-000-MSG1__-MPEF_IODC___-CSR______-000001___-201701010045-__

echo Note that import can take some time as large number of record need to be processed
echo Be patient as various columns in a table are being calculated

echo For quick visualization of the CSR file use BUFRDisplay
echo Relevant coordinate variables are: 12-latitude (code 5001), 13-longitude (code 6001)
echo Relevant parameters are: 42-Cloud_Amount_in_Segment (code 20081), 43-Amount_Segment_Cloud_Free (code 20082)
echo.
echo.

set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8


cd\
%OutputDrive%
cd %OutputDir%


copy "%InputDrive%\%InputDir%\L-000-MSG2__-MPEF_IODC___-CSR______-00000?___-%shortfilename1%-__*.*" 

if not exist "%InputDrive%\%InputDir%\L-000-MSG2__-MPEF_IODC___-CSR______-000001___-%shortfilename1%-__"  goto MESSAGE
echo The file(s) "%InputDrive%\%InputDir%\L-000-MSG2__-MPEF_IODC___-CSR______-000001___-%shortfilename1%-__" will be copied to your current working directory
echo.
echo.

GOTO START


:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END


:START

"%UtilDir%\joinmsg.exe" "L-000-MSG2__-MPEF_IODC___-CSR______-000001___-%shortfilename1%-__" %OutputDrive%\%OutputDir%\

ren L-000-MSG2__-MPEF_IODC___-CSR______-000001___-%shortfilename1%-__.xyz csr%shortfilename1%.bufr


echo.
echo.
echo Renamed input file = csr%shortfilename1%.bufr
echo.
echo.




copy csr%shortfilename1%.bufr "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract" > NUL

cd /d "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract"

bufrextract.exe csr%shortfilename1%.bufr -oddump.csv > mess.txt 2>&1

cd /d "%OutputDrive%\%OutputDir%"

copy "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\dump.csv" > NUL

del "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\dump.csv"
del "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\csr%shortfilename1%.bufr"
del "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\mess.txt"

findstr /b /v "0" dump.csv > dump1.csv
findstr /b /v "#" dump1.csv > dump2.csv 


copy "%IlwDir%\Extensions\GEONETCast-Toolbox\util\ConvertCSV.class 

java ConvertCSV 14 13 43 44 < dump2.csv > dump3.csv 


echo off
echo.
echo.
echo Importing data from BUFR file into ILWIS and create output maps
echo Wait until routine is completed
echo.



"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\csr%shortfilename1%.tbt:=table(%OutputDrive%\%OutputDir%\dump3.csv,Comma,Convert,none,X(value.dom{-90:180:0.00001}),Y(value.dom{-90:90:0.00001}),Perc_cloud(value.dom{0:100:1}),Perc_cloudfree(value.dom{0:100:1}))

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\csr_pointsIODC%shortfilename1%.mpp:=PointMapFromTable(%OutputDrive%\%OutputDir%\csr%shortfilename1%,X,Y,LatlonWGS84,Perc_cloud)

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\csr_gridIODC%shortfilename1%.mpr{dom=value;vr=0:100}:=MapRasterizePoint(%OutputDrive%\%OutputDir%\csr_pointsIODC%shortfilename1%,'%UtilDir%\msg_IODC'.grf,16)


del L-000-MSG2__-MPEF_IODC___-CSR______-00000?___-%shortfilename1%-*.*
del csr%shortfilename1%.bufr
del dump*.csv
del ConvertCSV.class



:END
"%IlwDir%\ilwis.exe" -C closeall



