@echo off
echo MPEF DIV-import
echo Output is a value map multiplied by 10^6.
rem file name convention L-000-MSG3__-MPEF________-DIV______-000001___-201702281645-__



set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8


cd\
%OutputDrive%
cd %OutputDir%

set MSG_number=2


copy "%InputDrive%\%InputDir%\L-000-MSG?__-MPEF________-DIV______-000001___-%shortfilename1%-__" 

if exist "%OutputDrive%\%OutputDir%\L-000-MSG2__-MPEF________-DIV______-000001___-%shortfilename1%-__" GOTO START1

set MSG_number=3

if exist "%OutputDrive%\%OutputDir%\L-000-MSG3__-MPEF________-DIV______-000001___-%shortfilename1%-__" GOTO START1

set MSG_number=4

:START1
if not exist "%InputDrive%\%InputDir%\L-000-MSG%MSG_number:~0,1%__-MPEF________-DIV______-000001___-%shortfilename1%-__"  goto MESSAGE
echo The file(s) "%InputDrive%\%InputDir%\L-000-MSG%MSG_number:~0,1%__-MPEF________-DIV______-000001___-%shortfilename1%-__" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START
rem import DIV

rename "L-000-MSG%MSG_number:~0,1%__-MPEF________-DIV______-000001___-%shortfilename1%-__" DIV%shortfilename1%.grib

"%gdalDir%\gdal_translate.exe" -ot Float64 -of ilwis DIV%shortfilename1%.grib grib_div.mpr

"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\DIV%shortfilename1%'.mpr{dom=value;vr=-1000:1000:0.0001}:='%OutputDrive%\%OutputDir%\grib_div_band_1'*1000000
"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\DIV%shortfilename1%'.mpr '%UtilDir%\mpef_div'


rem create isolines using gdal contour
rem interval is 25


"%GDALDir%\gdal_translate.exe" -ot Int16 -of GTiff -a_ullr -60.5 60.5 60.5 -60.5 DIV%shortfilename1%.mpr contour_temp.tif

rem From GeoTif to shape format using specified interval and create attribute column called attribute
rem contour interval of 25

rem exclude no data for isoline extraction

"%GDALDir%\gdal_contour.exe" -a attribute -snodata -32768 -i 25 contour_temp.tif contourshp25.shp 

rem Import shape file in ILWIS according to the file name specified

"%IlwDir%\ilwis.exe" -C import shape (contourshp25.shp,DIV%shortfilename1%_25)

rem Select the appropriate cooordinate system as defined by the user

"%IlwDir%\ilwis.exe" -C setcsy DIV%shortfilename1%_25.mps %UtilDir%\mpef_div
"%IlwDir%\ilwis.exe" -C DIV%shortfilename1%_25.hss:=TableHistogramSeg(DIV%shortfilename1%_25)
"%IlwDir%\ilwis.exe" -C tabcalc DIV%shortfilename1%_25.tbt Length:=ColumnJoin(DIV%shortfilename1%_25.hss,Length)
"%IlwDir%\ilwis.exe" -C tabcalc DIV%shortfilename1%_25.tbt selected{dom=value;vr=-1000:1000:1}:=iff(Length gt 3,attribute,?)
"%IlwDir%\ilwis.exe" -C DIV%shortfilename1%_25.mpp:=PointMapPointInSegment(DIV%shortfilename1%_25.mps,Vertex)
"%IlwDir%\ilwis.exe" -C setatttable DIV%shortfilename1%_25.mpp DIV%shortfilename1%_25



rem contour interval of 50

"%GDALDir%\gdal_contour.exe" -a attribute -snodata -32768 -i 50 contour_temp.tif contourshp50.shp 

rem Import shape file in ILWIS according to the file name specified

"%IlwDir%\ilwis.exe" -C import shape (contourshp50.shp,DIV%shortfilename1%_50)

rem Select the appropriate cooordinate system as defined by the user

"%IlwDir%\ilwis.exe" -C setcsy DIV%shortfilename1%_50.mps %UtilDir%\mpef_div
"%IlwDir%\ilwis.exe" -C DIV%shortfilename1%_50.hss:=TableHistogramSeg(DIV%shortfilename1%_50)
"%IlwDir%\ilwis.exe" -C tabcalc DIV%shortfilename1%_50.tbt Length:=ColumnJoin(DIV%shortfilename1%_50.hss,Length)
"%IlwDir%\ilwis.exe" -C tabcalc DIV%shortfilename1%_50.tbt selected{dom=value;vr=-1000:1000:1}:=iff(Length gt 3,attribute,?)
"%IlwDir%\ilwis.exe" -C DIV%shortfilename1%_50.mpp:=PointMapPointInSegment(DIV%shortfilename1%_50.mps,Vertex)
"%IlwDir%\ilwis.exe" -C setatttable DIV%shortfilename1%_50.mpp DIV%shortfilename1%_50

"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\DIV_MSG%shortfilename1%'.mpr{dom=value.dom;vr=-1200.0000:1200.0000:0.0001}:=MapResample('%OutputDrive%\%OutputDir%\DIV%shortfilename1%','%UtilDir%\msg_0degree_DIV'.grf,nearest)
rem remove obsolete objects

del "%OutputDrive%\%OutputDir%\contour_temp.tif"

del "%OutputDrive%\%OutputDir%\contourshp25.dbf"
del "%OutputDrive%\%OutputDir%\contourshp25.shp"
del "%OutputDrive%\%OutputDir%\contourshp25.shx" 

del "%OutputDrive%\%OutputDir%\contourshp50.dbf"
del "%OutputDrive%\%OutputDir%\contourshp50.shp"
del "%OutputDrive%\%OutputDir%\contourshp50.shx" 


rem del "%OutputDrive%\%OutputDir%\DIV%shortfilename1%.grib"
del "%OutputDrive%\%OutputDir%\grib_div_band_1.mp*"
del "%OutputDrive%\%OutputDir%\grib_div.csy"
del "%OutputDrive%\%OutputDir%\grib_div.grf"
del "%OutputDrive%\%OutputDir%\grib_div.mpl"
del "%OutputDrive%\%OutputDir%\grib_div_band_2.mp*"
del "%OutputDrive%\%OutputDir%\grib_div_band_3.mp*"
del "%OutputDrive%\%OutputDir%\DIV%shortfilename1%.mp*"
del "%OutputDrive%\%OutputDir%\grib_div.mpr.aux.xml"



:END
"%IlwDir%\ilwis.exe" -C closeall