@echo off
echo NDVI-import
echo. 
echo output maps NDVI-Min, NDVI-Max, NDVI-Mean 
echo for NDVI min, max and mean if input less 100 map divided by 100
echo NDVI-accum not processed


set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
%OutputDrive%
cd %OutputDir%

set MSG_number=2


copy "%InputDrive%\%InputDir%\L-000-MSG?__-MPEF________-NDVI_____-000001___-%shortfilename1%-__*.*" 

if exist "%OutputDrive%\%OutputDir%\L-000-MSG2__-MPEF________-NDVI_____-000001___-%shortfilename1%-__*.*" GOTO START1

set MSG_number=3

if exist "%OutputDrive%\%OutputDir%\L-000-MSG3__-MPEF________-NDVI_____-000001___-%shortfilename1%-__*.*" GOTO START1

set MSG_number=4

:START1

if not exist "%OutputDrive%\%OutputDir%\L-000-MSG%MSG_number:~0,1%__-MPEF________-NDVI_____-000001___-%shortfilename1%-__*.*" goto MESSAGE

echo The file(s) "%InputDrive%\%InputDir%\L-000-MSG%MSG_number:~0,1%__-MPEF________-NDVI_____-000001___-%shortfilename1%-__*.*" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END


:START

"%UtilDir%\joinmsg.exe" "L-000-MSG%MSG_number:~0,1%__-MPEF________-NDVI_____-000001___-%shortfilename1%-__" %OutputDrive%\%OutputDir%\

rename "l-000-MSG?__-mpef________-ndvi_____-000001___-%shortfilename1%-__.xyz" NDVI%shortfilename1%.hdf

rem "%gdaldir%\gdal_translate.exe" -of ilwis hdf5:"NDVI%shortfilename1%.hdf"://NDVIaccum "%OutputDrive%\%OutputDir%\tNDVIaccum%shortfilename1%"
"%gdaldir%\gdal_translate.exe" -of ILWIS HDF5:"NDVI%shortfilename1%.hdf"://NDVImax "%OutputDrive%\%OutputDir%\tNDVImax%shortfilename1%"
"%gdaldir%\gdal_translate.exe" -of ILWIS HDF5:"NDVI%shortfilename1%.hdf"://NDVImean "%OutputDrive%\%OutputDir%\tNDVImean%shortfilename1%"
"%gdaldir%\gdal_translate.exe" -of ILWIS HDF5:"NDVI%shortfilename1%.hdf"://NDVImin "%OutputDrive%\%OutputDir%\tNDVImin%shortfilename1%"



"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\NDVImax_%shortfilename1%'.mpr:=iff('%OutputDrive%\%OutputDir%\tNDVImax%shortfilename1%' le 100,'%OutputDrive%\%OutputDir%\tNDVImax%shortfilename1%'/100,?);
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\NDVImean_%shortfilename1%'.mpr:=iff('%OutputDrive%\%OutputDir%\tNDVImean%shortfilename1%' le 100,'%OutputDrive%\%OutputDir%\tNDVImean%shortfilename1%'/100,?);
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\NDVImin_%shortfilename1%'.mpr:=iff('%OutputDrive%\%OutputDir%\tNDVImin%shortfilename1%' le 100,'%OutputDrive%\%OutputDir%\tNDVImin%shortfilename1%'/100,?);

"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\NDVImax_%shortfilename1%'.mpr %UtilDir%\msg_0degree_3km;
"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\NDVImean_%shortfilename1%'.mpr %UtilDir%\msg_0degree_3km;
"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\NDVImin_%shortfilename1%'.mpr %UtilDir%\msg_0degree_3km;



del "tndvimax%shortfilename1%".mp*
del "tndvimin%shortfilename1%".mp*
del "tndvimean%shortfilename1%".mp*

del "L-000-MSG?__-MPEF________-ndvi_____-00000?___-%shortfilename1%-__*

del ndvi%shortfilename1%.hdf


:END
"%IlwDir%\ilwis.exe" -C closeall