@echo off

echo NPP sea surface sub-skin temperature
echo SST obtained by regression with buoy measurements, sensitive to skin SST.
echo Input filename format expected is 20190204015000-OSPO-L3U_GHRSST-SSTsubskin-VIIRS_NPP-ACSPO_V2.61-v02.0-fv01.0.nc
echo Input filename format expected is 20200405215000-OSPO-L3U_GHRSST-SSTsubskin-VIIRS_NPP-ACSPO_V2.61-v02.0-fv01.0.nc
echo NPP surface winds (10 meters above the sea surface) from NCEP GFS data
echo unit is m s-1


set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8
set MODIS_DAY=%9

cd\
%OutputDrive%
cd %OutputDir%

echo %OutputDrive%\%OutputDir%




copy "%InputDrive%\%InputDir%\%shortfilename1%00-OSPO-L3U_GHRSST-SSTsubskin-VIIRS_NPP-ACSPO_V*-v02.0-fv01.0.nc" %OutputDrive%\%OutputDir%\*.*

if not exist "%OutputDrive%\%OutputDir%\%shortfilename1%00-OSPO-L3U_GHRSST-SSTsubskin-VIIRS_NPP-ACSPO_V*-v02.0-fv01.0.nc" goto MESSAGE

echo The file(s) "%InputDrive%\%InputDir%\%shortfilename1%00-OSPO-L3U_GHRSST-SSTsubskin-VIIRS_NPP-ACSPO_V*-v02.0-fv01.0.nc" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START




"%gdalDir%\gdal_translate" -of ilwis HDF5:"%shortfilename1%00-OSPO-L3U_GHRSST-SSTsubskin-VIIRS_NPP-ACSPO_V2.80-v02.0-fv01.0.nc"://sea_surface_temperature %OutputDrive%\%OutputDir%\tnppsst%shortfilename1%
"%gdalDir%\gdal_translate" -of ilwis HDF5:"%shortfilename1%00-OSPO-L3U_GHRSST-SSTsubskin-VIIRS_NPP-ACSPO_V2.80-v02.0-fv01.0.nc"://wind_speed %OutputDrive%\%OutputDir%\tnppws%shortfilename1%

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\npp_sst%shortfilename1%.mpr:=iff(%OutputDrive%\%OutputDir%\tnppsst%shortfilename1% gt 0,%OutputDrive%\%OutputDir%\tnppsst%shortfilename1%*0.0099999998+273.14999,?)
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\npp_sst%shortfilename1%.mpr %UtilDir%\npp_sst;

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\npp_ws%shortfilename1%.mpr:=iff(%OutputDrive%\%OutputDir%\tnppws%shortfilename1% gt 128,(%OutputDrive%\%OutputDir%\tnppws%shortfilename1%-128)*0.2,?)
REM "%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\npp_ws%shortfilename1%.mpr:=iff(%OutputDrive%\%OutputDir%\tnppws%shortfilename1% lt 128,%OutputDrive%\%OutputDir%\tnppws%shortfilename1%*0.15000001,?)
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\npp_ws%shortfilename1%.mpr %UtilDir%\npp_sst;


del %shortfilename1%00-OSPO-L3U_GHRSST-SSTsubskin-VIIRS_NPP-ACSPO_V2.80-v02.0-fv01.0.nc
del tnppsst%shortfilename1%%modis_day%.mp*
del tnppsst%shortfilename1%%modis_day%.aux.xml
del tnppws%shortfilename1%%modis_day%.mp*
del tnppws%shortfilename1%%modis_day%.aux.xml


:END
"%IlwDir%\ilwis.exe" -C closeall