@echo off 
echo Cloud Type and Phase Import
echo From Nowcasting SAF
echo For Northern portion MSG disk
echo At full MSG temporal resolution
rem Filename convention S_NWC_CT_MSG4_MSG-N-VISIR_20200405T044500Z.nc



set longfilename=%1
set shortfilename1=%longfilename:~0,8%
set shortfilename2=%longfilename:~8,4%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
%OutputDrive%
cd %OutputDir%

set MSG_number=2


echo *%outputDrive%\%OutputDir%*

copy "%inputDrive%\%InputDir%\S_NWC_CT_MSG4_MSG-N-VISIR_%shortfilename1%T%shortfilename2%00Z.nc" "%OutputDrive%\%OutputDir%\*.*"


if exist "%InputDrive%\%InputDir%\S_NWC_CT_MSG4_MSG-N-VISIR_%shortfilename1%T%shortfilename2%00Z.nc" GOTO START

set MSG_number=3

if exist "%InputDrive%\%InputDir%\S_NWC_CT_MSG4_MSG-N-VISIR_%shortfilename1%T%shortfilename2%00Z.nc" GOTO START

set MSG_number=4



:START1
if not exist "%OutputDrive%\%OutputDir%\S_NWC_CT_MSG%MSG_number:~0,1%_MSG-N-VISIR_%shortfilename1%T%shortfilename2%00Z.nc" goto MESSAGE

echo The file(s) "%InputDrive%\%InputDir%\S_NWC_CT_MSG%MSG_number:~0,1%_MSG-N-VISIR_%shortfilename1%T%shortfilename2%00Z.nc" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%%shortfilename2%
echo Check also if the data exists on your input directory - archive 


pause

GOTO END

:START

echo.
rem Cloud Type
echo Retrieve Cloud Type
echo.

"%GdalDir%\gdal_translate.exe" -of ilwis HDF5:"S_NWC_CT_MSG4_MSG-N-VISIR_%shortfilename1%T%shortfilename2%00Z.nc"://ct CT_ttype_%shortfilename1%%shortfilename2%.mpr

"%IlwDir%\ilwis.exe" -C CT_type_%shortfilename1%%shortfilename2%:=iff('%OutputDrive%\%OutputDir%\CT_ttype_%shortfilename1%%shortfilename2%' le 15, '%OutputDrive%\%OutputDir%\CT_ttype_%shortfilename1%%shortfilename2%',?)
"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\CT_type_%shortfilename1%%shortfilename2%'.mpr '%UtilDir%\nwc_kuband'.grf;


"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\NWC_CT_type_%shortfilename1%%shortfilename2%'.mpr{dom=NWC_ct_class.dom}:=MapSlicing('%OutputDrive%\%OutputDir%\CT_type_%shortfilename1%%shortfilename2%','%utildir%\NWC_ct_class'.dom)

del "%OutputDrive%\%OutputDir%\CT_ttype_%shortfilename1%%shortfilename2%.mpr.aux.xml"
del "%OutputDrive%\%OutputDir%\CT_ttype_%shortfilename1%%shortfilename2%.mp*"
del "%OutputDrive%\%OutputDir%\CT_type_%shortfilename1%%shortfilename2%.mp*"

del "%OutputDrive%\%OutputDir%\S_NWC_CT_MSG4_MSG-N-VISIR_%shortfilename1%T%shortfilename2%00Z.nc"

:END
"%IlwDir%\ilwis.exe" -C closeall