@echo off 
echo Mean Diffuse Attenuation Coefficient at 490nm
echo Kd_490 standard_name: volume attenuation coefficient of downwelling radiative flux in sea water
echo Kd_490 units = m-1
echo filename convention PML_Tanzania_MODIS_oc_3daycomp_20110328_20110331.nc.bz2



set longfilename=%1
set shortfilename1=%longfilename:~0,8%
set shortfilename2=%longfilename:~9,8%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
%OutputDrive%
cd %OutputDir%

echo *%outputDrive%\%OutputDir%*

copy %inputDrive%\%InputDir%\PML_Tanzania_MODIS_oc_3daycomp_%shortfilename1%_%shortfilename2%.nc.bz2 %OutputDrive%\%OutputDir%\*.*

if not exist "%OutputDrive%\%OutputDir%\PML_Tanzania_MODIS_oc_3daycomp_%shortfilename1%_%shortfilename2%.nc.bz2" goto MESSAGE

echo The file(s) "%InputDrive%\%InputDir%\PML_Tanzania_MODIS_oc_3daycomp_%shortfilename1%_%shortfilename2%" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%_%shortfilename2%
echo Check also if the data exists on your input directory - archive 
echo Note the 'start_end' timestamp of your data file

pause

GOTO END

:START

"%UtilDir%\7z" e PML_Tanzania_MODIS_oc_3daycomp_%shortfilename1%_%shortfilename2%.nc.bz2

"%GdalDir%\gdal_translate.exe" -of ilwis NETCDF:"PML_Tanzania_MODIS_oc_3daycomp_%shortfilename1%_%shortfilename2%.nc":Kd_490 %OutputDrive%\%OutputDir%\PML_Tanzania_MODIS_oc_3daycomp_%shortfilename1%_%shortfilename2%_Kd_490.mpr

"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\PML_Tanzania_MODIS_oc_3daycomp_%shortfilename1%_%shortfilename2%_Kd_490.mpr %UtilDir%\pml_modis_Tanzania.grf;

del PML_Tanzania_MODIS_oc_3daycomp_%shortfilename1%_%shortfilename2%_Kd_490.csy
del PML_Tanzania_MODIS_oc_3daycomp_%shortfilename1%_%shortfilename2%_Kd_490.grf
del PML_Tanzania_MODIS_oc_3daycomp_%shortfilename1%_%shortfilename2%.nc.bz2
del PML_Tanzania_MODIS_oc_3daycomp_%shortfilename1%_%shortfilename2%.nc
del PML_Tanzania_MODIS_oc_3daycomp_%shortfilename1%_%shortfilename2%_Kd_490.mpr.aux.xml


:END
"%IlwDir%\ilwis.exe" -C closeall