@echo off 
echo 10-daily Burnt Area 333m - 10-day composite
echo file name expected is: ba300_v1_333m:BA300_yyyymmdd0000_SOAM_PROBAV_V1.1.1
echo output BA map is a value map, valid value ranges from 33289 to 65535
echo Layer extracted is FDOB_DEKAD
echo First date of burn in the dekad
echo Proba BA, the physical range of FDOB is [33289, 65535], as is the Digital Number range. 
echo The value indicates:
echo 0 = no burn scar detected in the dekad
echo 254 = ocean flag
echo 255 = no data present (missing tile) during entire dekad 
echo YYDDD in range [33289, 65365] = the burn scar was detected at day YYDDD; where YY
echo represents the Julian calendar year since 1980 and DDD is day of year; YYDDD is a date in the dekad
echo See https://land.copernicus.eu/global/sites/cgls.vito.be/files/products/CGLOPS1_PUM_BA300m-V1_I1.40.pdf
echo all values below - equal 255 are omitted

echo Display using logarithmic stretch

set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8


cd\
%OutputDrive%
cd %OutputDir%


set longfilename=%1
set shortfilename1=%longfilename:~0,8%


copy %inputDrive%\%InputDir%\c_gls_BA300_%shortfilename1%0000_SOAM_PROBAV_V*.zip 
ren c_gls_BA300_%shortfilename1%0000_SOAM_PROBAV_V*.zip BA_%shortfilename1%0000_SOAM.ZIP

if not exist "%OutputDrive%\%OutputDir%\BA_%shortfilename1%0000_SOAM.ZIP" goto MESSAGE

echo The file(s) "%InputDrive%\%InputDir%\BA_%shortfilename1%0000_SOAM.ZIP" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START



%UtilDir%\7z e BA_%shortfilename1%0000_SOAM.ZIP %shortfilename1%/c_gls_BA300_%shortfilename1%0000_SOAM_PROBAV_V*.NC



ren c_gls_BA300_%shortfilename1%0000_SOAM_PROBAV_V*.NC proba_BA%shortfilename1%.NC



"%GdalDir%\gdal_translate.exe" -ot Float64 -of ilwis HDF5:"proba_BA%shortfilename1%.nc"://FDOB_DEKAD BA_p_%shortfilename1%.mpr


"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\BA_p_%shortfilename1%'.mpr '%UtilDir%\Proba_V_LA333';

"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\Proba_BA%shortfilename1%_LA'.mpr:=iff('%OutputDrive%\%OutputDir%\BA_p_%shortfilename1%' gt 255,'%OutputDrive%\%OutputDir%\BA_p_%shortfilename1%',?)


del BA_p_%shortfilename1%.mp* 

del proba_BA%shortfilename1%.NC
del BA_%shortfilename1%0000_SOAM.ZIP
del BA_p_%shortfilename1%.mpr.aux.xml


:END
"%IlwDir%\ilwis.exe" -C closeall