@echo off
echo Extract Chirps Africa Dekad Precipitation
echo Precipitation in mm/dekad
echo dekad 1 = 0-10, dekad 2= 11-20, dekad 3= 21 to end of month
echo File name format chirps-v2.0.1981.01.1.tif.gz

rem most dat is zipped but not all (like recent data)
rem routine processes both zipped and non-zipped data

echo.
echo.

set longfilename=%1
set shortfilename1=%longfilename:~0,4%
set shortfilename2=%longfilename:~4,2%
set shortfilename3=%longfilename:~6,1%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8


cd\
%OutputDrive%
cd %OutputDir%


echo your current working directory = %OutputDrive%\%OutputDir%
echo.
echo.

"%UtilDir%\wget\wget.exe" --no-check-certificate  "https://data.chc.ucsb.edu/products/CHIRPS-2.0/africa_dekad/tifs/chirps-v2.0.%shortfilename1%.%shortfilename2%.%shortfilename3%.tif.gz"
if exist "chirps-v2.0.%shortfilename1%.%shortfilename2%.%shortfilename3%.t*" goto NEXT
"%UtilDir%\wget\wget.exe" --no-check-certificate  "https://data.chc.ucsb.edu/products/CHIRPS-2.0/africa_dekad/tifs/chirps-v2.0.%shortfilename1%.%shortfilename2%.%shortfilename3%.tif"


:NEXT
echo off
if not exist "chirps-v2.0.%shortfilename1%.%shortfilename2%.%shortfilename3%.t*"  goto MESSAGE
echo The file(s) "chirps-v2.0.%shortfilename1%.%shortfilename2%.d%shortfilename3%" has been retrieved and transferred to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found in the archive.
echo Check your Date stamp settings
echo Your current Date stamp used is %shortfilename1%%shortfilename2%d%shortfilename3%
echo Data is retrieved from https://data.chc.ucsb.edu/products/CHIRPS-2.0/africa_dekad/tifs/
echo Check also manually if the data exists on ftp archive (see link above)
echo Internet has a transient nature - addresses might not be valid or has changed after some time!


pause

GOTO END

:START

if not exist "%OutputDrive%\%OutputDir%\chirps-v2.0.%shortfilename1%.%shortfilename2%.%shortfilename3%.tif.gz" goto START1

"%UtilDir%\7z.exe" e chirps-v2.0.%shortfilename1%.%shortfilename2%.%shortfilename3%.tif.gz

:START1

rename "chirps-v2.0.%shortfilename1%.%shortfilename2%.%shortfilename3%.tif" chirps_%shortfilename1%%shortfilename2%%shortfilename3%.tif

"%GdalDir%\gdal_translate.exe" -of ilwis %OutputDrive%\%OutputDir%\chirps_%shortfilename1%%shortfilename2%%shortfilename3%.tif %OutputDrive%\%OutputDir%\chirpsA_%shortfilename1%%shortfilename2%%shortfilename3%.mpr
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\chirps_Africa_%shortfilename1%%shortfilename2%d%shortfilename3%'.mpr{dom=value;vr=0:10000:0.01}:=iff('%OutputDrive%\%OutputDir%\chirpsA_%shortfilename1%%shortfilename2%%shortfilename3%' ge 0,'%OutputDrive%\%OutputDir%\chirpsA_%shortfilename1%%shortfilename2%%shortfilename3%',?)

rem delete obsolete objects

if exist "%OutputDrive%\%OutputDir%\chirps-v2.0.%shortfilename1%.%shortfilename2%.%shortfilename3%.tif.gz" del "%OutputDrive%\%OutputDir%\chirps-v2.0.%shortfilename1%.%shortfilename2%.%shortfilename3%.tif.gz"
del "%OutputDrive%\%OutputDir%\chirps_%shortfilename1%%shortfilename2%%shortfilename3%.tif"
del "%OutputDrive%\%OutputDir%\chirpsA_%shortfilename1%%shortfilename2%%shortfilename3%.mp*"



:END
"%IlwDir%\ilwis.exe" -C closeall