@echo off
rem Import GPM Level 2 rainfall (mm/hr)
rem As 5 minutes orbit files,
rem gdal import as xyz ascii
rem file old name convention 2A.GPM.GMI.GPROF2014v1-4.20150915-S133140-E133638.V03E.RT-H5
rem file new name convention 2A.GPM.GMI.GPROF2017v1.20190202-S224639-E225137.V05B.RT-H5
rem file new name convention 2A.GPM.GMI.GPROF2021v1.20220630-S112723-E113221.V07A.RT-H5

set longfilename=%1
set shortfilename1=%longfilename:~23,8%
set shortfilename2=%longfilename:~33,6%
set shortfilename3=%longfilename:~41,6%

echo.
echo.
echo processing GPM_%shortfilename1%_%shortfilename2%_%shortfilename3%
echo.
echo.


call inputparam.bat

rename "2A.GPM.GMI.GPROF20*v1.%shortfilename1%-S%shortfilename2%-E%shortfilename3%.V0*.RT-H5" GPM_%shortfilename1%_%shortfilename2%_%shortfilename3%.H5


"%GdalDir%\gdal_translate.exe" -of xyz -q hdf5:"GPM_%shortfilename1%_%shortfilename2%_%shortfilename3%.H5"://S1/Latitude lat.xyz
"%GdalDir%\gdal_translate.exe" -of xyz -q hdf5:"GPM_%shortfilename1%_%shortfilename2%_%shortfilename3%.H5"://S1/Longitude lon.xyz
"%GdalDir%\gdal_translate.exe" -of xyz -q hdf5:"GPM_%shortfilename1%_%shortfilename2%_%shortfilename3%.H5"://S1/surfacePrecipitation prec.xyz


rem import tables in ilwis


"%IlwDir%\ilwis.exe" -C latxyz.tbt=table(lat.xyz,Space,Convert,none,c1(value.dom{0:25000:0.01}),c2(value.dom{0:25000:0.01}),Y(value.dom{-90:90:0.000000001}))

"%IlwDir%\ilwis.exe" -C GPM_%shortfilename1%_%shortfilename2%_%shortfilename3%.tbt=table(lon.xyz,Space,Convert,none,c1(value.dom{0:25000:0.01}),c2(value.dom{0:25000:0.01}),X(value.dom{-180:180:0.000000001}))

"%IlwDir%\ilwis.exe" -C precxyz.tbt=table(prec.xyz,Space,Convert,none,c1(value.dom{0:25000:0.01}),c2(value.dom{0:25000:0.01}),Precipitation(value.dom{0:1000:0.000000001}))

rem use table lonxyz as first table and join other tables

"%IlwDir%\ilwis.exe" -C tabcalc GPM_%shortfilename1%_%shortfilename2%_%shortfilename3%.tbt Y:=ColumnJoin(latxyz.tbt,Y)
"%IlwDir%\ilwis.exe" -C tabcalc GPM_%shortfilename1%_%shortfilename2%_%shortfilename3%.tbt Precipitation:=ColumnJoin(precxyz.tbt,Precipitation)
"%IlwDir%\ilwis.exe" -C tabcalc GPM_%shortfilename1%_%shortfilename2%_%shortfilename3%.tbt prec_more01:=iff(precipitation ge 0.1,precipitation,?)

"%IlwDir%\ilwis.exe" -C GPM_%shortfilename1%_%shortfilename2%_%shortfilename3%.mpp:=PointMapFromTable(GPM_%shortfilename1%_%shortfilename2%_%shortfilename3%,LatlonWGS84,prec_more01)
"%IlwDir%\ilwis.exe" -C GPM_%shortfilename1%_%shortfilename2%_%shortfilename3%.mpr{dom=value;vr=0:750:0.000001}:=MapRasterizePoint(GPM_%shortfilename1%_%shortfilename2%_%shortfilename3%,gpm_2_5min.grf,2)

rem export table to comma delimited

"%IlwDir%\ilwis.exe" -C export Delimited(GPM_%shortfilename1%_%shortfilename2%_%shortfilename3%.tbt,GPM_%shortfilename1%_%shortfilename2%_%shortfilename3%)

del "%OutputDrive%\%OutputDir%\GPM_%shortfilename1%_%shortfilename2%_%shortfilename3%.H5"
del "%OutputDrive%\%OutputDir%\lat.xyz"
del "%OutputDrive%\%OutputDir%\lon.xyz"
del "%OutputDrive%\%OutputDir%\prec.xyz"
del "%OutputDrive%\%OutputDir%\latxyz.tb*"
del "%OutputDrive%\%OutputDir%\precxyz.tb*"


