/*
 * Decompiled with CFR 0.152.
 */
package org.n52.math;

import Jama.Matrix;
import org.n52.math.ColumnVector;

public class Vector3D
extends ColumnVector {
    private static double epsilon = 1.0E-10;

    public static void setEpsilon(double eps) {
        epsilon = eps;
    }

    public Vector3D(Matrix mat) {
        super(3);
        int i = 0;
        while (i < 3) {
            this.set(i, mat.get(i, 0));
            ++i;
        }
    }

    public Vector3D(double[] V) {
        super(V, 3);
    }

    public Vector3D(double a, double b, double c) {
        super(3);
        this.set(0, a);
        this.set(1, b);
        this.set(2, c);
    }

    public Vector3D() {
        super(3);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Vector3D) {
            Vector3D vec = (Vector3D)((Object)obj);
            if (Math.abs(this.get(0) - vec.get(0)) + Math.abs(this.get(1) - vec.get(1)) + Math.abs(this.get(2) - vec.get(2)) < epsilon) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.get(0)) + "," + this.get(1) + "," + this.get(2);
    }

    public Vector3D plus(Vector3D v) {
        return new Vector3D(super.plus((Matrix)v));
    }

    public Vector3D minus(Vector3D v) {
        return new Vector3D(super.minus((Matrix)v));
    }

    public Vector3D times(double s) {
        return new Vector3D(super.times(s));
    }

    public Vector3D crossProduct(ColumnVector vec2) {
        Vector3D result = new Vector3D();
        result.set(0, this.get(1) * vec2.get(2) - this.get(2) * vec2.get(1));
        result.set(1, this.get(2) * vec2.get(0) - this.get(0) * vec2.get(2));
        result.set(2, this.get(0) * vec2.get(1) - this.get(1) * vec2.get(0));
        return result;
    }
}

