/*
 * Decompiled with CFR 0.152.
 */
package org.n52.math.testforms;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import org.n52.math.Algorithm;

public class AlgorithmForm
extends JFrame {
    public AlgorithmForm(Algorithm alg) {
        this(alg, null);
    }

    public AlgorithmForm(Algorithm alg, double[] defaults) {
        this(alg, defaults, false);
    }

    public AlgorithmForm(final Algorithm alg, double[] defaults, final boolean useMessageBox) {
        JTextArea resultText;
        JFormattedTextField resultField;
        JPanel mainPanel = new JPanel();
        final String title = alg.getName();
        if (title == null) {
            throw new IllegalArgumentException("No Name available in Algortihm");
        }
        this.setTitle(title);
        String description = alg.getDescription();
        if (description == null) {
            throw new IllegalArgumentException("No Description available in Algortihm");
        }
        JTextArea textArea = new JTextArea(description);
        textArea.setLineWrap(true);
        textArea.setFocusable(false);
        textArea.setBackground(mainPanel.getBackground());
        this.add((Component)textArea, "North");
        final int nrParams = alg.getNrParams();
        if (nrParams <= 0) {
            throw new IllegalArgumentException("Negative number of parameters not allowed");
        }
        if (nrParams > 1000) {
            throw new IllegalArgumentException("More than 1000 parameters not allowed");
        }
        if (defaults != null && defaults.length != nrParams) {
            throw new IllegalArgumentException(String.format("defaults shoulds have %1d number of values", nrParams));
        }
        mainPanel.setBorder(BorderFactory.createEmptyBorder());
        mainPanel.setLayout(new SpringLayout());
        this.add((Component)mainPanel, "Center");
        final JFormattedTextField[] fields = new JFormattedTextField[nrParams];
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumFractionDigits(1);
        numberFormat.setMaximumFractionDigits(12);
        int i = 0;
        while (i < nrParams) {
            String text = alg.getParamName(i);
            if (text == null) {
                throw new IllegalArgumentException(String.format("Parameter %1d has no name", i));
            }
            mainPanel.add(new JLabel(text));
            fields[i] = new JFormattedTextField(numberFormat);
            if (defaults != null) {
                fields[i].setValue(new Double(defaults[i]));
            } else {
                fields[i].setValue(new Double(0.0));
            }
            fields[i].setColumns(8);
            mainPanel.add(fields[i]);
            String descr = alg.getParamDescription(i);
            if (descr == null) {
                descr = "no description available";
            }
            JTextArea descrArea = new JTextArea(descr);
            descrArea.setFocusable(false);
            descrArea.setBackground(mainPanel.getBackground());
            mainPanel.add(descrArea);
            ++i;
        }
        if (!useMessageBox) {
            mainPanel.add(new JLabel("Result"));
            resultField = new JFormattedTextField(numberFormat);
            resultField.setBackground(mainPanel.getBackground());
            resultField.setFocusable(false);
            mainPanel.add(resultField);
            resultText = new JTextArea();
            resultText.setFocusable(false);
            resultText.setBackground(mainPanel.getBackground());
            mainPanel.add(resultText);
            AlgorithmForm.makeCompactGrid(mainPanel, nrParams + 1, 3, 5, 5, 5, 5);
        } else {
            resultField = null;
            resultText = null;
            AlgorithmForm.makeCompactGrid(mainPanel, nrParams, 3, 5, 5, 5, 5);
        }
        JPanel buttonPanel = new JPanel();
        JButton calcButton = new JButton("Calculate");
        buttonPanel.add(calcButton);
        JButton closeButton = new JButton("Close");
        buttonPanel.add(closeButton);
        this.add((Component)buttonPanel, "South");
        calcButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StringBuilder msg = new StringBuilder();
                msg.append("The result of ").append(title).append("(");
                double[] params = new double[nrParams];
                int i = 0;
                while (i < nrParams) {
                    if (i != 0) {
                        msg.append(", ");
                    }
                    params[i] = ((Number)fields[i].getValue()).doubleValue();
                    msg.append(params[i]);
                    ++i;
                }
                msg.append(")");
                double result = alg.calculate(params);
                if (useMessageBox) {
                    msg.append(" is: \n");
                    msg.append(result);
                    JOptionPane.showMessageDialog(null, msg, "Result", 0);
                } else {
                    resultField.setValue(new Double(result));
                }
            }
        });
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AlgorithmForm.this.setVisible(false);
                AlgorithmForm.this.dispose();
            }
        });
        this.pack();
        this.setLocationByPlatform(true);
    }

    private static void makeCompactGrid(Container parent, int rows, int cols, int initialX, int initialY, int xPad, int yPad) {
        SpringLayout layout;
        try {
            layout = (SpringLayout)parent.getLayout();
        }
        catch (ClassCastException exc) {
            System.err.println("The first argument to makeCompactGrid must use SpringLayout.");
            return;
        }
        Spring x = Spring.constant(initialX);
        int c = 0;
        while (c < cols) {
            Spring width = Spring.constant(0);
            int r = 0;
            while (r < rows) {
                width = Spring.max(width, AlgorithmForm.getConstraintsForCell(r, c, parent, cols).getWidth());
                ++r;
            }
            r = 0;
            while (r < rows) {
                SpringLayout.Constraints constraints = AlgorithmForm.getConstraintsForCell(r, c, parent, cols);
                constraints.setX(x);
                constraints.setWidth(width);
                ++r;
            }
            x = Spring.sum(x, Spring.sum(width, Spring.constant(xPad)));
            ++c;
        }
        Spring y = Spring.constant(initialY);
        int r = 0;
        while (r < rows) {
            Spring height = Spring.constant(0);
            int c2 = 0;
            while (c2 < cols) {
                height = Spring.max(height, AlgorithmForm.getConstraintsForCell(r, c2, parent, cols).getHeight());
                ++c2;
            }
            c2 = 0;
            while (c2 < cols) {
                SpringLayout.Constraints constraints = AlgorithmForm.getConstraintsForCell(r, c2, parent, cols);
                constraints.setY(y);
                constraints.setHeight(height);
                ++c2;
            }
            y = Spring.sum(y, Spring.sum(height, Spring.constant(yPad)));
            ++r;
        }
        SpringLayout.Constraints pCons = layout.getConstraints(parent);
        pCons.setConstraint("South", y);
        pCons.setConstraint("East", x);
    }

    private static SpringLayout.Constraints getConstraintsForCell(int row, int col, Container parent, int cols) {
        SpringLayout layout = (SpringLayout)parent.getLayout();
        Component c = parent.getComponent(row * cols + col);
        return layout.getConstraints(c);
    }
}

