/*
 * Decompiled with CFR 0.152.
 */
package org.n52.operation.cropmodeling;

import java.util.ArrayList;
import java.util.List;
import org.n52.operation.cropmodeling.GridDayWeatherData;
import org.n52.operation.cropmodeling.JulianTime;
import org.n52.operation.cropmodeling.TimeTemperature;
import org.n52.operation.cropmodeling.WeatherData;

public class GridWeatherData
extends WeatherData {
    private double[] temperatures = null;
    private int year;
    private JulianTime startTime;
    private double timeResolution = 15.0;
    private double[] outputData;
    private double[] outputTemperatures;

    public GridWeatherData() {
        JulianTime jt1jan = new JulianTime(0.0, this.year, 1.0);
        this.setDayWeatherData(jt1jan, new GridDayWeatherData(jt1jan));
        JulianTime jt = new JulianTime(0.0, this.year, 12.0);
        while (jt.getCurrentJulianDay() < 365) {
            this.setDayWeatherData(jt, new GridDayWeatherData(jt));
            JulianTime later = JulianTime.add(jt, 15.0);
            this.setDayWeatherData(later, new GridDayWeatherData(later));
            jt = JulianTime.add(jt, 24.0);
        }
    }

    public void setTemperatures(double[] temperatures, JulianTime startTime, double resolution) {
        this.temperatures = temperatures;
        this.startTime = startTime;
        this.timeResolution = resolution;
        this.year = startTime.getYear();
        this.setLatitude(startTime.getAtLatitude());
        this.initializeOutput();
    }

    public double[] getOutputData() {
        return this.outputData;
    }

    public double[] getOutputTemperatures() {
        return this.outputTemperatures;
    }

    private void initializeOutput() {
        this.outputData = new double[this.temperatures.length];
        this.outputTemperatures = new double[this.temperatures.length];
        int i = 0;
        while (i < this.outputData.length) {
            this.outputData[i] = Double.NaN;
            this.outputTemperatures[i] = Double.NaN;
            ++i;
        }
    }

    TimeTemperature[] getTemperatures(JulianTime now) {
        ArrayList<TimeTemperature> temps = new ArrayList<TimeTemperature>();
        JulianTime.JulianPeriod period = now.getTimeIntervalBoundaries();
        JulianTime next = period.getBeginTime().clone();
        double hours = period.getBeginTime().getYearHours() - this.startTime.getYearHours();
        if (hours < 0.0) {
            hours = 0.0;
            next = this.startTime.clone();
        }
        int firstIndex = (int)(hours * 60.0 / this.timeResolution);
        hours = period.getEndTime().getYearHours() - this.startTime.getYearHours();
        int lastIndex = 1 + (int)(hours * 60.0 / this.timeResolution);
        lastIndex = Math.min(lastIndex, this.temperatures.length);
        int index = firstIndex;
        while (index < lastIndex) {
            TimeTemperature tt = new TimeTemperature();
            tt.setTime(next);
            tt.setTemperature(this.temperatures[index]);
            if (!Double.isNaN(tt.getTemperature())) {
                temps.add(tt);
            }
            next = JulianTime.add(next, this.timeResolution / 60.0);
            ++index;
        }
        return temps.toArray(new TimeTemperature[0]);
    }

    double getCurrentTemperatureFromData(JulianTime time) {
        double hours = time.getYearHours() - this.startTime.getYearHours();
        int index = (int)(hours * 60.0 / this.timeResolution);
        if (index < 0 || index > this.temperatures.length) {
            throw new IndexOutOfBoundsException("Trying to access temperatures out of range");
        }
        return this.temperatures[index];
    }

    void writeData(JulianTime time, Object data) {
        List list = (List)data;
        double hours = time.getYearHours() - this.startTime.getYearHours();
        int index = (int)(hours * 60.0 / this.timeResolution);
        this.outputTemperatures[index] = (Double)list.get(0);
        this.outputData[index] = (Double)list.get(1);
    }

    JulianTime getBeginMeasurements() {
        return this.startTime.clone();
    }

    JulianTime getEndMeasurements() {
        double hours = (double)this.temperatures.length * this.timeResolution / 60.0;
        return new JulianTime(this.getLatitude(), this.year, hours + this.startTime.getYearHours());
    }
}

