/*
 * Decompiled with CFR 0.152.
 */
package org.n52.math.test;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.n52.math.TerrainTriangulation;
import org.n52.math.Vector3D;

public class TerrainTriangulationTest
extends TestCase {
    private TerrainTriangulation wgs84;
    private TerrainTriangulation unitSphere;
    private final double EQRADIUSWGS84 = 6378137.0;
    private final double INVFWGS84 = 298.257223563;

    protected void setUp() throws Exception {
        super.setUp();
        this.wgs84 = new TerrainTriangulation(6378137.0, 298.257223563);
        this.unitSphere = new TerrainTriangulation(1.0, Double.POSITIVE_INFINITY);
        Vector3D.setEpsilon(1.0E-5);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSphereTerrainPositionVector00() {
        Vector3D vec00 = this.unitSphere.getTerrainPositionVector(0.0, 0.0);
        Assert.assertEquals((Object)this.unitSphere.getLam(), (Object)0.0);
        Assert.assertEquals((Object)this.unitSphere.getPhi(), (Object)0.0);
        Assert.assertEquals((Object)((Object)vec00), (Object)((Object)new Vector3D(1.0, 0.0, 0.0)));
    }

    public void testSphereTerrainPositionVectorNorthPole() {
        Vector3D vecNorthPole = this.unitSphere.getTerrainPositionVector(90.0, 0.0);
        Assert.assertEquals((Object)this.unitSphere.getLam(), (Object)0.0);
        Assert.assertEquals((Object)this.unitSphere.getPhi(), (Object)1.5707963267948966);
        Assert.assertEquals((Object)((Object)vecNorthPole), (Object)((Object)new Vector3D(0.0, 0.0, 1.0)));
    }

    public void testWgs84TerrainPositionVector00() {
        Vector3D vec00 = this.wgs84.getTerrainPositionVector(0.0, 0.0);
        Assert.assertEquals((Object)this.wgs84.getLam(), (Object)0.0);
        Assert.assertEquals((Object)this.wgs84.getPhi(), (Object)0.0);
        Assert.assertEquals((Object)((Object)vec00), (Object)((Object)new Vector3D(6378137.0, 0.0, 0.0)));
    }

    public void testWgs84TerrainPositionVectorNorthPole() {
        Vector3D vecNorthPole = this.wgs84.getTerrainPositionVector(90.0, 0.0);
        Assert.assertEquals((Object)this.wgs84.getLam(), (Object)0.0);
        Assert.assertEquals((Object)this.wgs84.getPhi(), (Object)1.5707963267948966);
        Assert.assertEquals((Object)((Object)vecNorthPole), (Object)((Object)new Vector3D(0.0, 0.0, 6356752.314245179)));
    }

    public void testWgs84TerrainPositionVectorSouthPole() {
        Vector3D vecSouthPole = this.wgs84.getTerrainPositionVector(-90.0, 0.0);
        Assert.assertEquals((Object)this.wgs84.getLam(), (Object)0.0);
        Assert.assertEquals((Object)this.wgs84.getPhi(), (Object)-1.5707963267948966);
        Assert.assertEquals((Object)((Object)vecSouthPole), (Object)((Object)new Vector3D(0.0, 0.0, -6356752.314245179)));
    }

    public void testWgs84TerrainPositionVectorEnschede() {
        Vector3D vecNorthPole = this.wgs84.getTerrainPositionVector(52.24, 6.91);
        Assert.assertEquals((Object)this.wgs84.getLam(), (Object)0.12060225131280816);
        Assert.assertEquals((Object)this.wgs84.getPhi(), (Object)0.9117600012418378);
        Assert.assertEquals((Object)((Object)vecNorthPole), (Object)((Object)new Vector3D(3885453.456566, 470879.617127, 5019200.2857124)));
    }

    public void testWgs84TerrainPositionVectorAntipod() {
        Vector3D vecSouthPole = this.wgs84.getTerrainPositionVector(-52.24, -173.09);
        Assert.assertEquals((Object)this.wgs84.getLam(), (Object)-3.0209904022769853);
        Assert.assertEquals((Object)this.wgs84.getPhi(), (Object)-0.9117600012418378);
        Assert.assertEquals((Object)((Object)vecSouthPole), (Object)((Object)new Vector3D(-3885453.456566, -470879.617127, -5019200.2857124)));
    }

    public void testWgs84UnitVerticalVectorEnschede() {
        Vector3D vecEnschede = this.wgs84.getUnitVerticalVector(52.24, 6.91);
        Assert.assertEquals((Object)this.wgs84.getLam(), (Object)0.12060225131280816);
        Assert.assertEquals((Object)this.wgs84.getPhi(), (Object)0.9117600012418378);
        Assert.assertEquals((Object)((Object)vecEnschede), (Object)((Object)new Vector3D(Math.cos(0.12060225131280816) * Math.cos(0.9117600012418378), Math.sin(0.12060225131280816) * Math.cos(0.9117600012418378), Math.sin(0.9117600012418378))));
    }

    public void testWgs84UnitVerticalVectorAntipod() {
        Vector3D vecSouth = this.wgs84.getUnitVerticalVector(-52.24, -173.09);
        Assert.assertEquals((Object)this.wgs84.getLam(), (Object)-3.0209904022769853);
        Assert.assertEquals((Object)this.wgs84.getPhi(), (Object)-0.9117600012418378);
        Assert.assertEquals((Object)((Object)vecSouth), (Object)((Object)new Vector3D(Math.cos(-3.0209904022769853) * Math.cos(-0.9117600012418378), Math.sin(-3.0209904022769853) * Math.cos(-0.9117600012418378), Math.sin(-0.9117600012418378))));
    }
}

