/*
 * Decompiled with CFR 0.152.
 */
package org.n52.operation.smac;

import org.n52.math.Algorithm;
import org.n52.operation.smac.ReflectanceAlgorithm;

public class ReflectanceFromRadianceForMSG {
    private final int year;
    private final int month;
    private final int day;
    private final int hours;
    private final int mins;
    private final double[] rtoaArray = new double[]{20.76, 23.24, 19.85, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 25.11};

    public ReflectanceFromRadianceForMSG(String timeStamp) {
        this.year = Integer.parseInt(timeStamp.substring(0, 4));
        this.month = Integer.parseInt(timeStamp.substring(4, 2));
        this.day = Integer.parseInt(timeStamp.substring(6, 2));
        this.hours = Integer.parseInt(timeStamp.substring(8, 2));
        this.mins = Integer.parseInt(timeStamp.substring(10, 2));
    }

    public Algorithm getReflectanceAlgorithm(int channel) {
        int index = channel - 1;
        double rtoa = this.rtoaArray[index];
        if (rtoa <= 0.0) {
            throw new IllegalArgumentException("Only visible channels allowed");
        }
        return new ReflectanceAlgorithm(this.year, this.month, this.day, this.hours, this.mins, rtoa);
    }
}

