/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl.node;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Durability;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.PutMode;
import com.sleepycat.je.log.DbOpReplicationContext;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.entry.DbOperationType;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.log.entry.NameLNLogEntry;
import com.sleepycat.je.log.entry.SingleItemEntry;
import com.sleepycat.je.recovery.RecoveryInfo;
import com.sleepycat.je.recovery.RollbackTracker;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.impl.node.ReplayStatDefinition;
import com.sleepycat.je.rep.stream.InputWireRecord;
import com.sleepycat.je.rep.stream.MasterStatus;
import com.sleepycat.je.rep.stream.Protocol;
import com.sleepycat.je.rep.txn.ReplayTxn;
import com.sleepycat.je.rep.utilint.BinaryProtocol;
import com.sleepycat.je.rep.utilint.NamedChannel;
import com.sleepycat.je.rep.vlsn.VLSNRange;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.NameLN;
import com.sleepycat.je.txn.RollbackEnd;
import com.sleepycat.je.txn.RollbackStart;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.txn.TxnAbort;
import com.sleepycat.je.txn.TxnCommit;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.LongMaxStat;
import com.sleepycat.je.utilint.LongMinStat;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.VLSN;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Replay {
    private static final String RBSTATUS_START = "Started Rollback";
    private static final String RBSTATUS_NO_ACTIVE = "No active txns, nothing to rollback";
    private static final String RBSTATUS_RANGE_EQUALS = "End of range equals matchpoint, nothing to rollback";
    private static final String RBSTATUS_LOG_RBSTART = "Logged RollbackStart entry";
    private static final String RBSTATUS_MEM_ROLLBACK = "Finished in-memory rollback";
    private static final String RBSTATUS_INVISIBLE = "Finished invisible setting";
    private static final String RBSTATUS_FINISH = "Finished rollback";
    private final RepImpl repImpl;
    private final long ackTimeoutLogThresholdInNanos;
    private final ConcurrentMap<Long, ReplayTxn> activeTxns;
    private volatile TxnInfo lastReplayedTxn = null;
    private volatile VLSN lastReplayedVLSN = null;
    private final Durability.SyncPolicy noAckSyncPolicy = Durability.SyncPolicy.NO_SYNC;
    private final StatGroup statistics;
    private final LongStat nCommits;
    private final LongStat nCommitAcks;
    private final LongStat nCommitSyncs;
    private final LongStat nCommitNoSyncs;
    private final LongStat nCommitWriteNoSyncs;
    private final LongStat nAborts;
    private final LongStat nNameLNs;
    private final LongStat nLNs;
    private final LongStat nElapsedTxnTime;
    private final LongMinStat minCommitProcessingNanos;
    private final LongMaxStat maxCommitProcessingNanos;
    private final LongStat totalCommitProcessingNanos;
    private final Logger logger;

    public Replay(RepImpl repImpl, NameIdPair nameIdPair) {
        if (repImpl.isReadOnly()) {
            throw EnvironmentFailureException.unexpectedState("Replay created with readonly ReplicatedEnvironment");
        }
        this.repImpl = repImpl;
        this.ackTimeoutLogThresholdInNanos = (long)repImpl.getConfigManager().getDuration(RepParams.REPLICA_ACK_TIMEOUT) * 1000000L;
        this.activeTxns = new ConcurrentHashMap<Long, ReplayTxn>();
        this.logger = LoggerUtils.getLogger(this.getClass());
        this.statistics = new StatGroup("Replay", "The Replay unit applies the incoming replication stream at a Replica. These stats show the load the Replica incurs when processing updates.");
        this.nCommits = new LongStat(this.statistics, ReplayStatDefinition.N_COMMITS);
        this.nCommitAcks = new LongStat(this.statistics, ReplayStatDefinition.N_COMMIT_ACKS);
        this.nCommitSyncs = new LongStat(this.statistics, ReplayStatDefinition.N_COMMIT_SYNCS);
        this.nCommitNoSyncs = new LongStat(this.statistics, ReplayStatDefinition.N_COMMIT_NO_SYNCS);
        this.nCommitWriteNoSyncs = new LongStat(this.statistics, ReplayStatDefinition.N_COMMIT_WRITE_NO_SYNCS);
        this.nAborts = new LongStat(this.statistics, ReplayStatDefinition.N_ABORTS);
        this.nNameLNs = new LongStat(this.statistics, ReplayStatDefinition.N_NAME_LNS);
        this.nLNs = new LongStat(this.statistics, ReplayStatDefinition.N_LNS);
        this.nElapsedTxnTime = new LongStat(this.statistics, ReplayStatDefinition.N_ELAPSED_TXN_TIME);
        this.minCommitProcessingNanos = new LongMinStat(this.statistics, ReplayStatDefinition.MIN_COMMIT_PROCESSING_NANOS);
        this.maxCommitProcessingNanos = new LongMaxStat(this.statistics, ReplayStatDefinition.MAX_COMMIT_PROCESSING_NANOS);
        this.totalCommitProcessingNanos = new LongStat(this.statistics, ReplayStatDefinition.TOTAL_COMMIT_PROCESSING_NANOS);
    }

    public void preRecoveryCheckpointInit(RecoveryInfo recoveryInfo) {
        for (Txn txn : recoveryInfo.replayTxns.values()) {
            ((ReplayTxn)txn).registerWithActiveTxns(this.activeTxns);
        }
        this.lastReplayedVLSN = this.repImpl.getVLSNIndex().getRange().getLast();
    }

    public TxnInfo getLastReplayedTxn() {
        return this.lastReplayedTxn;
    }

    public VLSN getLastReplayedVLSN() {
        return this.lastReplayedVLSN;
    }

    public void abortOldTxns() throws DatabaseException {
        int masterNodeId = this.repImpl.getNodeId();
        for (ReplayTxn replayTxn : this.activeTxns.values()) {
            replayTxn.abort(ReplicationContext.MASTER, masterNodeId);
        }
        assert (this.activeTxns.size() == 0) : "Unexpected txns in activeTxns = " + this.activeTxns;
    }

    private void updateCommitStats(boolean needsAck, Durability.SyncPolicy syncPolicy, long messageProcessingStartTime) {
        this.nCommits.increment();
        if (needsAck) {
            this.nCommitAcks.increment();
        }
        if (syncPolicy == Durability.SyncPolicy.SYNC) {
            this.nCommitSyncs.increment();
        } else if (syncPolicy == Durability.SyncPolicy.NO_SYNC) {
            this.nCommitNoSyncs.increment();
        } else if (syncPolicy == Durability.SyncPolicy.WRITE_NO_SYNC) {
            this.nCommitWriteNoSyncs.increment();
        } else {
            throw EnvironmentFailureException.unexpectedState("Unknown sync policy: " + (Object)((Object)syncPolicy));
        }
        this.totalCommitProcessingNanos.add(messageProcessingStartTime);
        this.minCommitProcessingNanos.setMin(messageProcessingStartTime);
        this.maxCommitProcessingNanos.setMax(messageProcessingStartTime);
    }

    public void replayEntry(NamedChannel namedChannel, Protocol protocol, Protocol.Entry entry) throws DatabaseException, IOException, InterruptedException, MasterStatus.MasterSyncException {
        long messageProcessingStartTime = System.nanoTime();
        InputWireRecord wireRecord = entry.getWireRecord();
        LogEntry logEntry = wireRecord.getLogEntry();
        if (!wireRecord.getVLSN().follows(this.lastReplayedVLSN)) {
            throw new EnvironmentFailureException((EnvironmentImpl)this.repImpl, EnvironmentFailureReason.UNEXPECTED_STATE, "Rep stream not sequential. Current VLSN: " + this.lastReplayedVLSN + " next log entry VLSN: " + wireRecord.getVLSN());
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            LoggerUtils.finest(this.logger, this.repImpl, "Replaying " + wireRecord);
        }
        ReplayTxn repTxn = this.getReplayTxn(logEntry.getTransactionId());
        this.updateReplicaSequences(logEntry);
        byte entryType = wireRecord.getEntryType();
        this.lastReplayedVLSN = wireRecord.getVLSN();
        RepNode repNode = this.repImpl.getRepNode();
        try {
            if (LogEntryType.LOG_TXN_COMMIT.equalsType(entryType)) {
                Durability.SyncPolicy syncPolicy;
                Protocol.Commit commitEntry = (Protocol.Commit)entry;
                boolean needsAck = commitEntry.getNeedsAck();
                Durability.SyncPolicy syncPolicy2 = syncPolicy = needsAck ? commitEntry.getReplicaSyncPolicy() : this.noAckSyncPolicy;
                if (this.logger.isLoggable(Level.FINE)) {
                    if (needsAck) {
                        LoggerUtils.fine(this.logger, this.repImpl, "Replay: got commit for txn=" + repTxn.getId() + ", ack needed, replica sync policy=" + (Object)((Object)syncPolicy) + " vlsn=" + this.lastReplayedVLSN);
                    } else {
                        LoggerUtils.fine(this.logger, this.repImpl, "Replay: got commit for txn=" + repTxn.getId() + " ack not needed" + " vlsn=" + this.lastReplayedVLSN);
                    }
                }
                TxnCommit masterCommit = (TxnCommit)logEntry.getMainItem();
                if (needsAck) {
                    repNode.getVLSNFreezeLatch().awaitThaw();
                    repNode.getMasterStatus().assertSync();
                }
                repTxn.commit(syncPolicy, new ReplicationContext(this.lastReplayedVLSN), masterCommit.getMasterNodeId());
                Timestamp commitTime = masterCommit.getTime();
                this.lastReplayedTxn = new TxnInfo(this.lastReplayedVLSN, commitTime.getTime());
                long commitNanos = System.nanoTime() - messageProcessingStartTime;
                this.updateCommitStats(needsAck, syncPolicy, commitNanos);
                if (commitNanos > this.ackTimeoutLogThresholdInNanos && this.logger.isLoggable(Level.INFO)) {
                    LoggerUtils.info(this.logger, this.repImpl, "Replay commit time: " + commitNanos / 1000000L + " ms exceeded log threshold: " + this.ackTimeoutLogThresholdInNanos / 1000000L);
                }
                if (needsAck) {
                    Protocol protocol2 = protocol;
                    protocol2.getClass();
                    protocol.write((BinaryProtocol.Message)new Protocol.Ack(protocol2, repTxn.getId()), namedChannel);
                }
                if (repTxn.getRepGroupDbChange() && this.canRefreshGroup(repTxn)) {
                    repNode.refreshCachedGroup();
                    repNode.recalculateGlobalCBVLSN();
                }
                this.nElapsedTxnTime.add(repTxn.elapsedTime());
            } else if (LogEntryType.LOG_TXN_ABORT.equalsType(entryType)) {
                this.nAborts.increment();
                TxnAbort masterAbort = (TxnAbort)logEntry.getMainItem();
                ReplicationContext abortContext = new ReplicationContext(wireRecord.getVLSN());
                if (this.logger.isLoggable(Level.FINEST)) {
                    LoggerUtils.finest(this.logger, this.repImpl, "abort called for " + repTxn.getId() + " masterId=" + masterAbort.getMasterNodeId() + " repContext=" + abortContext);
                }
                repTxn.abort(abortContext, masterAbort.getMasterNodeId());
                if (repTxn.getRepGroupDbChange() && this.canRefreshGroup(repTxn)) {
                    repNode.refreshCachedGroup();
                }
                this.nElapsedTxnTime.add(repTxn.elapsedTime());
            } else if (LogEntryType.LOG_NAMELN_TRANSACTIONAL.equalsType(entryType)) {
                repNode.getReplica().clearDbTreeCache();
                this.nNameLNs.increment();
                this.applyNameLN(repTxn, wireRecord);
            } else {
                this.nLNs.increment();
                assert (wireRecord.getLogEntry() instanceof LNLogEntry);
                this.applyLN(repTxn, wireRecord);
            }
            repTxn.setLastAppliedVLSN(this.lastReplayedVLSN);
        }
        catch (DatabaseException e) {
            e.addErrorMessage("Problem seen replaying entry " + wireRecord);
            throw e;
        }
    }

    private boolean canRefreshGroup(ReplayTxn txn) {
        for (ReplayTxn atxn : this.activeTxns.values()) {
            if (atxn == txn || !atxn.getRepGroupDbChange()) continue;
            return false;
        }
        return true;
    }

    private void updateReplicaSequences(LogEntry logEntry) {
        this.repImpl.getTxnManager().updateFromReplay(logEntry.getTransactionId());
        if (logEntry instanceof LNLogEntry) {
            long repStreamLNId = ((LNLogEntry)logEntry).getLN().getNodeId();
            this.repImpl.getNodeSequence().updateFromReplay(repStreamLNId);
            if (logEntry instanceof NameLNLogEntry) {
                NameLN nameLN = (NameLN)((NameLNLogEntry)logEntry).getLN();
                this.repImpl.getDbTree().updateFromReplay(nameLN.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReplayTxn getReplayTxn(long txnId) throws DatabaseException {
        ReplayTxn useTxn = null;
        ConcurrentMap<Long, ReplayTxn> concurrentMap = this.activeTxns;
        synchronized (concurrentMap) {
            useTxn = (ReplayTxn)this.activeTxns.get(txnId);
            if (useTxn == null) {
                useTxn = new ReplayTxn(this.repImpl, TransactionConfig.DEFAULT, txnId, this.activeTxns, this.logger);
            }
        }
        return useTxn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyNameLN(ReplayTxn repTxn, InputWireRecord wireRecord) throws DatabaseException {
        String databaseName;
        NameLNLogEntry nameLNEntry = (NameLNLogEntry)wireRecord.getLogEntry();
        NameLN nameLN = (NameLN)nameLNEntry.getLN();
        try {
            databaseName = new String(nameLNEntry.getKey(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
        DbOpReplicationContext repContext = new DbOpReplicationContext(wireRecord.getVLSN(), nameLNEntry);
        DbOperationType opType = repContext.getDbOperationType();
        DatabaseImpl dbImpl = null;
        try {
            switch (opType) {
                case CREATE: {
                    DatabaseConfig dbConfig = repContext.getCreateConfig().getReplicaConfig();
                    dbImpl = this.repImpl.getDbTree().createReplicaDb(repTxn, databaseName, dbConfig, nameLN, repContext);
                    if (dbImpl.getId().getId() == -257 && !"_jeRepGroupDB".equals(databaseName)) {
                        throw EnvironmentFailureException.unexpectedState("Database: _jeRepGroupDB is associated with id: " + dbImpl.getId().getId() + " and not the reserved database id: " + -257);
                    }
                    break;
                }
                case REMOVE: {
                    dbImpl = this.repImpl.getDbTree().getDb(nameLN.getId());
                    try {
                        this.repImpl.getDbTree().removeReplicaDb(repTxn, databaseName, nameLN.getId(), repContext);
                        break;
                    }
                    catch (DatabaseNotFoundException e) {
                        throw EnvironmentFailureException.unexpectedState("Database: " + dbImpl.getName() + " Id: " + nameLN.getId() + " not found on the Replica.");
                    }
                }
                case TRUNCATE: {
                    dbImpl = this.repImpl.getDbTree().getDb(repContext.getTruncateOldDbId());
                    try {
                        this.repImpl.getDbTree().truncateReplicaDb(repTxn, databaseName, false, nameLN, repContext);
                        break;
                    }
                    catch (DatabaseNotFoundException e) {
                        throw EnvironmentFailureException.unexpectedState("Database: " + dbImpl.getName() + " Id: " + nameLN.getId() + " not found on the Replica.");
                    }
                }
                case RENAME: {
                    dbImpl = this.repImpl.getDbTree().getDb(nameLN.getId());
                    try {
                        this.repImpl.getDbTree().renameReplicaDb(repTxn, dbImpl.getName(), databaseName, nameLN, repContext);
                        break;
                    }
                    catch (DatabaseNotFoundException e) {
                        throw EnvironmentFailureException.unexpectedState("Database rename from: " + dbImpl.getName() + " to " + databaseName + " failed, name not found on the Replica.");
                    }
                }
                default: {
                    throw EnvironmentFailureException.unexpectedState("Illegal database op type of " + opType.toString() + " from " + wireRecord + " database=" + databaseName);
                }
            }
            Object var11_14 = null;
            if (dbImpl != null) {
                this.repImpl.getDbTree().releaseDb(dbImpl);
            }
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            if (dbImpl != null) {
                this.repImpl.getDbTree().releaseDb(dbImpl);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyLN(ReplayTxn repTxn, InputWireRecord wireRecord) throws DatabaseException {
        LNLogEntry lnEntry = (LNLogEntry)wireRecord.getLogEntry();
        DatabaseId dbId = lnEntry.getDbId();
        if (dbId.getId() == -257) {
            repTxn.noteRepGroupDbChange();
        }
        DatabaseImpl dbImpl = this.repImpl.getDbTree().getDb(dbId, -1L, this.repImpl.getRepNode().getReplica().getDbCache());
        ReplicationContext repContext = new ReplicationContext(wireRecord.getVLSN());
        Cursor cursor = DbInternal.makeCursor(dbImpl, repTxn, null);
        try {
            OperationStatus status;
            LN ln = lnEntry.getLN();
            if (ln.isDeleted()) {
                CursorImpl.SearchMode searchMode;
                DatabaseEntry key = new DatabaseEntry(lnEntry.getKey());
                byte[] dupKey = lnEntry.getDupKey();
                DatabaseEntry data = new DatabaseEntry();
                if (dupKey == null) {
                    searchMode = CursorImpl.SearchMode.SET;
                } else {
                    searchMode = CursorImpl.SearchMode.BOTH;
                    data.setData(dupKey);
                }
                status = DbInternal.search(cursor, key, data, LockMode.RMW, searchMode);
                if (status == OperationStatus.SUCCESS) {
                    status = DbInternal.deleteInternal(cursor, repContext);
                }
            } else {
                status = DbInternal.putLN(cursor, lnEntry.getKey(), ln, PutMode.OVERWRITE_KNOWN, repContext);
            }
            if (status != OperationStatus.SUCCESS) {
                throw new EnvironmentFailureException((EnvironmentImpl)this.repImpl, EnvironmentFailureReason.LOG_INCOMPLETE, "Replicated operation could  not be applied. Status= " + (Object)((Object)status) + ' ' + wireRecord);
            }
            Object var15_14 = null;
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            cursor.close();
            throw throwable;
        }
        cursor.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rollback(VLSN matchpointVLSN, long matchpointLsn) {
        String rollbackStatus;
        block9: {
            block8: {
                block7: {
                    rollbackStatus = RBSTATUS_START;
                    try {
                        if (this.activeTxns.size() == 0) {
                            rollbackStatus = RBSTATUS_NO_ACTIVE;
                            Object var15_4 = null;
                            this.lastReplayedVLSN = matchpointVLSN;
                            break block7;
                        }
                        VLSNRange range = this.repImpl.getVLSNIndex().getRange();
                        if (range.getLast().equals(matchpointVLSN)) {
                            rollbackStatus = RBSTATUS_RANGE_EQUALS;
                            break block8;
                        }
                        this.repImpl.getRepNode().shutdownNetworkBackup();
                        this.repImpl.setBackupProhibited(true);
                        this.repImpl.invalidateBackups(DbLsn.getFileNumber(matchpointLsn));
                        LogManager logManager = this.repImpl.getLogManager();
                        SingleItemEntry rollbackStart = new SingleItemEntry(LogEntryType.LOG_ROLLBACK_START, new RollbackStart(matchpointVLSN, matchpointLsn, this.activeTxns.keySet()));
                        long rollbackStartLsn = logManager.logForceFlush(rollbackStart, true, ReplicationContext.NO_REPLICATE);
                        rollbackStatus = RBSTATUS_LOG_RBSTART;
                        ArrayList<Long> rollbackLsns = new ArrayList<Long>();
                        for (ReplayTxn replayTxn : this.activeTxns.values()) {
                            Collection<Long> txnRollbackLsns = replayTxn.rollback(matchpointLsn);
                            assert (this.checkRemoved(replayTxn)) : "Should have removed " + replayTxn;
                            rollbackLsns.addAll(txnRollbackLsns);
                        }
                        rollbackStatus = RBSTATUS_MEM_ROLLBACK;
                        assert (rollbackLsns.size() != 0);
                        RollbackTracker.makeInvisible(this.repImpl, rollbackLsns);
                        rollbackStatus = RBSTATUS_INVISIBLE;
                        logManager.logForceFlush(new SingleItemEntry(LogEntryType.LOG_ROLLBACK_END, new RollbackEnd(matchpointLsn, rollbackStartLsn)), true, ReplicationContext.NO_REPLICATE);
                        this.repImpl.getRepNode().restartNetworkBackup();
                        this.repImpl.setBackupProhibited(false);
                        rollbackStatus = RBSTATUS_FINISH;
                        break block9;
                    }
                    catch (Throwable throwable) {
                        Object var15_7 = null;
                        this.lastReplayedVLSN = matchpointVLSN;
                        LoggerUtils.info(this.logger, this.repImpl, "Rollback to matchpoint " + matchpointVLSN + " at " + DbLsn.getNoFormatString(matchpointLsn) + " status=" + rollbackStatus);
                        throw throwable;
                    }
                }
                LoggerUtils.info(this.logger, this.repImpl, "Rollback to matchpoint " + matchpointVLSN + " at " + DbLsn.getNoFormatString(matchpointLsn) + " status=" + rollbackStatus);
                return;
            }
            Object var15_5 = null;
            this.lastReplayedVLSN = matchpointVLSN;
            LoggerUtils.info(this.logger, this.repImpl, "Rollback to matchpoint " + matchpointVLSN + " at " + DbLsn.getNoFormatString(matchpointLsn) + " status=" + rollbackStatus);
            return;
        }
        Object var15_6 = null;
        this.lastReplayedVLSN = matchpointVLSN;
        LoggerUtils.info(this.logger, this.repImpl, "Rollback to matchpoint " + matchpointVLSN + " at " + DbLsn.getNoFormatString(matchpointLsn) + " status=" + rollbackStatus);
    }

    private boolean checkRemoved(ReplayTxn txn) {
        return !txn.isClosed() || !this.activeTxns.containsKey(txn.getId());
    }

    public void close() {
        for (ReplayTxn replayTxn : this.activeTxns.values()) {
            try {
                if (this.logger.isLoggable(Level.FINE)) {
                    LoggerUtils.fine(this.logger, this.repImpl, "Unregistering open replay txn: " + replayTxn.getId());
                }
                replayTxn.cleanup();
            }
            catch (DatabaseException e) {
                LoggerUtils.fine(this.logger, this.repImpl, "Replay txn: " + replayTxn.getId() + " unregistration failed: " + e.getMessage());
            }
        }
        assert (this.activeTxns.size() == 0);
    }

    public StatGroup getStats(StatsConfig config) {
        StatGroup ret = this.statistics.cloneGroup(config.getClear());
        return ret;
    }

    public void resetStats() {
        this.statistics.clear();
    }

    public Map<Long, ReplayTxn> getActiveTxns() {
        return this.activeTxns;
    }

    public String dumpState() {
        StringBuilder sb = new StringBuilder();
        sb.append("lastReplayedTxn=").append(this.lastReplayedTxn);
        sb.append(" lastReplayedVLSN=").append(this.lastReplayedVLSN);
        sb.append(" numActiveReplayTxns=").append(this.activeTxns.size());
        sb.append("\n");
        return sb.toString();
    }

    public static class TxnInfo {
        final VLSN txnVLSN;
        final long masterCommitTime;

        private TxnInfo(VLSN txnVLSN, long masterCommitTime) {
            this.txnVLSN = txnVLSN;
            this.masterCommitTime = masterCommitTime;
        }

        public VLSN getTxnVLSN() {
            return this.txnVLSN;
        }

        public long getMasterCommitTime() {
            return this.masterCommitTime;
        }

        public String toString() {
            return " VLSN: " + this.txnVLSN + " masterCommitTime=" + new Date(this.masterCommitTime);
        }
    }
}

