/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureCollectionIterator;

public class PointCollectionIteratorFiltered
implements PointFeatureCollectionIterator {
    private PointFeatureCollectionIterator pfciter;
    private PointFeatureCollectionIterator.Filter filter;
    private PointFeatureCollection pointFeatureCollection;
    private boolean done = false;

    public PointCollectionIteratorFiltered(PointFeatureCollectionIterator pfciter, PointFeatureCollectionIterator.Filter filter) {
        this.pfciter = pfciter;
        this.filter = filter;
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.done) {
            return false;
        }
        this.pointFeatureCollection = this.nextFilteredPointFeatureCollection();
        return this.pointFeatureCollection != null;
    }

    @Override
    public PointFeatureCollection next() throws IOException {
        return this.done ? null : this.pointFeatureCollection;
    }

    @Override
    public void close() {
        this.pfciter.close();
    }

    private boolean filter(PointFeatureCollection pdata) {
        return this.filter == null || this.filter.filter(pdata);
    }

    private PointFeatureCollection nextFilteredPointFeatureCollection() throws IOException {
        if (!this.pfciter.hasNext()) {
            this.pfciter.close();
            return null;
        }
        PointFeatureCollection pdata = this.pfciter.next();
        while (!this.filter(pdata)) {
            if (!this.pfciter.hasNext()) {
                this.pfciter.close();
                return null;
            }
            pdata = this.pfciter.next();
        }
        return pdata;
    }
}

