/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.remote;

import java.io.IOException;
import java.io.InputStream;
import ucar.nc2.ft.DsgFeatureCollection;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.point.CollectionInfo;
import ucar.nc2.ft.point.DsgCollectionImpl;
import ucar.nc2.ft.point.PointIteratorAbstract;
import ucar.nc2.ft.point.remote.FeatureMaker;
import ucar.nc2.ft.point.remote.PointStream;
import ucar.nc2.stream.NcStream;
import ucar.nc2.stream.NcStreamProto;

public class PointIteratorStream
extends PointIteratorAbstract {
    private DsgFeatureCollection dsg;
    private InputStream in;
    private FeatureMaker featureMaker;
    private PointFeature pf;
    private boolean finished = false;

    PointIteratorStream(DsgCollectionImpl dsg, InputStream in, FeatureMaker featureMaker) throws IOException {
        this.dsg = dsg;
        this.in = in;
        this.featureMaker = featureMaker;
        CollectionInfo info = dsg.getInfo();
        if (!info.isComplete()) {
            this.setCalculateBounds(info);
        }
    }

    @Override
    public void close() {
        if (this.finished) {
            return;
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.in = null;
        this.finishCalcBounds();
        this.finished = true;
    }

    @Override
    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        try {
            PointStream.MessageType mtype = PointStream.readMagic(this.in);
            if (mtype == PointStream.MessageType.PointFeature) {
                int len = NcStream.readVInt(this.in);
                byte[] b = new byte[len];
                NcStream.readFully(this.in, b);
                this.pf = this.featureMaker.make(this.dsg, b);
                return true;
            }
            if (mtype == PointStream.MessageType.End) {
                this.pf = null;
                this.close();
                return false;
            }
            if (mtype == PointStream.MessageType.Error) {
                int len = NcStream.readVInt(this.in);
                byte[] b = new byte[len];
                NcStream.readFully(this.in, b);
                NcStreamProto.Error proto = NcStreamProto.Error.parseFrom(b);
                String errMessage = NcStream.decodeErrorMessage(proto);
                this.pf = null;
                this.close();
                throw new IOException(errMessage);
            }
            this.pf = null;
            this.close();
            throw new IOException("Illegal pointstream message type= " + (Object)((Object)mtype));
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public PointFeature next() {
        if (null == this.pf) {
            return null;
        }
        this.calcBounds(this.pf);
        return this.pf;
    }
}

