/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.dorade;

import java.io.IOException;
import java.util.Date;
import ucar.atd.dorade.DoradePARM;
import ucar.atd.dorade.DoradeSweep;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.dorade.Doradeheader;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class Doradeiosp
extends AbstractIOServiceProvider {
    protected Doradeheader headerParser;
    public DoradeSweep mySweep = null;

    @Override
    public boolean isValidFile(RandomAccessFile raf) {
        return Doradeheader.isValidFile(raf);
    }

    @Override
    public String getFileTypeId() {
        return "DORADE";
    }

    @Override
    public String getFileTypeDescription() {
        return "DOppler RAdar Data Exchange Format";
    }

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        super.open(raf, ncfile, cancelTask);
        this.mySweep = new DoradeSweep(raf.getRandomAccessFile());
        this.headerParser = new Doradeheader();
        this.headerParser.read(this.mySweep, ncfile, null);
        ncfile.finish();
    }

    @Override
    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        Array outputData;
        int nSensor = this.mySweep.getNSensors();
        int nRays = this.mySweep.getNRays();
        if (v2.getShortName().equals("elevation")) {
            float[] elev = this.mySweep.getElevations();
            outputData = this.readData1(v2, section, elev);
        } else if (v2.getShortName().equals("rays_time")) {
            Date[] dd = this.mySweep.getTimes();
            if (dd == null) {
                throw new IllegalStateException("missing dates for " + v2.getShortName());
            }
            double[] d = new double[dd.length];
            for (int i = 0; i < dd.length; ++i) {
                d[i] = dd[i].getTime();
            }
            outputData = this.readData2(v2, section, d);
        } else if (v2.getShortName().equals("azimuth")) {
            float[] azim = this.mySweep.getAzimuths();
            outputData = this.readData1(v2, section, azim);
        } else if (v2.getShortName().startsWith("latitudes_")) {
            float[] allLats = new float[nSensor * nRays];
            for (int i = 0; i < nSensor; ++i) {
                float[] lats = this.mySweep.getLatitudes(i);
                System.arraycopy(lats, 0, allLats, i * nRays, nRays);
            }
            outputData = this.readData1(v2, section, allLats);
        } else if (v2.getShortName().startsWith("longitudes_")) {
            float[] allLons = new float[nSensor * nRays];
            for (int i = 0; i < nSensor; ++i) {
                float[] lons = this.mySweep.getLongitudes(i);
                System.arraycopy(lons, 0, allLons, i * nRays, nRays);
            }
            outputData = this.readData1(v2, section, allLons);
        } else if (v2.getShortName().startsWith("altitudes_")) {
            float[] allAlts = new float[nSensor * nRays];
            for (int i = 0; i < nSensor; ++i) {
                float[] alts = this.mySweep.getAltitudes(i);
                System.arraycopy(alts, 0, allAlts, i * nRays, nRays);
            }
            outputData = this.readData1(v2, section, allAlts);
        } else if (v2.getShortName().startsWith("distance_")) {
            int j = 0;
            for (int i = 0; i < nSensor; ++i) {
                String t = "" + i;
                if (!v2.getShortName().endsWith(t)) continue;
                j = i;
                break;
            }
            int nc = this.mySweep.getNCells(j);
            Array data = Array.makeArray(DataType.FLOAT, nc, this.mySweep.getRangeToFirstCell(j), this.mySweep.getCellSpacing(j));
            float[] dist = (float[])data.get1DJavaArray(DataType.FLOAT);
            outputData = this.readData1(v2, section, dist);
        } else if (v2.isScalar()) {
            float d = 0.0f;
            if (v2.getShortName().equals("Range_to_First_Cell")) {
                d = this.mySweep.getRangeToFirstCell(0);
            } else if (v2.getShortName().equals("Cell_Spacing")) {
                d = this.mySweep.getCellSpacing(0);
            } else if (v2.getShortName().equals("Fixed_Angle")) {
                d = this.mySweep.getFixedAngle();
            } else if (v2.getShortName().equals("Nyquist_Velocity")) {
                d = this.mySweep.getUnambiguousVelocity(0);
            } else if (v2.getShortName().equals("Unambiguous_Range")) {
                d = this.mySweep.getunambiguousRange(0);
            } else if (v2.getShortName().equals("Radar_Constant")) {
                d = this.mySweep.getradarConstant(0);
            } else if (v2.getShortName().equals("rcvr_gain")) {
                d = this.mySweep.getrcvrGain(0);
            } else if (v2.getShortName().equals("ant_gain")) {
                d = this.mySweep.getantennaGain(0);
            } else if (v2.getShortName().equals("sys_gain")) {
                d = this.mySweep.getsystemGain(0);
            } else if (v2.getShortName().equals("bm_width")) {
                d = this.mySweep.gethBeamWidth(0);
            }
            float[] dd = new float[]{d};
            outputData = Array.factory(v2.getDataType(), v2.getShape(), (Object)dd);
        } else {
            Range radialRange = section.getRange(0);
            Range gateRange = section.getRange(1);
            Array data = Array.factory(v2.getDataType(), section.getShape());
            IndexIterator ii = data.getIndexIterator();
            DoradePARM dp = this.mySweep.lookupParamIgnoreCase(v2.getShortName());
            if (dp == null) {
                throw new IllegalStateException("Cant find param " + v2.getShortName());
            }
            int ncells = dp.getNCells();
            float[] rayValues = new float[ncells];
            for (int radialIdx : radialRange) {
                try {
                    rayValues = this.mySweep.getRayData(dp, radialIdx, rayValues);
                }
                catch (DoradeSweep.DoradeSweepException ex) {
                    ex.printStackTrace();
                }
                for (int gateIdx : gateRange) {
                    ii.setFloatNext(rayValues[gateIdx]);
                }
            }
            return data;
        }
        return outputData;
    }

    public Array readData1(Variable v2, Section section, float[] values) {
        Array data = Array.factory(v2.getDataType(), section.getShape());
        IndexIterator ii = data.getIndexIterator();
        Range radialRange = section.getRange(0);
        for (int radialIdx : radialRange) {
            ii.setFloatNext(values[radialIdx]);
        }
        return data;
    }

    public Array readData2(Variable v2, Section section, double[] values) {
        Array data = Array.factory(v2.getDataType(), section.getShape());
        IndexIterator ii = data.getIndexIterator();
        Range radialRange = section.getRange(0);
        for (int radialIdx : radialRange) {
            ii.setDoubleNext(values[radialIdx]);
        }
        return data;
    }
}

