/*
 * Decompiled with CFR 0.152.
 */
package visad.data.units;

import java.io.ByteArrayInputStream;
import visad.Unit;
import visad.UnitException;
import visad.data.units.NoSuchUnitException;
import visad.data.units.ParseException;
import visad.data.units.TokenMgrError;
import visad.data.units.UnitParser;

public class Parser {
    protected static final UnitParser unitParser = new UnitParser(System.in);
    protected static final Parser parser = new Parser();

    protected Parser() {
    }

    public static Parser instance() {
        return parser;
    }

    public static synchronized Unit parse(String spec) throws ParseException, NoSuchUnitException {
        unitParser.ReInit(new ByteArrayInputStream(spec.trim().getBytes()));
        try {
            return unitParser.unitSpec();
        }
        catch (TokenMgrError e) {
            throw new ParseException(e.getMessage());
        }
        catch (UnitException e) {
            throw new ParseException(e.getMessage());
        }
    }

    public static void main(String[] args) throws ParseException, UnitException {
        Unit m3 = Parser.parse("m");
        Unit s2 = Parser.parse("s");
        class Test {
            String spec;
            Unit unit;

            Test(String spec, Unit unit) {
                this.spec = spec;
                this.unit = unit;
            }
        }
        Test[] tests = new Test[]{new Test("m", m3), new Test("2 m s", m3.multiply(s2).scale(2.0)), new Test("3.14 m.s", m3.multiply(s2).scale(3.14)), new Test("1e9 (m)", m3.scale(1.0E9)), new Test("(m s)2", m3.multiply(s2).pow(2)), new Test("m2.s-1", m3.pow(2).divide(s2)), new Test("m2 s^-1", m3.pow(2).divide(s2)), new Test("(m/s)2", m3.divide(s2).pow(2)), new Test("m2/s-1", m3.pow(2).divide(s2.pow(-1))), new Test("m2/s^-1", m3.pow(2).divide(s2.pow(-1))), new Test(".5 m/(.25 s)2", m3.scale(0.5).divide(s2.scale(0.25).pow(2))), new Test("m.m-1.m", m3.multiply(m3.pow(-1)).multiply(m3)), new Test("2.0 m 1/2 s-1*(m/s^1)^-1 (1e9 m-1)(1e9 s-1)-1.m/s", m3.scale(2.0).scale(0.5).multiply(s2.pow(-1)).multiply(m3.divide(s2.pow(1)).pow(-1)).multiply(m3.pow(-1).scale(1.0E9)).multiply(s2.pow(-1).scale(1.0E9).pow(-1)).multiply(m3).divide(s2)), new Test("m/km", m3.divide(m3.scale(1000.0)))};
        for (int i = 0; i < tests.length; ++i) {
            Test test = tests[i];
            String spec = test.spec;
            Unit unit = test.unit;
            if (!Parser.parse(spec).equals(unit)) {
                throw new AssertionError((Object)(spec + " != " + unit));
            }
        }
        try {
            Parser.parse("unknown unit");
            throw new AssertionError();
        }
        catch (ParseException e) {
            System.out.println("Done");
            return;
        }
    }
}

