/*
 * Decompiled with CFR 0.152.
 */
package visad.jmet;

import java.awt.geom.Rectangle2D;
import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.RealTupleType;
import visad.RealType;
import visad.Unit;
import visad.VisADException;
import visad.data.hdfeos.LambertConformalConic;
import visad.data.hdfeos.PolarStereographic;
import visad.georef.MapProjection;
import visad.util.DataUtility;

public class GRIBCoordinateSystem
extends MapProjection {
    private static Unit[] coordinate_system_units = new Unit[]{null, null};
    private CoordinateSystem c;
    private double spacing;
    private boolean isLambert = false;
    private boolean isLatLon = false;
    private boolean isPolarStereo = false;
    private double La1;
    private double Lo1;
    private double LoMax;
    private double Di;
    private double Dj;
    private double aspectRatio = 1.0;
    private double[] range = new double[4];

    public GRIBCoordinateSystem(int gridTypeCode, double La1, double Lo1, double DxDy, double lov) throws VisADException {
        this(RealTupleType.LatitudeLongitudeTuple, gridTypeCode, La1, Lo1, DxDy, lov);
    }

    public GRIBCoordinateSystem(RealTupleType ref, int gridTypeCode, double La1, double Lo1, double DxDy, double lov) throws VisADException {
        super(ref, coordinate_system_units);
        if (gridTypeCode != 5) {
            System.out.println("GRIB Grid type not Polar Stereographic = " + gridTypeCode);
            throw new VisADException("Invalid grid type for PolarStereographic = " + gridTypeCode);
        }
        this.doPolarStereo(ref, 2, 2, La1, Lo1, DxDy, lov);
    }

    public GRIBCoordinateSystem(RealTupleType ref, int gridTypeCode, double La1, double Lo1, double DxDy, double Latin1, double Latin2, double Lov) throws VisADException {
        this(ref, gridTypeCode, 2, 2, La1, Lo1, DxDy, Latin1, Latin2, Lov);
    }

    public GRIBCoordinateSystem(int gridTypeCode, double La1, double Lo1, double DxDy, double Latin1, double Latin2, double Lov) throws VisADException {
        this(RealTupleType.LatitudeLongitudeTuple, gridTypeCode, 2, 2, La1, Lo1, DxDy, Latin1, Latin2, Lov);
    }

    public GRIBCoordinateSystem(int gridTypeCode, int Ni, int Nj, double La1, double Lo1, double La2, double Lo2, double Di, double Dj) throws VisADException {
        this(RealTupleType.LatitudeLongitudeTuple, gridTypeCode, Ni, Nj, La1, Lo1, La2, Lo2, Di, Dj);
    }

    public GRIBCoordinateSystem(RealTupleType ref, int gridTypeCode, int Ni, int Nj, double La1, double Lo1, double La2, double Lo2, double Di, double Dj) throws VisADException {
        super(ref, coordinate_system_units);
        if (gridTypeCode == 0) {
            this.doLatLon(ref, Ni, Nj, La1, Lo1, La2, Lo2, Di, Dj);
        } else if (gridTypeCode == 3) {
            this.doLambert(ref, Ni, Nj, La1, Lo1, La2, Lo2, Di, Dj);
        } else {
            System.out.println("GRIB Grid type not Lat/Lon = " + gridTypeCode);
            throw new VisADException("Invalid grid type for Lat/Lon = " + gridTypeCode);
        }
    }

    public GRIBCoordinateSystem(int Ni, int Nj, double La1, double Lo1, double Di, double Dj) throws VisADException {
        this(RealTupleType.LatitudeLongitudeTuple, 0, Ni, Nj, La1, Lo1, 0.0, 0.0, Di, Dj);
    }

    public GRIBCoordinateSystem(int gridNumber) throws VisADException {
        this(RealTupleType.LatitudeLongitudeTuple, gridNumber);
    }

    public GRIBCoordinateSystem(RealTupleType ref, int gridNumber) throws VisADException {
        super(ref, coordinate_system_units);
        if (gridNumber == 201) {
            this.doPolarStereo(ref, 65, 65, -20.826, -150.0, 381.0, -105.0);
        } else if (gridNumber == 202) {
            this.doPolarStereo(ref, 65, 43, 7.838, -141.028, 190.5, -105.0);
        } else if (gridNumber == 203) {
            this.doPolarStereo(ref, 45, 39, 19.132, -185.837, 190.5, -150.0);
        } else if (gridNumber == 211) {
            this.doLambert(ref, 93, 65, 12.19, -133.459, 81.2705, 25.0, 25.0, -95.0);
        } else if (gridNumber == 221) {
            this.doLambert(ref, 349, 277, 1.0, -145.0, 32.46341, 50.0, 50.0, -107.0);
        } else if (gridNumber == 226) {
            this.doLambert(ref, 737, 517, 12.19, -133.459, 10.1588125, 25.0, 25.0, -95.0);
        } else if (gridNumber == 227) {
            this.doLambert(ref, 1473, 1025, 12.19, -133.459, 5.07940625, 25.0, 25.0, -95.0);
        } else if (gridNumber == 241) {
            this.doLambert(ref, 549, 445, -4.85, -151.1, 22.0, 45.0, 45.0, -111.0);
        } else if (gridNumber == 252) {
            this.doLambert(ref, 301, 225, 16.281, -126.138, 20.317625, 25.0, 25.0, -95.0);
        } else if (gridNumber == 2525) {
            this.doLambert(ref, 1200, 896, 16.3081290698, -126.1204451156423, 5.0794, 25.0, 25.0, -95.0);
        } else if (gridNumber == 212) {
            this.doLambert(ref, 185, 129, 12.19, -133.459, 40.63525, 25.0, 25.0, -95.0);
        } else if (gridNumber == 213) {
            this.doPolarStereo(ref, 129, 85, 7.838, -141.028, 95.25, -105.0);
        } else if (gridNumber == 215) {
            this.doLambert(ref, 369, 257, 12.19, -133.459, 20.317625, 25.0, 25.0, -95.0);
        } else if (gridNumber == 236) {
            this.doLambert(ref, 151, 113, 16.281, 233.862, 40.635, 25.0, 25.0, 265.0);
        } else {
            System.out.println("GRIB Grid type unknown = " + gridNumber);
            throw new VisADException("Unknown grid number = " + gridNumber);
        }
    }

    private void doLatLon(RealTupleType ref, int Ni, int Nj, double La1, double Lo1, double La2, double Lo2, double Di, double Dj) throws VisADException {
        this.isLambert = false;
        this.isLatLon = true;
        this.La1 = La1;
        this.Lo1 = Lo1;
        this.Di = Di;
        this.Dj = Dj;
        this.LoMax = Lo1 + Di * (double)(Ni - 1);
        this.aspectRatio = Di / Dj;
        this.range[0] = 0.0;
        this.range[1] = 0.0;
        this.range[2] = Ni;
        this.range[3] = Nj;
    }

    private void doPolarStereo(RealTupleType ref, int Nx, int Ny, double La1, double Lo1, double DxDy, double Lov) throws VisADException {
        this.isPolarStereo = true;
        this.spacing = DxDy * 1000.0;
        this.aspectRatio = 1.0;
        this.range[0] = 0.0;
        this.range[1] = 0.0;
        this.range[2] = Nx;
        this.range[3] = Ny;
        this.c = PolarStereographic.makePolarStereographic(ref, La1 * (Math.PI / 180), Lo1 * (Math.PI / 180), Lov * (Math.PI / 180));
    }

    private void doLambert(RealTupleType ref, int Nx, int Ny, double La1, double Lo1, double DxDy, double Latin1, double Latin2, double Lov) throws VisADException {
        this.isLambert = true;
        this.spacing = DxDy * 1000.0;
        double earth = 6371230.0;
        this.aspectRatio = 1.0;
        this.range[0] = 0.0;
        this.range[1] = 0.0;
        this.range[2] = Nx;
        this.range[3] = Ny;
        this.c = new LambertConformalConic(ref, earth, earth, Latin1 * (Math.PI / 180), Latin2 * (Math.PI / 180), Lov * (Math.PI / 180), Latin1 * (Math.PI / 180), 0.0, 0.0);
        double[][] lonlat = new double[2][1];
        double[][] xy = new double[2][1];
        lonlat[0][0] = Lo1 * (Math.PI / 180);
        lonlat[1][0] = La1 * (Math.PI / 180);
        xy = this.c.fromReference(lonlat);
        this.c = new LambertConformalConic(ref, earth, earth, Latin1 * (Math.PI / 180), Latin2 * (Math.PI / 180), Lov * (Math.PI / 180), Latin1 * (Math.PI / 180), -xy[0][0], -xy[1][0]);
    }

    public double[][] toReference(double[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != 2) {
            throw new CoordinateSystemException("GRIBCoordinateSystem.toReference: tuples wrong dimension");
        }
        if (this.isLambert || this.isPolarStereo) {
            for (int i = 0; i < tuples[0].length; ++i) {
                tuples[0][i] = tuples[0][i] * this.spacing;
                tuples[1][i] = tuples[1][i] * this.spacing;
            }
            double[][] latlon = this.c.toReference(tuples);
            for (int i = 0; i < latlon[0].length; ++i) {
                double t = latlon[0][i] * 57.29577951308232;
                latlon[0][i] = latlon[1][i] * 57.29577951308232;
                latlon[1][i] = t;
            }
            return latlon;
        }
        if (this.isLatLon) {
            double[][] latlon = new double[2][tuples[0].length];
            for (int i = 0; i < tuples[0].length; ++i) {
                latlon[0][i] = this.La1 + this.Dj * tuples[1][i];
                latlon[1][i] = this.Lo1 + this.Di * tuples[0][i];
            }
            return latlon;
        }
        return null;
    }

    public double[][] fromReference(double[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != 2) {
            throw new CoordinateSystemException("GRIBCoordinateSystem.toReference: tuples wrong dimension");
        }
        if (this.isLambert || this.isPolarStereo) {
            for (int i = 0; i < tuples[0].length; ++i) {
                double t = tuples[0][i] * (Math.PI / 180);
                tuples[0][i] = tuples[1][i] * (Math.PI / 180);
                tuples[1][i] = t;
            }
            double[][] xy = this.c.fromReference(tuples);
            for (int i = 0; i < xy[0].length; ++i) {
                xy[0][i] = xy[0][i] / this.spacing;
                xy[1][i] = xy[1][i] / this.spacing;
            }
            return xy;
        }
        if (this.isLatLon) {
            double[][] xy = new double[2][tuples[0].length];
            for (int i = 0; i < tuples[0].length; ++i) {
                double Lo = tuples[1][i];
                if (this.LoMax > 180.0 && Lo < 0.0 && Lo < this.Lo1) {
                    Lo = 360.0 + Lo;
                }
                xy[0][i] = (Lo - this.Lo1) / this.Di;
                xy[1][i] = (tuples[0][i] - this.La1) / this.Dj;
            }
            return xy;
        }
        return null;
    }

    public boolean equals(Object cs) {
        return cs instanceof GRIBCoordinateSystem;
    }

    public Rectangle2D getDefaultMapArea() {
        return new Rectangle2D.Double(this.range[0], this.range[1], this.range[2], this.range[3]);
    }

    public double getAspectRatio() {
        return this.aspectRatio;
    }

    public static boolean isGridNumberKnown(int gridNumber) {
        int[] knownGrids = new int[]{201, 202, 203, 211, 212, 215, 236};
        for (int i = 0; i < knownGrids.length; ++i) {
            if (knownGrids[i] != gridNumber) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        try {
            RealTupleType ref = new RealTupleType(RealType.Latitude, RealType.Longitude);
            GRIBCoordinateSystem nc = new GRIBCoordinateSystem(211);
            System.out.println("isSerializable? " + DataUtility.isSerializable(nc, true));
            double[][] latlon = new double[2][1];
            double[][] xy = new double[2][1];
            xy[0][0] = 92.0;
            xy[1][0] = 64.0;
            latlon = nc.toReference(xy);
            System.out.println(" (93,65) lat=" + latlon[0][0] + " lon=" + latlon[1][0]);
            latlon[0][0] = 12.19;
            latlon[1][0] = -133.459;
            xy = nc.fromReference(latlon);
            System.out.println(" at (1,1) x=" + xy[0][0] + " y=" + xy[1][0]);
            latlon[0][0] = 57.29;
            latlon[1][0] = -49.385;
            xy = nc.fromReference(latlon);
            System.out.println(" max row/col x=" + xy[0][0] + " y=" + xy[1][0]);
            latlon[0][0] = 35.0;
            latlon[1][0] = -95.0;
            xy = nc.fromReference(latlon);
            System.out.println(" at 35N/95W x=" + xy[0][0] + " y=" + xy[1][0]);
            nc = new GRIBCoordinateSystem(202);
            System.out.println("PolarStereo.......isSerializable? " + DataUtility.isSerializable(nc, true));
            latlon = new double[2][1];
            xy = new double[2][1];
            xy[0][0] = 64.0;
            xy[1][0] = 42.0;
            latlon = nc.toReference(xy);
            System.out.println(" (65,42) lat=" + latlon[0][0] + " lon=" + latlon[1][0]);
            latlon[0][0] = 7.838;
            latlon[1][0] = -1141.028;
            xy = nc.fromReference(latlon);
            System.out.println(" at (1,1) x=" + xy[0][0] + " y=" + xy[1][0]);
            latlon[0][0] = 35.617;
            latlon[1][0] = -18.576;
            xy = nc.fromReference(latlon);
            System.out.println(" max row/col x=" + xy[0][0] + " y=" + xy[1][0]);
            latlon[0][0] = 35.0;
            latlon[1][0] = -95.0;
            xy = nc.fromReference(latlon);
            System.out.println(" at 35N/95W x=" + xy[0][0] + " y=" + xy[1][0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

