/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcDimension;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcUnitUtils;
import gov.nasa.giss.data.nc.NcVarUtils;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.gridder.NcGridder;
import gov.nasa.giss.text.PrintfFormat;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;
import ucar.units.Unit;

public abstract class NcArray {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected NcDataset dataset_;
    protected NcVariable ncvar_;
    protected VariableDS njvarDS_;
    protected int rank_;
    protected int[] shape_;
    protected Array slice_;
    protected Index sliceIdx_;
    protected boolean hasBad_;
    protected boolean hasMissing_;
    protected boolean hasFill_;
    protected boolean hasScaleOffset_;
    protected boolean isInteger_;
    protected boolean hasCorrectedFill_;
    protected long correctedFillValue_;
    protected boolean hasInvalid_;
    protected boolean isUnsigned_;
    private DataType datatype_;
    private double validMax_ = Double.MAX_VALUE;
    private double validMin_ = -this.validMax_;
    protected NcDimension[] dimensions_;
    protected int[] sIndex_;
    protected boolean needsSlice_ = true;
    protected double minimum_ = Double.NaN;
    protected double maximum_ = Double.NaN;
    protected boolean needsExtrema_ = true;

    public NcArray(NcVariable ncvar) throws NcException {
        Objects.requireNonNull(ncvar, "Null variable argument.");
        this.dataset_ = ncvar.getDataset();
        this.ncvar_ = ncvar;
        this.njvarDS_ = (VariableDS)ncvar.getObject();
        this.initMe();
    }

    private final void initMe() throws NcException {
        LOGGER.trace("class {}", (Object)this.getClass());
        LOGGER.trace("njvarDS_ {}", (Object)this.njvarDS_.getFullName());
        this.rank_ = this.njvarDS_.getRank();
        this.shape_ = this.njvarDS_.getShape();
        this.sIndex_ = new int[this.rank_];
        for (int i = 0; i < this.rank_; ++i) {
            this.sIndex_[i] = 0;
        }
        this.hasBad_ = this.njvarDS_.hasMissing();
        this.hasMissing_ = this.njvarDS_.hasMissingValue();
        this.hasInvalid_ = false;
        this.hasFill_ = this.njvarDS_.hasFillValue();
        this.hasScaleOffset_ = this.njvarDS_.hasScaleOffset();
        this.isUnsigned_ = false;
        this.datatype_ = this.njvarDS_.getDataType();
        this.isInteger_ = this.datatype_.isIntegral();
        LOGGER.trace("bad {}, missing {}, fill {}", this.hasBad_, this.hasMissing_, this.hasFill_);
        LOGGER.trace("integer {}, scaleOffset {}", (Object)this.isInteger_, (Object)this.hasScaleOffset_);
        if (this.isUnsigned_) {
            Attribute aa;
            if (this.hasFill_ && (aa = this.njvarDS_.findAttribute("_FillValue")) != null) {
                Number nval = aa.getNumericValue();
                if (this.isInteger_) {
                    long lval = nval.longValue();
                    if (lval < 0L) {
                        this.hasCorrectedFill_ = true;
                        this.correctedFillValue_ = this.unsignCorrect(lval);
                        LOGGER.trace("corrected unsigned fill value {}", (Object)this.correctedFillValue_);
                    }
                } else {
                    LOGGER.trace("Unsigned attribute is not an integer value.");
                }
            }
            if (this.validMin_ < 0.0) {
                this.validMin_ = this.unsignCorrect(this.validMin_);
                LOGGER.trace("corrected unsigned valid min {}", (Object)this.validMin_);
            }
            if (this.validMax_ < 0.0) {
                this.validMax_ = this.unsignCorrect(this.validMax_);
                LOGGER.trace("corrected unsigned valid max {}", (Object)this.validMax_);
            }
        }
    }

    private long unsignCorrect(long lval) {
        if (lval >= 0L) {
            return lval;
        }
        long result = lval;
        if (this.datatype_ == DataType.BYTE) {
            result += 256L;
        } else if (this.datatype_ == DataType.SHORT) {
            result += 65536L;
        } else if (this.datatype_ == DataType.INT) {
            result += 0x100000000L;
        }
        return result;
    }

    private double unsignCorrect(double dval) {
        if (dval >= 0.0) {
            return dval;
        }
        double result = dval;
        if (this.datatype_ == DataType.BYTE) {
            result += 256.0;
        } else if (this.datatype_ == DataType.SHORT) {
            result += 65536.0;
        } else if (this.datatype_ == DataType.INT) {
            result += 4.294967296E9;
        }
        return result;
    }

    public NcVariable getNcVariable() {
        return this.ncvar_;
    }

    protected int findDimensionIndex(String varname) {
        LOGGER.trace("{}", (Object)varname);
        if (varname == null || varname.isEmpty()) {
            return -1;
        }
        return this.njvarDS_.findDimensionIndex(varname);
    }

    protected int findDimensionIndex(VariableDS dimvar) {
        Attribute aa;
        if (dimvar == null) {
            return -1;
        }
        int vi = this.findDimensionIndex(dimvar.getFullName());
        if (vi < 0 && (aa = dimvar.findAttribute("_CoordinateAliasForDimension")) != null) {
            String aname = aa.getStringValue();
            vi = this.njvarDS_.findDimensionIndex(aname);
        }
        if (vi < 0 && dimvar.getRank() == 1) {
            Dimension dd = dimvar.getDimension(0);
            for (int i = 0; i < this.njvarDS_.getRank(); ++i) {
                if (!this.njvarDS_.getDimension(i).equals(dd)) continue;
                vi = i;
                break;
            }
        }
        return vi;
    }

    protected CoordinateAxis getNjCoordinateAxis(NcAxisType axtype) {
        List<CoordinateSystem> csList = this.njvarDS_.getCoordinateSystems();
        int isize = csList.size();
        if (isize > 0) {
            if (isize > 1) {
                LOGGER.warn("Variable has more than one coordinate system reported");
            }
            CoordinateSystem cs = csList.get(0);
            return this.getNjCoordinateAxisCS(axtype, cs);
        }
        return this.getNjCoordinateAxisNoCS(axtype);
    }

    private CoordinateAxis getNjCoordinateAxisCS(NcAxisType axtype, CoordinateSystem cs) {
        switch (axtype) {
            case LAT: {
                CoordinateAxis lat = cs.getLatAxis();
                if (lat == null) {
                    for (int i = 0; i < this.rank_; ++i) {
                        Dimension d = this.njvarDS_.getDimension(i);
                        VariableDS cv = this.getDataset().getNjCoordinateVariable(d);
                        if (cv == null || !NcVarUtils.isLatitudeVar1D(cv)) continue;
                        lat = this.dataset_.createNjCoordinateAxis(cv, AxisType.Lat);
                    }
                }
                return lat;
            }
            case LON: {
                CoordinateAxis lon = cs.getLonAxis();
                if (lon == null) {
                    for (int i = 0; i < this.rank_; ++i) {
                        Dimension d = this.njvarDS_.getDimension(i);
                        VariableDS cv = this.getDataset().getNjCoordinateVariable(d);
                        if (!NcVarUtils.isLongitudeVar1D(cv)) continue;
                        lon = this.dataset_.createNjCoordinateAxis(cv, AxisType.Lon);
                    }
                }
                return lon;
            }
            case VERT: {
                if (!cs.hasVerticalAxis()) {
                    return null;
                }
                CoordinateAxis vertAxis = cs.getPressureAxis();
                if (vertAxis == null) {
                    vertAxis = cs.getHeightAxis();
                }
                if (vertAxis == null) {
                    vertAxis = cs.getZaxis();
                }
                return vertAxis;
            }
            case TIME: {
                CoordinateAxis tAxis = cs.getTaxis();
                if (tAxis == null) {
                    for (int i = 0; i < this.rank_; ++i) {
                        Dimension d = this.njvarDS_.getDimension(i);
                        VariableDS cv = this.getDataset().getNjCoordinateVariable(d);
                        if (cv == null || !NcVarUtils.isAbsoluteTimeVar(cv)) continue;
                        tAxis = this.dataset_.createNjCoordinateAxis(cv, AxisType.Time);
                    }
                }
                return tAxis;
            }
            case GEOX: {
                return cs.getXaxis();
            }
            case GEOY: {
                return cs.getYaxis();
            }
        }
        return null;
    }

    private CoordinateAxis getNjCoordinateAxisNoCS(NcAxisType axtype) {
        String[] tokens;
        Attribute coordsA = this.njvarDS_.findAttributeIgnoreCase("coordinates");
        VariableDS lonVar = null;
        VariableDS latVar = null;
        String cstring = coordsA == null ? "" : coordsA.getStringValue();
        for (String token : tokens = cstring.split(" ")) {
            VariableDS var = this.dataset_.getNjVariable(token);
            if (var == null) continue;
            String units = NcVarUtils.getUnitsString(var);
            if (NcUnitUtils.isDegreesEast(units)) {
                lonVar = var;
                continue;
            }
            if (!NcUnitUtils.isDegreesNorth(units)) continue;
            latVar = var;
        }
        if (axtype == NcAxisType.LAT) {
            if (latVar == null) {
                return null;
            }
            return this.dataset_.createNjCoordinateAxis(latVar, AxisType.Lat);
        }
        if (axtype == NcAxisType.LON) {
            if (lonVar == null) {
                return null;
            }
            return this.dataset_.createNjCoordinateAxis(lonVar, AxisType.Lon);
        }
        return null;
    }

    protected VariableDS getCoordinateVar(NcAxisType axtype) {
        int rank = this.njvarDS_.getRank();
        int[] shape = this.njvarDS_.getShape();
        for (int i = 0; i < rank; ++i) {
            Dimension d;
            VariableDS cv;
            if (shape[i] < 2 || (cv = this.dataset_.getNjCoordinateVariable(d = this.njvarDS_.getDimension(i))) == null) continue;
            if (axtype == NcAxisType.LON && NcVarUtils.isLongitudeVar1D(cv)) {
                return cv;
            }
            if (axtype == NcAxisType.LAT && NcVarUtils.isLatitudeVar1D(cv)) {
                return cv;
            }
            if (axtype != NcAxisType.TIME || !NcVarUtils.isRelativeTimeVar(this.dataset_, cv) && !NcVarUtils.isJulianTimeVar(cv)) continue;
            return cv;
        }
        return null;
    }

    protected abstract void createFreeDimensions();

    public boolean hasFreeDimensions() {
        if (this.dimensions_ == null) {
            this.createFreeDimensions();
        }
        for (int i = 0; i < this.rank_; ++i) {
            if (this.dimensions_[i] == null) continue;
            return true;
        }
        return false;
    }

    public NcDimension[] getFreeDimensions() {
        if (this.dimensions_ == null) {
            this.createFreeDimensions();
        }
        return this.dimensions_;
    }

    public int getDimensionId(NcDimension dim) {
        if (this.dimensions_ == null) {
            this.createFreeDimensions();
        }
        if (dim == null) {
            throw new IllegalArgumentException("Dimension is null.");
        }
        for (int i = 0; i < this.rank_; ++i) {
            if (this.dimensions_[i] == null || this.dimensions_[i] != dim) continue;
            return i;
        }
        return -1;
    }

    public boolean isAveragingDimension(int dimIndex) {
        return false;
    }

    public boolean hasBadValues() {
        return this.hasBad_;
    }

    public boolean isMissingOrInvalid(double value) {
        if (Double.isNaN(value)) {
            return true;
        }
        if (this.hasMissing_ && this.njvarDS_.isMissingValue(value)) {
            return true;
        }
        if (this.hasCorrectedFill_ && value == (double)this.correctedFillValue_) {
            return true;
        }
        if (this.hasFill_ && this.njvarDS_.isFillValue(value)) {
            return true;
        }
        if (this.hasInvalid_ && this.njvarDS_.isInvalidData(value)) {
            return value > this.validMax_ || value < this.validMin_;
        }
        return this.hasBad_ && this.njvarDS_.isMissing(value);
    }

    public double minimumValue() throws NcException {
        if (this.needsExtrema_) {
            this.findExtrema();
        }
        return this.minimum_;
    }

    public double maximumValue() throws NcException {
        if (this.needsExtrema_) {
            this.findExtrema();
        }
        return this.maximum_;
    }

    protected double[] getActualRange() {
        Array rarray;
        double[] rvalues;
        Attribute rangeA = this.njvarDS_.findAttribute("actual_range");
        if (rangeA == null) {
            return null;
        }
        if (rangeA.isArray() && (rvalues = (double[])(rarray = rangeA.getValues()).get1DJavaArray(DataType.DOUBLE)).length == 2) {
            return rvalues;
        }
        return null;
    }

    protected abstract void findExtrema();

    public int getSliceIndex(int dimNum) {
        if (dimNum < 0 || dimNum >= this.shape_.length) {
            throw new IndexOutOfBoundsException("Invalid dimension ID");
        }
        return this.sIndex_[dimNum];
    }

    public void setSliceIndex(int dimNum, int index) {
        if (dimNum < 0 || dimNum >= this.shape_.length) {
            throw new IndexOutOfBoundsException("Invalid dimension ID");
        }
        if (index < 0 && !this.isAveragingDimension(dimNum)) {
            throw new IndexOutOfBoundsException("Invalid index.");
        }
        if (this.sIndex_[dimNum] != index) {
            this.sIndex_[dimNum] = index;
            this.needsSlice_ = true;
            this.needsExtrema_ = true;
        }
    }

    public NcDataset getDataset() {
        return this.ncvar_.getDataset();
    }

    public String getShortName() {
        return this.njvarDS_.getShortName();
    }

    public String getFullName() {
        String vname = this.njvarDS_.getFullName();
        LOGGER.trace("vname {}", (Object)vname);
        return vname;
    }

    public String getLongName() {
        return NcVarUtils.getLongName(this.njvarDS_);
    }

    public String getUnitsString() {
        return NcVarUtils.getUnitsString(this.njvarDS_);
    }

    public Unit getUcarUnits() {
        return NcVarUtils.getUcarUnits(this.njvarDS_);
    }

    public boolean isCompatibleUnits(NcArray v2) {
        Objects.requireNonNull(v2, "Second array cannot be null.");
        return this.isCompatibleUnits(v2.getUcarUnits());
    }

    public boolean isCompatibleUnits(Unit u2) {
        Unit u1 = this.getUcarUnits();
        if (u1 == null && u2 == null) {
            return true;
        }
        if (u1 == null || u2 == null) {
            return false;
        }
        return u2.isCompatible(u1);
    }

    protected static boolean dequals(double a, double b, double eps) {
        return Math.abs(a - b) < eps;
    }

    protected double[] aveFourLL(double lon1, double lat1, double lon2, double lat2, double lon3, double lat3, double lon4, double lat4) {
        return new double[]{0.25 * (lon1 + lon2 + lon3 + lon4), 0.25 * (lat1 + lat2 + lat3 + lat4)};
    }

    public abstract NcGridder getGridder();

    public abstract void describeCell(StringBuilder var1, PrintfFormat var2, int ... var3);
}

