/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import gov.nasa.giss.data.nc.NcDataGrouping;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.text.StringUtils;
import java.io.IOException;
import ucar.nc2.Group;
import ucar.nc2.dataset.VariableDS;

public class NcGroup
extends NcDataGrouping {
    public NcGroup(NcDataset d, Group njgroup) throws IOException {
        super(d);
        this.setGrouping(njgroup);
        this.initChildren();
    }

    public VariableDS getNjVariable(String name) {
        return (VariableDS)this.njgroup_.findVariable(name);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public Object getObject() {
        return this;
    }

    @Override
    public String getName() {
        return this.njgroup_.getShortName();
    }

    @Override
    public String getLongName() {
        return this.njgroup_.getFullName();
    }

    @Override
    public String getNcType() {
        return "\u2014";
    }

    @Override
    public String getDetail(boolean enhanced) {
        String sname = this.njgroup_.getShortName();
        String fname = this.njgroup_.getFullName();
        StringBuilder sb = new StringBuilder();
        sb.append("<html>").append("<head>");
        this.appendDetailStyle(sb);
        sb.append("</head>").append("<body>").append("<h2>Group \"").append(sname).append("\"</h2>\n").append("<h3>In file \"").append(this.ncdataset_.getName()).append("\"</h3>");
        if (!sname.equals(fname)) {
            sb.append("<p>Group full name: ").append(fname).append("</p>");
        }
        sb.append("<pre>").append(StringUtils.escapeHtmlSimplistic(this.njgroup_.toString())).append('\n').append("</pre>").append("</body></html>");
        return sb.toString();
    }

    @Override
    public String getDetailType() {
        return "text/html";
    }
}

