/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import gov.nasa.giss.data.nc.NcDataNode;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcStructureVar;
import gov.nasa.giss.data.nc.NcVarClass;
import gov.nasa.giss.data.nc.ui.NcDataTreeTableModel;
import gov.nasa.giss.text.StringUtils;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Variable;
import ucar.nc2.dataset.StructureDS;

public class NcStructure
extends NcDataNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final NcDataset ncdataset_;
    private final StructureDS structDS_;

    public NcStructure(NcDataset d, StructureDS s) throws IOException {
        this.ncdataset_ = d;
        this.structDS_ = s;
        this.initChildren();
    }

    protected void initChildren() {
        this.clear();
        this.childNameList_.clear();
        for (Variable var : this.structDS_.getVariables()) {
            String fname = var.getFullName();
            this.childNameList_.add(fname);
        }
        NcVarClass vclass = this.getVisibleVarClass();
        if (vclass == NcVarClass.ALL) {
            for (Variable var : this.structDS_.getVariables()) {
                try {
                    this.addSorted(new NcStructureVar(this.ncdataset_, this, var));
                }
                catch (Exception exc) {
                    LOGGER.warn("{}", (Object)exc.toString());
                    if (!LOGGER.isTraceEnabled()) continue;
                    exc.printStackTrace();
                }
            }
        }
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public Object getObject() {
        return this;
    }

    @Override
    public String getName() {
        return this.structDS_.getFullName();
    }

    @Override
    public String getLongName() {
        return this.getName();
    }

    @Override
    public String getNcType() {
        return "\u2014";
    }

    @Override
    public String getDetail(boolean enhanced) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("<html>").append("<head>");
        this.appendDetailStyle(sb);
        sb.append("</head>").append("<body>").append("<h2>Structure \"").append(this.getName()).append("\"</h2>\n").append("<h3>In file \"").append(this.ncdataset_.getName()).append("\"</h3>\n").append("<hr>").append("<pre>").append(StringUtils.escapeHtmlSimplistic(this.structDS_.toString())).append('\n').append("</pre>").append("</body></html>");
        return sb.toString();
    }

    @Override
    public String getDetailType() {
        return "text/html";
    }

    @Override
    public void setVisibleVarClass(NcDataTreeTableModel model, NcVarClass vclass) {
        super.setVisibleVarClass(model, vclass);
        TreeTableNode[] children = this.getChildren();
        if (vclass == NcVarClass.GEOREFERENCED || vclass == NcVarClass.GRIDDABLE) {
            for (int i = children.length - 1; i >= 0; --i) {
                NcDataNode node = (NcDataNode)children[i];
                if (node instanceof NcStructureVar) {
                    this.remove(node);
                    if (model == null) continue;
                    model.nodeRemoved(this, i, node);
                    continue;
                }
                this.remove(node);
            }
        }
        if (vclass == NcVarClass.ALL) {
            for (Variable var : this.structDS_.getVariables()) {
                try {
                    NcStructureVar node = new NcStructureVar(this.ncdataset_, this, var);
                    int index = this.addSorted(node);
                    if (model == null) continue;
                    model.nodeInserted(this, index, node);
                }
                catch (Exception exc) {
                    LOGGER.error(exc.toString());
                    if (!LOGGER.isTraceEnabled()) continue;
                    exc.printStackTrace();
                }
            }
        }
    }
}

