/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import gov.nasa.giss.data.nc.NcAltGridding;
import gov.nasa.giss.data.nc.NcAltGriddingVarType;
import gov.nasa.giss.data.nc.NcCartesianVarType;
import gov.nasa.giss.data.nc.NcCoordinateVarType;
import gov.nasa.giss.data.nc.NcDataGrouping;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcDiscreteVarType;
import gov.nasa.giss.data.nc.NcGeometryType;
import gov.nasa.giss.data.nc.NcUnitUtils;
import gov.nasa.giss.data.nc.NcVarType;
import gov.nasa.giss.data.nc.NcVarUtils;
import gov.nasa.giss.data.nc.array.NcArrayDiscreteTrajectory;
import gov.nasa.giss.data.nc.array.NcArrayLonLatAuxiliary2D;
import gov.nasa.giss.data.nc.array.NcArrayLonLatAuxiliary3D;
import gov.nasa.giss.data.nc.array.NcArrayLonLatCubedSphereCAMSE;
import gov.nasa.giss.data.nc.array.NcArrayLonLatCubedSphereGMAO;
import gov.nasa.giss.data.nc.array.NcArrayLonLatReduced2D;
import gov.nasa.giss.data.nc.array.NcArrayLonLatReducedCF;
import gov.nasa.giss.data.nc.array.NcArrayLonLatReducedISCCP;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;

public final class NcVarTypeDetector {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static void setDevoMode() {
    }

    public static NcVarType getVarType(NcDataset ncd, NcDataGrouping ncg, VariableDS varDS) {
        LOGGER.trace("==========");
        LOGGER.trace("var {}", (Object)varDS.getFullName());
        if (varDS.isScalar()) {
            return NcVarType.SCALAR;
        }
        DataType dt = varDS.getDataType();
        if (!dt.isNumeric()) {
            return NcVarType.OTHER;
        }
        NcGeometryType geometry = ncd.getGeometry();
        LOGGER.trace("- geometry {}", (Object)geometry);
        if (geometry == NcGeometryType.TRAJECTORY || geometry == NcGeometryType.TRAJECTORY_PROFILE) {
            NcVarType vtype = NcVarTypeDetector.getDiscreteVarTypeRequiresFT(ncd, varDS);
            LOGGER.trace("- trajectory type? {}", (Object)vtype);
            return vtype;
        }
        NcVarType vtype = NcVarTypeDetector.getGriddedVarType(ncd, ncg, varDS);
        LOGGER.trace("- gridded type? {}", (Object)vtype);
        if (vtype == NcVarType.ONED) {
            LOGGER.trace("- no feature type, but might be discrete type");
            vtype = NcVarTypeDetector.getDiscreteVarTypeNoFT(ncd, varDS);
            LOGGER.trace("- got discrete type {}", (Object)vtype);
        }
        LOGGER.trace("- returning type {}", (Object)vtype);
        return vtype;
    }

    private static NcVarType getDiscreteVarTypeRequiresFT(NcDataset ncd, VariableDS varDS) {
        block6: {
            LOGGER.trace("");
            NcGeometryType geometry = ncd.getGeometry();
            LOGGER.trace("ncd geometry {}", (Object)geometry);
            try {
                if (geometry == NcGeometryType.TRAJECTORY || geometry == NcGeometryType.TRAJECTORY_PROFILE) {
                    boolean isTrajectory = NcArrayDiscreteTrajectory.canGridVariable(ncd, varDS, true);
                    LOGGER.trace("NcArrayDiscreteTrajectory returns {}", (Object)isTrajectory);
                    if (isTrajectory) {
                        return new NcDiscreteVarType(NcGeometryType.TRAJECTORY);
                    }
                    break block6;
                }
                if (NcVarUtils.isGriddable1D(varDS)) {
                    return NcVarType.ONED;
                }
                return NcVarType.OTHER;
            }
            catch (Exception exc) {
                LOGGER.debug("Exception querying for discrete var type: {}", (Object)exc.toString());
                if (!LOGGER.isTraceEnabled()) break block6;
                exc.printStackTrace();
            }
        }
        if (NcVarUtils.isGriddable1D(varDS)) {
            return NcVarType.ONED;
        }
        return NcVarType.OTHER;
    }

    private static NcVarType getDiscreteVarTypeNoFT(NcDataset ncd, VariableDS varDS) {
        block4: {
            LOGGER.trace("");
            try {
                boolean isTrajectory = NcArrayDiscreteTrajectory.canGridVariable(ncd, varDS, false);
                LOGGER.trace("NcArrayDiscreteTrajectory returns {}", (Object)isTrajectory);
                if (isTrajectory) {
                    return new NcDiscreteVarType(NcGeometryType.TRAJECTORY);
                }
            }
            catch (Exception exc) {
                LOGGER.debug("Exception querying for discrete var type: {}", (Object)exc.toString());
                if (!LOGGER.isTraceEnabled()) break block4;
                exc.printStackTrace();
            }
        }
        if (NcVarUtils.isGriddable1D(varDS)) {
            return NcVarType.ONED;
        }
        return NcVarType.OTHER;
    }

    private static NcVarType getGriddedVarType(NcDataset ncd, NcDataGrouping ncg, VariableDS varDS) {
        NcVarType vtype;
        block9: {
            DataType dt = varDS.getDataType();
            LOGGER.trace("dt {}", (Object)dt);
            if (!dt.isNumeric()) {
                return NcVarType.OTHER;
            }
            int[] vshape = varDS.getShape();
            long vsize = 1L;
            for (int i = 0; i < vshape.length; ++i) {
                if (vshape[i] == 0) {
                    return NcVarType.OTHER;
                }
                vsize *= (long)vshape[i];
            }
            if (vsize == 1L) {
                return NcVarType.SCALAR;
            }
            LOGGER.trace("is it projected?", (Object)dt);
            vtype = NcVarTypeDetector.getProjectedLonLatType(ncd, varDS);
            if (vtype instanceof NcAltGriddingVarType) {
                return vtype;
            }
            LOGGER.trace("is it alt?", (Object)dt);
            vtype = null;
            try {
                vtype = NcVarTypeDetector.getAlternativeLonLatType(ncd, ncg, varDS);
            }
            catch (Exception exc) {
                LOGGER.trace("Ouch! getAlternativeLonLatType threw {}", (Object)exc.toString());
                if (!LOGGER.isTraceEnabled()) break block9;
                exc.printStackTrace();
            }
        }
        LOGGER.trace("alternative type returns {}", (Object)vtype);
        if (vtype != null) {
            return vtype;
        }
        List<CoordinateSystem> csList = varDS.getCoordinateSystems();
        int csSize = csList.size();
        LOGGER.trace("...CS list size {}", (Object)csSize);
        if (csSize > 0) {
            CoordinateSystem cs = csList.get(0);
            return NcVarTypeDetector.getGriddedVarTypeCS(ncd, varDS, cs);
        }
        return NcVarTypeDetector.getGriddedVarTypeNoCS(ncd, varDS);
    }

    private static NcVarType getGriddedVarTypeCS(NcDataset ncd, VariableDS varDS, CoordinateSystem cs) {
        int ii;
        boolean hasTime;
        boolean hasVert;
        boolean hasLat;
        boolean hasLon;
        CoordinateAxis zAxis;
        CoordinateAxis tAxis;
        CoordinateAxis latAxis;
        CoordinateAxis lonAxis;
        block28: {
            block30: {
                int[] ashape;
                block32: {
                    block31: {
                        block29: {
                            block23: {
                                block25: {
                                    block27: {
                                        block26: {
                                            block24: {
                                                if (LOGGER.isTraceEnabled()) {
                                                    List<CoordinateAxis> axes = cs.getCoordinateAxes();
                                                    for (CoordinateAxis axis : axes) {
                                                        LOGGER.trace("axis {} is {}", (Object)axis.getShortName(), (Object)axis.getAxisType());
                                                    }
                                                }
                                                lonAxis = cs.getLonAxis();
                                                latAxis = cs.getLatAxis();
                                                tAxis = cs.getTaxis();
                                                zAxis = cs.getPressureAxis();
                                                if (zAxis == null) {
                                                    zAxis = cs.getHeightAxis();
                                                }
                                                if (zAxis == null) {
                                                    zAxis = cs.getZaxis();
                                                }
                                                hasLon = false;
                                                hasLat = false;
                                                hasVert = false;
                                                hasTime = false;
                                                if (lonAxis instanceof CoordinateAxis1D && tAxis instanceof CoordinateAxis1D && NcVarTypeDetector.doAxesShareDimension((CoordinateAxis1D)lonAxis, (CoordinateAxis1D)tAxis)) {
                                                    lonAxis = null;
                                                }
                                                if (latAxis instanceof CoordinateAxis1D && tAxis instanceof CoordinateAxis1D && NcVarTypeDetector.doAxesShareDimension((CoordinateAxis1D)latAxis, (CoordinateAxis1D)tAxis)) {
                                                    latAxis = null;
                                                }
                                                if (lonAxis == null) break block23;
                                                LOGGER.trace("...found lon axis {}", (Object)lonAxis.getFullName());
                                                ashape = lonAxis.getShape();
                                                if (ashape != null) break block24;
                                                lonAxis = null;
                                                break block25;
                                            }
                                            if (ashape.length >= 1 && ashape.length <= 3) break block26;
                                            lonAxis = null;
                                            break block25;
                                        }
                                        if (ashape.length != 1) break block27;
                                        if (ashape[0] >= 2) break block25;
                                        lonAxis = null;
                                        break block25;
                                    }
                                    for (ii = ashape.length - 2; ii < ashape.length; ++ii) {
                                        if (ashape[ii] >= 2) continue;
                                        lonAxis = null;
                                        break;
                                    }
                                }
                                boolean bl = hasLon = lonAxis != null;
                            }
                            if (latAxis == null) break block28;
                            LOGGER.trace("...found lat axis {}", (Object)latAxis.getFullName());
                            ashape = latAxis.getShape();
                            if (ashape != null) break block29;
                            latAxis = null;
                            break block30;
                        }
                        if (ashape.length >= 1 && ashape.length <= 3) break block31;
                        latAxis = null;
                        break block30;
                    }
                    if (ashape.length != 1) break block32;
                    if (ashape[0] >= 2) break block30;
                    latAxis = null;
                    break block30;
                }
                for (ii = ashape.length - 2; ii < ashape.length; ++ii) {
                    if (ashape[ii] >= 2) continue;
                    latAxis = null;
                    break;
                }
            }
            if (latAxis instanceof CoordinateAxis1D && !NcVarTypeDetector.isMonotonicAxis(latAxis)) {
                latAxis = null;
            }
            boolean bl = hasLat = latAxis != null;
        }
        if (cs.isLatLon() && hasLon && hasLat) {
            boolean altLonLat;
            int lonDI = -1;
            int latDI = -1;
            if (lonAxis.getRank() == 1 && latAxis.getRank() == 1) {
                Dimension lonDD = lonAxis.getDimension(0);
                Dimension latDD = latAxis.getDimension(0);
                lonDI = NcVarUtils.findDimensionIndex(varDS, lonDD);
                latDI = NcVarUtils.findDimensionIndex(varDS, latDD);
            }
            boolean bl = altLonLat = lonDI < 0 && latDI < 0;
            if (altLonLat) {
                if (NcVarTypeDetector.is1DAuxiliaryLonLat(varDS)) {
                    hasLon = true;
                    hasLat = true;
                } else {
                    hasLon = false;
                    hasLat = false;
                }
            }
        } else if (cs.isGeoXY() || cs.getXaxis() == null || cs.getYaxis() != null) {
            // empty if block
        }
        if (!hasLon && !hasLat && NcVarTypeDetector.hasMessyLonLatDimensions(ncd, varDS)) {
            LOGGER.trace("...looks like messy lon-lat");
            hasLon = true;
            hasLat = true;
        }
        if (hasVert = cs.hasVerticalAxis()) {
            Dimension dd;
            LOGGER.trace("...Vert axis reported");
            if (zAxis != null && zAxis.getShape().length == 1 && (ii = NcVarUtils.findDimensionIndex(varDS, dd = zAxis.getDimension(0))) < 0) {
                zAxis = null;
            }
            if (!NcVarTypeDetector.isMonotonicAxis(zAxis)) {
                zAxis = null;
            }
            boolean bl = hasVert = zAxis != null && zAxis.getShape().length == 1 && zAxis.getShape()[0] >= 2;
        }
        hasTime = (hasTime = cs.hasTimeAxis()) ? tAxis != null && tAxis.getShape().length >= 1 && tAxis.getShape()[0] >= 2 : NcVarTypeDetector.hasTimeDimension(ncd, varDS);
        if (hasLon && hasLat || hasLon && hasTime || hasLon && hasVert || hasLat && hasTime || hasLat && hasVert || hasTime && hasVert) {
            return new NcCartesianVarType(hasLon, hasLat, hasVert, hasTime);
        }
        if (NcVarUtils.isGriddable2D(varDS)) {
            return new NcCartesianVarType();
        }
        if (NcVarUtils.isGriddable1D(varDS)) {
            return NcVarType.ONED;
        }
        return NcVarType.OTHER;
    }

    private static NcVarType getGriddedVarTypeNoCS(NcDataset ncd, VariableDS varDS) {
        boolean hasLon = NcVarTypeDetector.hasLongitudeDim(ncd, varDS);
        boolean hasLat = NcVarTypeDetector.hasLatitudeDim(ncd, varDS);
        boolean hasTime = NcVarTypeDetector.hasTimeDimension(ncd, varDS);
        if (hasLon && hasLat || hasLon && hasTime || hasLat && hasTime) {
            return new NcCartesianVarType(hasLon, hasLat, false, hasTime);
        }
        if (NcVarUtils.isGriddable2D(varDS)) {
            return new NcCartesianVarType();
        }
        if (NcVarUtils.isGriddable1D(varDS)) {
            return NcVarType.ONED;
        }
        return NcVarType.OTHER;
    }

    private static boolean doAxesShareDimension(CoordinateAxis1D ax1, CoordinateAxis1D ax2) {
        Dimension dim1 = ax1.getDimension(0);
        Dimension dim2 = ax2.getDimension(0);
        if (dim1 == null || dim2 == null) {
            return false;
        }
        return dim1.equals(dim2);
    }

    private static boolean hasMessyLonLatDimensions(NcDataset ncd, VariableDS varDS) {
        boolean hasLon = NcVarTypeDetector.hasLongitudeDim(ncd, varDS);
        boolean hasLat = NcVarTypeDetector.hasLatitudeDim(ncd, varDS);
        return hasLon && hasLat;
    }

    private static boolean hasLongitudeDim(NcDataset ncd, VariableDS varDS) {
        int rank = varDS.getRank();
        for (int i = 0; i < rank; ++i) {
            Dimension d = varDS.getDimension(i);
            VariableDS cv = ncd.getNjCoordinateVariable(d);
            if (cv == null || !NcVarUtils.isLongitudeVar1D(cv)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasLatitudeDim(NcDataset ncd, VariableDS varDS) {
        int rank = varDS.getRank();
        for (int i = 0; i < rank; ++i) {
            Dimension d = varDS.getDimension(i);
            VariableDS cv = ncd.getNjCoordinateVariable(d);
            if (cv == null || !NcVarUtils.isLatitudeVar1D(cv)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasTimeDimension(NcDataset ncd, VariableDS varDS) {
        int rank = varDS.getRank();
        for (int i = 0; i < rank; ++i) {
            Dimension d = varDS.getDimension(i);
            VariableDS cv = ncd.getNjCoordinateVariable(d);
            if (cv == null || !NcVarUtils.isRelativeTimeVar(ncd, cv) && !NcVarUtils.isJulianTimeVar(cv) && !NcVarUtils.isAbsoluteTimeVar(cv)) continue;
            return true;
        }
        return false;
    }

    private static boolean is1DAuxiliaryLonLat(VariableDS varDS) {
        Dimension d2;
        List<CoordinateSystem> l = varDS.getCoordinateSystems();
        if (l == null || l.isEmpty()) {
            return false;
        }
        CoordinateSystem cs = l.get(0);
        if (cs == null) {
            return false;
        }
        CoordinateAxis lonax = cs.getLonAxis();
        CoordinateAxis latax = cs.getLatAxis();
        if (lonax == null || latax == null) {
            return false;
        }
        if (!(lonax instanceof CoordinateAxis1D)) {
            return false;
        }
        if (!(latax instanceof CoordinateAxis1D)) {
            return false;
        }
        int[] lonshape = lonax.getShape();
        if (lonshape.length != 1 || lonshape[0] < 2) {
            return false;
        }
        int[] latshape = latax.getShape();
        if (latshape.length != 1 || latshape[0] < 2) {
            return false;
        }
        Dimension d1 = lonax.getDimension(0);
        return !d1.equals(d2 = latax.getDimension(0));
    }

    private static NcVarType getAlternativeLonLatType(NcDataset ncd, NcDataGrouping ncg, VariableDS varDS) {
        NcAltGriddingVarType varType = null;
        if (NcArrayLonLatCubedSphereGMAO.canGridVariable(ncd, varDS)) {
            varType = new NcAltGriddingVarType(NcAltGridding.CUBED_SPHERE_SIMPLE);
        } else if (NcArrayLonLatCubedSphereCAMSE.canGridVariable(ncd, varDS)) {
            varType = new NcAltGriddingVarType(NcAltGridding.CUBED_SPHERE_CAM_SE);
        } else if (NcArrayLonLatAuxiliary2D.canGridVariable(ncd, ncg, varDS)) {
            varType = new NcAltGriddingVarType(NcAltGridding.AUXILIARY_2D);
        } else if (NcArrayLonLatAuxiliary3D.canGridVariable(ncd, ncg, varDS)) {
            varType = new NcAltGriddingVarType(NcAltGridding.AUXILIARY_3D);
        } else if (NcVarTypeDetector.hasRotLonLatDimensions(ncd, varDS)) {
            varType = new NcAltGriddingVarType(NcAltGridding.ROTATED_POLE);
        } else if (NcArrayLonLatReducedCF.canGridVariable(ncd, varDS)) {
            varType = new NcAltGriddingVarType(NcAltGridding.REDUCED_1);
        } else if (NcArrayLonLatReduced2D.canGridVariable(ncd, varDS)) {
            varType = new NcAltGriddingVarType(NcAltGridding.REDUCED_2);
        } else if (NcArrayLonLatReducedISCCP.canGridVariable(ncd, varDS)) {
            varType = new NcAltGriddingVarType(NcAltGridding.REDUCED_ISCCP);
        }
        if (varType != null) {
            return varType;
        }
        return null;
    }

    private static NcVarType getProjectedLonLatType(NcDataset ncd, VariableDS varDS) {
        int rank = varDS.getRank();
        if (rank < 2) {
            LOGGER.trace("Does not have rank 2+");
            return null;
        }
        VariableDS tvarDS = NcVarUtils.findGridMappingVariable(ncd, varDS);
        LOGGER.trace("tvarDS {}", (Object)tvarDS);
        if (tvarDS == null) {
            return null;
        }
        String gmName = NcVarUtils.getGridMappingName(tvarDS);
        if (gmName == null) {
            LOGGER.debug("Apparent grid mapping var had no grid mapping name");
            return null;
        }
        if (gmName.equals("latitude_longitude")) {
            return new NcCartesianVarType();
        }
        if (gmName.equalsIgnoreCase("albers_equal_area_conic") || gmName.equalsIgnoreCase("albers_conical_equal_area")) {
            return new NcAltGriddingVarType(NcAltGridding.ALBERS_CONIC);
        }
        if (gmName.equalsIgnoreCase("azimuthal_equal_area") || gmName.equalsIgnoreCase("lambert_azimuthal_equal_area")) {
            return new NcAltGriddingVarType(NcAltGridding.AZIM_EQUAL_AREA);
        }
        if (gmName.equalsIgnoreCase("azimuthal_equidistant")) {
            return new NcAltGriddingVarType(NcAltGridding.AZIM_EQUIDISTANT);
        }
        if (gmName.equalsIgnoreCase("cylindrical_equal_area") || gmName.equalsIgnoreCase("lambert_cylindrical_equal_area")) {
            return new NcAltGriddingVarType(NcAltGridding.CYL_EQUAL_AREA);
        }
        if (gmName.equalsIgnoreCase("geostationary")) {
            return new NcAltGriddingVarType(NcAltGridding.GEOSTATIONARY);
        }
        if (gmName.equalsIgnoreCase("lambert_conformal_conic")) {
            return new NcAltGriddingVarType(NcAltGridding.LAMBERT_CONFORMAL);
        }
        if (gmName.equalsIgnoreCase("mercator")) {
            return new NcAltGriddingVarType(NcAltGridding.MERCATOR);
        }
        if (gmName.equalsIgnoreCase("MSGnavigation")) {
            return new NcAltGriddingVarType(NcAltGridding.MSG_NAV);
        }
        if (gmName.equalsIgnoreCase("rotated_pole") || gmName.equalsIgnoreCase("rotated_latitude_longitude") || gmName.equalsIgnoreCase("rotated_latlon_grib")) {
            return new NcAltGriddingVarType(NcAltGridding.ROTATED_POLE);
        }
        if (gmName.equalsIgnoreCase("sinusoidal")) {
            return new NcAltGriddingVarType(NcAltGridding.SINUSOIDAL);
        }
        if (gmName.equalsIgnoreCase("polar_stereographic") || gmName.equalsIgnoreCase("stereographic")) {
            return new NcAltGriddingVarType(NcAltGridding.STEREOGRAPHIC);
        }
        if (gmName.equalsIgnoreCase("transverse_mercator")) {
            return new NcAltGriddingVarType(NcAltGridding.TRANSVERSE_MERCATOR);
        }
        if (gmName.equalsIgnoreCase("universal_transverse_mercator")) {
            return new NcAltGriddingVarType(NcAltGridding.UTM);
        }
        LOGGER.debug("...grid mapping name {} is not recognized", (Object)gmName);
        return null;
    }

    private static boolean hasRotLonLatDimensions(NcDataset ncd, Variable varDS) {
        int rank = varDS.getRank();
        String lonName = null;
        String latName = null;
        for (int i = 0; i < rank; ++i) {
            Dimension d = varDS.getDimension(i);
            String dname = d.getShortName();
            if (dname == null) continue;
            String lcname = dname.toLowerCase();
            if (lcname.contains("lon")) {
                lonName = dname;
                continue;
            }
            if (!lcname.contains("lat")) continue;
            latName = dname;
        }
        if (lonName != null && latName != null) {
            VariableDS lonV = ncd.getNjVariable(lonName);
            VariableDS latV = ncd.getNjVariable(latName);
            if (lonV == null || latV == null) {
                return false;
            }
            Attribute lonA = ncd.getNjVariable(lonName).findAttribute("long_name");
            Attribute latA = ncd.getNjVariable(latName).findAttribute("long_name");
            if (lonA != null && latA != null && lonA.getStringValue().contains("rotated") && latA.getStringValue().contains("rotated")) {
                return true;
            }
        }
        return false;
    }

    private static boolean isMonotonicAxis(VariableDS njvarDS) {
        int[] shape = njvarDS.getShape();
        if (shape.length != 1) {
            LOGGER.trace("Shape is not 1D -> not monotonic.");
            return false;
        }
        int numVals = shape[0];
        if (numVals < 2) {
            return true;
        }
        Array vArray = null;
        try {
            vArray = njvarDS.read();
        }
        catch (Exception exc) {
            LOGGER.trace("Could not verify monotonic due to variable read exception.");
            return false;
        }
        double[] values = new double[numVals];
        for (int j = 0; j < numVals; ++j) {
            double value = vArray.getDouble(vArray.getIndex().set(j));
            if (Double.isNaN(value)) {
                LOGGER.trace("Could not verify monotonic due to presence of NaN,");
                return false;
            }
            values[j] = value;
        }
        boolean increasing = values[1] > values[0];
        for (int j = 2; j < numVals; ++j) {
            if (!(increasing ? values[j] < values[j - 1] : values[j] > values[j - 1])) continue;
            return false;
        }
        return true;
    }

    public static NcCoordinateVarType getCoordinateVarType(VariableDS varDS) {
        String lcname = varDS.getShortName().toLowerCase();
        String unitsStr = NcVarUtils.getUnitsString(varDS);
        if (lcname.equals("longitude") || NcUnitUtils.isDegreesEast(unitsStr)) {
            return NcCoordinateVarType.LONGITUDE;
        }
        if (lcname.equals("latitude") || NcUnitUtils.isDegreesNorth(unitsStr)) {
            return NcCoordinateVarType.LATITUDE;
        }
        if (NcVarUtils.isPressure(varDS) || NcVarUtils.isHeight(varDS) || NcVarUtils.isDepth(varDS)) {
            return NcCoordinateVarType.VERTICAL;
        }
        return NcCoordinateVarType.NONE;
    }

    private NcVarTypeDetector() {
    }
}

