/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcDimension;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcStringUtils;
import gov.nasa.giss.data.nc.NcUnitUtils;
import gov.nasa.giss.data.nc.NcVarUtils;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArrayLonLat;
import gov.nasa.giss.data.nc.array.NcArrayUtils;
import gov.nasa.giss.data.nc.gridder.NcGridder;
import gov.nasa.giss.data.nc.gridder.NcGridderLonLatCubedSphereCAMSE;
import gov.nasa.giss.map.LonLatBounds;
import gov.nasa.giss.math.PointLL;
import gov.nasa.giss.text.PrintfFormat;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayInt;
import ucar.ma2.Index;
import ucar.nc2.Dimension;
import ucar.nc2.dataset.VariableDS;

public class NcArrayLonLatCubedSphereCAMSE
extends NcArray
implements NcArrayLonLat {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected NcAxis yAxis_;
    private Array lonArray_;
    private Array latArray_;
    private Index lonIndex_;
    private Index latIndex_;
    private int numCorners_;
    private int numElements_;
    protected int cornersDimNum_;
    private ArrayInt.D2 centersArray_;
    private int[][] cornerElems_;

    public NcArrayLonLatCubedSphereCAMSE(NcVariable ncvar) throws NcException {
        super(ncvar);
        this.initMe();
    }

    private final void initMe() {
        int i;
        this.rank_ = this.njvarDS_.getRank();
        this.shape_ = this.njvarDS_.getShape();
        int ncol = NcArrayLonLatCubedSphereCAMSE.getNcol(this.njvarDS_);
        if (ncol < 0) {
            throw new NcException("not NCOL = 48602");
        }
        this.cornersDimNum_ = this.findDimensionIndex("ncol");
        if (this.cornersDimNum_ < 0) {
            throw new NcException("Could not find NCOL dimension");
        }
        VariableDS[] lonlatDS = NcArrayLonLatCubedSphereCAMSE.getLonLatVarsDS(this.dataset_, this.njvarDS_);
        if (lonlatDS == null) {
            throw new NcException("did not get lon and lat vars");
        }
        VariableDS lonVarDS = lonlatDS[0];
        try {
            this.lonArray_ = lonVarDS.read();
            this.lonIndex_ = this.lonArray_.getIndex();
        }
        catch (Exception exc) {
            throw new NcException("Could not read lon axis array");
        }
        VariableDS latVarDS = lonlatDS[1];
        try {
            this.latArray_ = latVarDS.read();
            this.latIndex_ = this.latArray_.getIndex();
        }
        catch (Exception exc) {
            throw new NcException("Could not read lat axis array");
        }
        int[] shape = this.lonArray_.getShape();
        this.numCorners_ = shape[0];
        this.numElements_ = this.numCorners_ - 2;
        this.sIndex_ = new int[this.rank_];
        for (int i2 = 0; i2 < this.rank_; ++i2) {
            this.sIndex_[i2] = 0;
        }
        VariableDS centersVarDS = NcArrayLonLatCubedSphereCAMSE.getCentersVarDS(this.dataset_, this.njvarDS_);
        try {
            this.centersArray_ = (ArrayInt.D2)centersVarDS.read();
        }
        catch (Exception exc) {
            LOGGER.debug("{}", exc);
            throw new NcException("Could not read centers array");
        }
        this.cornerElems_ = new int[this.numCorners_][4];
        for (i = 0; i < this.numCorners_; ++i) {
            this.cornerElems_[i][0] = -1;
            this.cornerElems_[i][1] = -1;
            this.cornerElems_[i][2] = -1;
            this.cornerElems_[i][3] = -1;
        }
        for (i = 0; i < this.numElements_; ++i) {
            int[] elemCorners = this.getElementCorners(i);
            block9: for (int j = 0; j < 4; ++j) {
                int cornerIndex = elemCorners[j];
                for (int k = 0; k < 4; ++k) {
                    if (this.cornerElems_[cornerIndex][k] >= 0) continue;
                    this.cornerElems_[cornerIndex][k] = i;
                    continue block9;
                }
            }
        }
    }

    public int getNumCorners() {
        return this.numCorners_;
    }

    public int getNumElements() {
        return this.numCorners_ - 2;
    }

    @Override
    protected void createFreeDimensions() {
        if (this.dimensions_ != null) {
            return;
        }
        this.dimensions_ = new NcDimension[this.rank_];
        for (int i = 0; i < this.rank_; ++i) {
            this.dimensions_[i] = i == this.cornersDimNum_ ? null : this.ncvar_.getDimension(i);
        }
    }

    @Override
    protected void findExtrema() {
        double[] range = this.getActualRange();
        if (range != null) {
            this.minimum_ = range[0];
            this.maximum_ = range[1];
            this.needsExtrema_ = false;
            return;
        }
        this.minimum_ = Double.POSITIVE_INFINITY;
        this.maximum_ = Double.NEGATIVE_INFINITY;
        try {
            for (int i = 0; i < this.numCorners_; ++i) {
                double value = this.valueAt(i);
                if (this.isMissingOrInvalid(value)) continue;
                if (this.maximum_ < this.minimum_) {
                    this.minimum_ = value;
                    this.maximum_ = value;
                    continue;
                }
                if (value < this.minimum_) {
                    this.minimum_ = value;
                    continue;
                }
                if (!(value > this.maximum_)) continue;
                this.maximum_ = value;
            }
        }
        catch (Exception exc) {
            LOGGER.error(exc.toString());
        }
        if (Double.isInfinite(this.minimum_)) {
            this.minimum_ = Double.NaN;
            this.maximum_ = Double.NaN;
        }
        this.needsExtrema_ = false;
    }

    @Override
    public void setSliceIndex(int dimNum, int index) {
        super.setSliceIndex(dimNum, index);
    }

    public double valueAt(int index) {
        if (index < 0 || index >= this.numCorners_) {
            throw new IndexOutOfBoundsException("Index out of range: " + index + ", " + this.numCorners_);
        }
        if (this.needsSlice_) {
            this.doSlice();
        }
        try {
            return this.getDoubleFromSlice(index);
        }
        catch (Exception exc) {
            LOGGER.error("Slice getDouble failed -  index = {}.{}", (Object)index);
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            throw new NcException(exc.toString());
        }
    }

    private double getDoubleFromSlice(int index) {
        int[] ss = new int[this.rank_];
        for (int i = 0; i < this.rank_; ++i) {
            ss[i] = 0;
        }
        ss[this.cornersDimNum_] = index;
        this.sliceIdx_.set(ss);
        return NcArrayUtils.getDoubleFromSlice(this.slice_, this.sliceIdx_, this.hasScaleOffset_, this.isUnsigned_);
    }

    private synchronized void doSlice() throws NcException {
        int[] sOrigin = new int[this.rank_];
        int[] sShape = new int[this.rank_];
        try {
            this.needsSlice_ = true;
            for (int i = 0; i < this.rank_; ++i) {
                sOrigin[i] = this.sIndex_[i];
                sShape[i] = 1;
            }
            sOrigin[this.cornersDimNum_] = 0;
            sShape[this.cornersDimNum_] = this.numCorners_;
            this.slice_ = this.njvarDS_.read(sOrigin, sShape);
            this.sliceIdx_ = this.slice_.getIndex();
            this.needsSlice_ = false;
        }
        catch (Exception exc) {
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            throw new NcException("Do Slice - " + exc.toString());
        }
    }

    public double getCornerLongitudeAt(int cindex) {
        if (cindex < 0 || cindex >= this.numCorners_) {
            return Double.NaN;
        }
        this.lonIndex_.set(cindex);
        return this.lonArray_.getDouble(this.lonIndex_);
    }

    public double getCornerLatitudeAt(int cindex) {
        if (cindex < 0 || cindex >= this.numCorners_) {
            return Double.NaN;
        }
        this.latIndex_.set(cindex);
        double lat = this.latArray_.getDouble(this.latIndex_);
        if (NcArrayLonLat.isBadLatitude(lat)) {
            return Double.NaN;
        }
        return lat;
    }

    public PointLL getCornerLonLatAt(int cindex) {
        if (cindex < 0 || cindex >= this.numCorners_) {
            return null;
        }
        double lon = this.getCornerLongitudeAt(cindex);
        double lat = this.getCornerLatitudeAt(cindex);
        if (Double.isNaN(lon) || Double.isNaN(lat)) {
            return null;
        }
        return new PointLL(lon, lat);
    }

    public PointLL getElementLonLatAt(int eindex) {
        if (eindex < 0) {
            return null;
        }
        int[] cornerIDs = this.getElementCorners(eindex);
        double lon1 = this.getCornerLongitudeAt(cornerIDs[0]);
        double lon2 = this.getCornerLongitudeAt(cornerIDs[1]);
        double lon3 = this.getCornerLongitudeAt(cornerIDs[2]);
        double lon4 = this.getCornerLongitudeAt(cornerIDs[3]);
        double lat1 = this.getCornerLatitudeAt(cornerIDs[0]);
        double lat2 = this.getCornerLatitudeAt(cornerIDs[1]);
        double lat3 = this.getCornerLatitudeAt(cornerIDs[2]);
        double lat4 = this.getCornerLatitudeAt(cornerIDs[3]);
        if (lon1 - lon2 > 180.0) {
            lon2 += 360.0;
        } else if (lon2 - lon1 > 180.0) {
            lon2 -= 360.0;
        }
        if (lon1 - lon3 > 180.0) {
            lon3 += 360.0;
        } else if (lon3 - lon1 > 180.0) {
            lon3 -= 360.0;
        }
        if (lon1 - lon4 > 180.0) {
            lon4 += 360.0;
        } else if (lon4 - lon1 > 180.0) {
            lon4 -= 360.0;
        }
        double lon = 0.25 * (lon1 + lon2 + lon3 + lon4);
        double lat = 0.25 * (lat1 + lat2 + lat3 + lat4);
        return new PointLL(lon, lat);
    }

    public int[] getElementCorners(int eindex) throws NcException {
        if (eindex < 0) {
            return null;
        }
        int corner1 = this.centersArray_.get(0, eindex) - 1;
        int corner2 = this.centersArray_.get(1, eindex) - 1;
        int corner3 = this.centersArray_.get(2, eindex) - 1;
        int corner4 = this.centersArray_.get(3, eindex) - 1;
        return new int[]{corner1, corner2, corner3, corner4};
    }

    public int[] getCornerElems(int cindex) {
        return this.cornerElems_[cindex];
    }

    public double[][] getCellCornerLonLats(int col) {
        return null;
    }

    @Override
    public NcGridder getGridder() {
        return new NcGridderLonLatCubedSphereCAMSE();
    }

    public static boolean canGridVariable(NcVariable ncvar) {
        NcDataset ncd = ncvar.getDataset();
        VariableDS varDS = (VariableDS)ncvar.getObject();
        return NcArrayLonLatCubedSphereCAMSE.canGridVariable(ncd, varDS);
    }

    public static boolean canGridVariable(NcDataset ncd, VariableDS varDS) {
        String source = ncd.getNjStringAttribute("source");
        if (source == null || !source.equals("CAM")) {
            return false;
        }
        String caseStr = ncd.getNjStringAttribute("case");
        if (caseStr == null) {
            return false;
        }
        if (!(caseStr.contains("ne30") || caseStr.contains("ne60") || caseStr.contains("ne120"))) {
            return false;
        }
        Integer npInt = ncd.getNjIntegerAttribute("np");
        if (npInt == null || npInt != 4) {
            return false;
        }
        int ncol = NcArrayLonLatCubedSphereCAMSE.getNcol(varDS);
        if (ncol < 0) {
            return false;
        }
        VariableDS[] lonlatDS = NcArrayLonLatCubedSphereCAMSE.getLonLatVarsDS(ncd, varDS);
        if (lonlatDS == null) {
            return false;
        }
        VariableDS centersVarDS = NcArrayLonLatCubedSphereCAMSE.getCentersVarDS(ncd, varDS);
        return centersVarDS != null;
    }

    private static int getNcol(VariableDS varDS) {
        int ncolDimIndex = varDS.findDimensionIndex("ncol");
        if (ncolDimIndex < 0) {
            return -1;
        }
        Dimension ncolDim = varDS.getDimension(ncolDimIndex);
        int ncol = ncolDim.getLength();
        if (ncol != 48602 && ncol != 194402 && ncol != 777602) {
            return -1;
        }
        return ncol;
    }

    private static VariableDS[] getLonLatVarsDS(NcDataset ncd, VariableDS varDS) {
        int latrank;
        String fname = varDS.getFullName();
        String lonName = null;
        String latName = null;
        int slash = fname.lastIndexOf(47);
        if (slash > -1) {
            lonName = fname.substring(0, slash + 1) + "lon";
            latName = fname.substring(0, slash + 1) + "lat";
        } else {
            lonName = "lon";
            latName = "lat";
        }
        VariableDS lonVarDS = ncd.getNjVariable(lonName);
        VariableDS latVarDS = ncd.getNjVariable(latName);
        if (lonVarDS == null || latVarDS == null) {
            return null;
        }
        int lonrank = lonVarDS.getRank();
        if (lonrank != (latrank = latVarDS.getRank()) || lonrank != 1 || latrank != 1) {
            return null;
        }
        int[] lonshape = lonVarDS.getShape();
        int[] latshape = latVarDS.getShape();
        int ncol = NcArrayLonLatCubedSphereCAMSE.getNcol(varDS);
        if (lonshape[0] != latshape[0] || lonshape[0] != ncol) {
            return null;
        }
        String lonUnits = NcVarUtils.getUnitsString(lonVarDS);
        String latUnits = NcVarUtils.getUnitsString(latVarDS);
        if (!NcUnitUtils.isDegreesEast(lonUnits)) {
            return null;
        }
        if (!NcUnitUtils.isDegreesNorth(latUnits)) {
            return null;
        }
        return new VariableDS[]{lonVarDS, latVarDS};
    }

    private static VariableDS getCentersVarDS(NcDataset ncd, VariableDS varDS) {
        String fname = varDS.getFullName();
        int slash = fname.lastIndexOf(47);
        String centersVName = slash > -1 ? fname.substring(0, slash + 1) + "element_corners" : "element_corners";
        VariableDS centersDS = ncd.getNjVariable(centersVName);
        if (centersDS == null) {
            return null;
        }
        int rank = centersDS.getRank();
        if (rank != 2) {
            return null;
        }
        int[] shape = centersDS.getShape();
        if (shape[0] != 4) {
            return null;
        }
        int ncol = NcArrayLonLatCubedSphereCAMSE.getNcol(varDS);
        if (shape[1] != ncol - 2) {
            return null;
        }
        return centersDS;
    }

    @Override
    public int[] getEnclosingCell(double lon, double lat) {
        double mindist = Double.POSITIVE_INFINITY;
        double cosLat = Math.cos(lat * (Math.PI / 180));
        double sinLat = Math.sin(lat * (Math.PI / 180));
        int elemId = -1;
        for (int i = 0; i < this.numElements_; ++i) {
            PointLL ll = this.getElementLonLatAt(i);
            double lon1 = ll.getLon();
            double lat1 = ll.getLat();
            double dlon = lon1 - lon;
            double cosLat1 = Math.cos(lat1 * (Math.PI / 180));
            double sinLat1 = Math.sin(lat1 * (Math.PI / 180));
            double cosAngle = cosLat * cosLat1 * Math.cos(dlon * (Math.PI / 180)) + sinLat * sinLat1;
            double angle = Math.acos(cosAngle);
            if (angle == 0.0) {
                return new int[]{i};
            }
            if (!(angle < mindist)) continue;
            mindist = angle;
            elemId = i;
        }
        if (elemId < 0) {
            return null;
        }
        return new int[]{elemId};
    }

    @Override
    public void describeCell(StringBuilder sb, PrintfFormat valFormat, int ... index) {
        Objects.requireNonNull(index, "Cell index cannot be null.");
        int elemId = index[0];
        if (elemId < 0) {
            sb.append("Pt apparently outside data bounds");
            return;
        }
        double gv = this.valueAt(elemId);
        PointLL ll = this.getElementLonLatAt(elemId);
        double lon = ll.getLon();
        double lat = ll.getLat();
        sb.append("Grid pt ").append('[').append(elemId + 1).append("] at [").append(NcStringUtils.formatLongitude(lon)).append(' ').append(NcStringUtils.formatLatitude(lat)).append("], value = ").append(valFormat.sprintf((Object)gv));
        if (Double.isNaN(gv)) {
            return;
        }
        String unitsStr = this.getUnitsString();
        if (unitsStr != null && !unitsStr.isEmpty() && !unitsStr.equals("1")) {
            sb.append(' ').append(unitsStr);
        }
    }

    @Override
    public LonLatBounds getLonLatBounds() {
        return LonLatBounds.ENTIRE_GLOBE;
    }
}

