/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array.projected;

import gov.nasa.giss.data.nc.NcAltGridding;
import gov.nasa.giss.data.nc.NcAltGriddingVarType;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcVarType;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArrayLonLatProjected;
import gov.nasa.giss.data.nc.array.NcLonLatProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.sat.Geostationary;

public class NcArrayLonLatGeostationary
extends NcArrayLonLatProjected {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ProjectionImpl njProj_;

    public NcArrayLonLatGeostationary(NcVariable ncvar) throws NcException {
        super(ncvar, NcLonLatProjection.GEOSTATIONARY);
        this.initMe();
    }

    private final void initMe() {
        NcVarType vtype = this.ncvar_.getVarType();
        if (!(vtype instanceof NcAltGriddingVarType)) {
            throw new NcException("Variable is not on a projected grid.");
        }
        if (!((NcAltGriddingVarType)vtype).isGrid(NcAltGridding.GEOSTATIONARY)) {
            throw new NcException("Variable is not projected type geostationary.");
        }
        this.initUnidataProj();
    }

    private final void initUnidataProj() {
        VariableDS njvarDS = (VariableDS)this.ncvar_.getObject();
        List<CoordinateSystem> csList = njvarDS.getCoordinateSystems();
        if (csList.isEmpty()) {
            throw new NcException("No coordinate systems found.");
        }
        CoordinateSystem cs = csList.get(0);
        ProjectionImpl pj = cs.getProjection();
        LOGGER.trace("pj {}", (Object)pj);
        if (!(pj instanceof Geostationary)) {
            throw new NcException("CoordinateSystem returned " + pj.getClass().getSimpleName() + " instead of " + Geostationary.class.getSimpleName());
        }
        this.njProj_ = pj;
    }

    @Override
    public Point2D.Double transformLL2XY(double lon, double lat) {
        return NcArrayLonLatGeostationary.transformNjLL2XY(this.njProj_, lon, lat);
    }

    @Override
    public PointLL transformXY2LL(double x, double y) {
        return NcArrayLonLatGeostationary.transformNjXY2LL(this.njProj_, x, y);
    }
}

