/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array.projected;

import gov.nasa.giss.data.nc.NcAltGridding;
import gov.nasa.giss.data.nc.NcAltGriddingVarType;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcVarType;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArrayLonLat;
import gov.nasa.giss.data.nc.array.NcArrayLonLatProjected;
import gov.nasa.giss.data.nc.array.NcLonLatProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.LambertConformal;

public class NcArrayLonLatLambertConformalConic
extends NcArrayLonLatProjected {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final boolean USE_NJ_PROJ = false;
    private ProjectionImpl njProj_;
    private static final double PI_OVER_4 = 0.7853981633974483;
    private double phi1_ = 30.0;
    private double phi2_ = -30.0;
    private double termF_;
    private double termN_;
    private double oneOverN_;
    private double rho0_;

    public NcArrayLonLatLambertConformalConic(NcVariable ncvar) throws NcException {
        super(ncvar, NcLonLatProjection.LAMBERT_CONFORMAL);
        this.initMe();
    }

    private final void initMe() {
        NcVarType vtype = this.ncvar_.getVarType();
        if (!(vtype instanceof NcAltGriddingVarType)) {
            throw new NcException("Variable is not on a projected grid.");
        }
        if (!((NcAltGriddingVarType)vtype).isGrid(NcAltGridding.LAMBERT_CONFORMAL)) {
            throw new NcException("Variable is not projected type Lambert conformal conic.");
        }
        this.initGissProj();
    }

    private final void initUnidataProj() {
        VariableDS njvarDS = (VariableDS)this.ncvar_.getObject();
        List<CoordinateSystem> csList = njvarDS.getCoordinateSystems();
        if (csList == null || csList.isEmpty()) {
            throw new NcException("No coordinate systems found.");
        }
        CoordinateSystem cs = csList.get(0);
        ProjectionImpl pj = cs.getProjection();
        if (!(pj instanceof LambertConformal)) {
            throw new NcException("CoordinateSystem returned " + pj.getClass() + " instead of LambertConformal");
        }
        this.njProj_ = pj;
    }

    private final void initGissProj() {
        this.getGridMappingName();
        if (!this.mappingName_.equalsIgnoreCase("lambert_conformal_conic")) {
            LOGGER.trace("Found mapping name, but {}} is not {}", (Object)this.mappingName_, (Object)"lambert_conformal_conic");
            throw new NcException("Mapping name is not lambert_conformal_conic");
        }
        this.initCenter();
        this.initRadiusEastingAndNorthing();
        Attribute parallelsA = this.mappingVarDS_.findAttribute("standard_parallel");
        if (parallelsA == null) {
            throw new NcException("Coordinate transform variable is missing standard parallel(s)");
        }
        if (parallelsA.isArray()) {
            Array pararray = parallelsA.getValues();
            double[] parvalues = (double[])pararray.get1DJavaArray(DataType.DOUBLE);
            this.phi1_ = parvalues[0];
            this.phi2_ = parvalues[1];
        } else {
            this.phi2_ = this.phi1_ = parallelsA.getNumericValue().doubleValue();
        }
        double phiCRad = Math.toRadians(this.phiC_);
        double phi1Rad = Math.toRadians(this.phi1_);
        double phi2Rad = Math.toRadians(this.phi2_);
        double cosPhi1 = Math.cos(phi1Rad);
        double cosPhi2 = Math.cos(phi2Rad);
        double tanTermC = Math.tan(0.7853981633974483 + 0.5 * phiCRad);
        double tanTerm1 = Math.tan(0.7853981633974483 + 0.5 * phi1Rad);
        double tanTerm2 = Math.tan(0.7853981633974483 + 0.5 * phi2Rad);
        this.termN_ = this.phi1_ == this.phi2_ ? Math.sin(phi1Rad) : Math.log(cosPhi1 / cosPhi2) / Math.log(tanTerm2 / tanTerm1);
        this.oneOverN_ = 1.0 / this.termN_;
        this.termF_ = cosPhi1 * Math.pow(tanTerm1, this.termN_) * this.oneOverN_;
        this.rho0_ = this.termF_ / Math.pow(tanTermC, this.termN_);
    }

    @Override
    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (NcArrayLonLat.isBadLatitude(lat)) {
            return null;
        }
        if (lat < 90.0 && lat > -90.0) {
            double dlon = lon - this.lambdaC_;
            if (dlon > 180.0) {
                dlon -= 360.0;
            }
            if (dlon < -180.0) {
                dlon += 360.0;
            }
            double lambdaRad = Math.toRadians(dlon);
            double phiRad = Math.toRadians(lat);
            double rho = this.termF_ / Math.pow(Math.tan(0.7853981633974483 + 0.5 * phiRad), this.termN_);
            double thetaRad = this.termN_ * lambdaRad;
            double x = rho * Math.sin(thetaRad);
            double y = this.rho0_ - rho * Math.cos(thetaRad);
            return new Point2D.Double(x * this.radius_ + this.falseEasting_, y * this.radius_ + this.falseNorthing_);
        }
        if (lat == 90.0) {
            if (this.termN_ < 0.0) {
                return null;
            }
            return new Point2D.Double(0.0, this.rho0_ * this.radius_ + this.falseNorthing_);
        }
        if (this.termN_ > 0.0) {
            return null;
        }
        return new Point2D.Double(0.0, this.rho0_ * this.radius_ + this.falseNorthing_);
    }

    @Override
    public PointLL transformXY2LL(double x, double y) {
        double phiRad;
        double xOverR = (x - this.falseEasting_) * this.oneOverR_;
        double yOverR = (y - this.falseNorthing_) * this.oneOverR_;
        double rho0MinusYOverR = this.rho0_ - yOverR;
        double rho = Math.hypot(xOverR, rho0MinusYOverR);
        if (this.termN_ < 0.0) {
            rho = -rho;
        }
        if (Math.abs(phiRad = 2.0 * (Math.atan(Math.pow(this.termF_ / rho, this.oneOverN_)) - 0.7853981633974483)) > 1.5707963267948966) {
            return null;
        }
        double thetaRad = this.termN_ < 0.0 ? Math.atan2(-xOverR, -rho0MinusYOverR) : Math.atan2(xOverR, rho0MinusYOverR);
        double lambdaRad = thetaRad * this.oneOverN_;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        return new PointLL(this.lambdaC_ + Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
    }
}

