/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.gridder;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.array.NcArray1D;
import gov.nasa.giss.data.nc.gridder.NcAxisMethod;
import gov.nasa.giss.data.nc.gridder.NcGridder;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import ucar.units.Converter;
import ucar.units.Unit;

public class NcGridder1D
extends NcGridder {
    private double bound1_;
    private double bound2_;
    protected NcAxisMethod axisMethod_ = NcAxisMethod.SCALAR;
    protected Unit axisUcarUnits_;

    public void setAxisMethod(NcAxisMethod method) {
        this.axisMethod_ = method;
    }

    public void setAxisUcarUnits(Unit unit) {
        this.axisUcarUnits_ = unit;
    }

    protected Converter getAxisUnitsConverter(NcArray1D nca1D) {
        Unit ucarUnits = nca1D.getAxis().getUcarUnits();
        if (ucarUnits == null) {
            return null;
        }
        try {
            return ucarUnits.getConverterTo(this.axisUcarUnits_);
        }
        catch (Exception exc) {
            return null;
        }
    }

    public boolean setBounds(double[] bounds) {
        return this.setBounds(bounds[0], bounds[1]);
    }

    public boolean setBounds(double b1, double b2) {
        this.bound1_ = b1;
        this.bound2_ = b2;
        return true;
    }

    public Point2D.Double[] regridAsIs(NcArray a) {
        NcArray1D nca = (NcArray1D)a;
        Converter axisUnitsConverter = this.getAxisUnitsConverter(nca);
        boolean hasBad = nca.hasBadValues();
        NcAxis ax = nca.getAxis();
        double[] axvals = ax.getValues();
        ArrayList<Point2D.Double> clist = new ArrayList<Point2D.Double>(axvals.length);
        for (int i = 0; i < axvals.length; ++i) {
            double axvalP1;
            double axvalM1 = i > 0 ? axvals[i - 1] : Double.NaN;
            double axval = axvals[i];
            double d = axvalP1 = i < axvals.length - 1 ? axvals[i + 1] : Double.NaN;
            if (axisUnitsConverter != null) {
                if (!Double.isNaN(axvalM1)) {
                    axvalM1 = axisUnitsConverter.convert(axvalM1);
                }
                axval = axisUnitsConverter.convert(axval);
                if (!Double.isNaN(axvalP1)) {
                    axvalP1 = axisUnitsConverter.convert(axvalP1);
                }
            }
            if (axval < this.bound1_ && axval < this.bound2_ ? i > 0 && i < axvals.length - 1 && axvalM1 < this.bound1_ && axvalM1 < this.bound2_ && axvalP1 < this.bound1_ && axvalP1 < this.bound2_ : axvals[i] > this.bound1_ && axvals[i] > this.bound2_ && i > 0 && i < axvals.length - 1 && axvalM1 > this.bound1_ && axvalM1 > this.bound2_ && axvalP1 > this.bound1_ && axvalP1 > this.bound2_) continue;
            double val = nca.valueAt(i);
            if (hasBad && nca.isMissingOrInvalid(val)) {
                val = Double.NaN;
            }
            clist.add(new Point2D.Double(axval, nca.valueAt(i)));
        }
        return clist.toArray(new Point2D.Double[0]);
    }
}

