/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.gridder;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.data.nc.array.NcArrayLonLatProjected;
import gov.nasa.giss.data.nc.gridder.NcGridderLonLat;
import gov.nasa.giss.data.nc.gridder.NcGridderUtils;
import gov.nasa.giss.math.MathUtils;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NcGridderLonLatProjected
extends NcGridderLonLat {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private double lProjBound_;
    private double tProjBound_;
    private double xPxlPerProj_;
    private double yPxlPerProj_;
    private double[] pcolXX_;
    private double[] prowYY_;
    private int iigridWidth_;
    private int iigridHeight_;

    public NcGridderLonLatProjected() {
        this(100, 50);
    }

    public NcGridderLonLatProjected(Dimension size) {
        this(size.width, size.height);
    }

    public NcGridderLonLatProjected(int w, int h) {
        super(w, h);
    }

    @Override
    public void regridNoInterpolate(NcArray a, double[] target) {
        int j;
        NcArray2D nca = (NcArray2D)a;
        double[] bgrid = this.makeProjectedGrid((NcArrayLonLatProjected)nca);
        boolean hasBad = nca.hasBadValues();
        NcAxis xAxis = nca.getXAxis();
        NcAxis yAxis = nca.getYAxis();
        int numXs = xAxis.getLength();
        int numYs = yAxis.getLength();
        double[][] xBounds = xAxis.getBounds();
        double[][] yBounds = yAxis.getBounds();
        int[] srcRow = new int[this.iigridHeight_];
        int[] srcCol = new int[this.iigridWidth_];
        block0: for (j = 0; j < this.iigridHeight_; ++j) {
            srcRow[j] = -1;
            for (int jj = 0; jj < numYs; ++jj) {
                if (!(this.prowYY_[j] <= yBounds[jj][0] && this.prowYY_[j] > yBounds[jj][1]) && (!(this.prowYY_[j] >= yBounds[jj][0]) || !(this.prowYY_[j] < yBounds[jj][1]))) continue;
                srcRow[j] = jj;
                continue block0;
            }
        }
        block2: for (int i = 0; i < this.iigridWidth_; ++i) {
            srcCol[i] = -1;
            for (int ii = 0; ii < numXs; ++ii) {
                if (!(this.pcolXX_[i] >= xBounds[ii][0] && this.pcolXX_[i] < xBounds[ii][1]) && (!(this.pcolXX_[i] < xBounds[ii][0]) || !(this.pcolXX_[i] >= xBounds[ii][1]))) continue;
                srcCol[i] = ii;
                continue block2;
            }
        }
        for (j = 0; j < this.iigridHeight_; ++j) {
            if (srcRow[j] < 0) continue;
            for (int i = 0; i < this.iigridWidth_; ++i) {
                if (srcCol[i] < 0) continue;
                double value = nca.valueAt(srcCol[i], srcRow[j]);
                if (hasBad && nca.isMissingOrInvalid(value)) {
                    value = Double.NaN;
                }
                NcGridderUtils.setValue(bgrid, i, j, value, this.iigridWidth_, this.iigridHeight_);
            }
        }
        this.prepareGridAxes();
        this.transformProjectedGrid((NcArrayLonLatProjected)nca, bgrid, target);
    }

    @Override
    public void regridInterpolate(NcArray a, double[] target) {
        NcArray2D nca = (NcArray2D)a;
        double[] bgrid = this.makeProjectedGrid((NcArrayLonLatProjected)nca);
        boolean hasBad = nca.hasBadValues();
        NcAxis xAxis = nca.getXAxis();
        NcAxis yAxis = nca.getYAxis();
        double[] xValues = xAxis.getValues();
        double[] yValues = yAxis.getValues();
        double[][] xBounds = xAxis.getBounds();
        double[][] yBounds = yAxis.getBounds();
        int numYs = yValues.length;
        int numXs = xValues.length;
        int lastY = numYs - 1;
        int lastX = numXs - 1;
        int[] srcRow = new int[this.iigridHeight_];
        block0: for (int j = 0; j < this.iigridHeight_; ++j) {
            srcRow[j] = -1;
            for (int jj = 0; jj < lastY; ++jj) {
                if (!(this.prowYY_[j] >= yValues[jj] && this.prowYY_[j] < yValues[jj + 1]) && (!(this.prowYY_[j] <= yValues[jj]) || !(this.prowYY_[j] > yValues[jj + 1]))) continue;
                srcRow[j] = jj;
                continue block0;
            }
        }
        int[] srcCol = new int[this.iigridWidth_];
        block2: for (int i = 0; i < this.iigridWidth_; ++i) {
            srcCol[i] = -1;
            for (int ii = 0; ii < lastX; ++ii) {
                if (!(this.pcolXX_[i] >= xValues[ii] && this.pcolXX_[i] < xValues[ii + 1]) && (!(this.pcolXX_[i] <= xValues[ii]) || !(this.pcolXX_[i] > xValues[ii + 1]))) continue;
                srcCol[i] = ii;
                continue block2;
            }
        }
        for (int j = 0; j < this.iigridHeight_; ++j) {
            if (srcRow[j] == -1) continue;
            double yPct = (this.prowYY_[j] - yValues[srcRow[j]]) / (yValues[srcRow[j] + 1] - yValues[srcRow[j]]);
            for (int i = 0; i < this.iigridWidth_; ++i) {
                int leftCol = srcCol[i];
                if (leftCol == -1) continue;
                int rightCol = leftCol + 1 < numXs ? leftCol + 1 : 0;
                double leftLon = xValues[leftCol];
                double rightLon = xValues[rightCol];
                double xPct = (this.pcolXX_[i] - leftLon) / (rightLon - leftLon);
                double valTL = nca.valueAt(leftCol, srcRow[j]);
                double valTR = nca.valueAt(rightCol, srcRow[j]);
                double valBL = nca.valueAt(leftCol, srcRow[j] + 1);
                double valBR = nca.valueAt(rightCol, srcRow[j] + 1);
                if (hasBad) {
                    if (nca.isMissingOrInvalid(valTL)) {
                        valTL = Double.NaN;
                    }
                    if (nca.isMissingOrInvalid(valTR)) {
                        valTR = Double.NaN;
                    }
                    if (nca.isMissingOrInvalid(valBL)) {
                        valBL = Double.NaN;
                    }
                    if (nca.isMissingOrInvalid(valBR)) {
                        valBR = Double.NaN;
                    }
                }
                double value = NcGridderUtils.bilinearInterpolate(xPct, yPct, valTL, valTR, valBL, valBR);
                NcGridderUtils.setValue(bgrid, i, j, value, this.iigridWidth_, this.iigridHeight_);
            }
        }
        this.prepareGridAxes();
        this.transformProjectedGrid((NcArrayLonLatProjected)nca, bgrid, target);
    }

    private double[] makeProjectedGrid(NcArrayLonLatProjected nca) {
        double[] bounds = nca.getBounds();
        this.lProjBound_ = bounds[0];
        this.tProjBound_ = bounds[1];
        double rProjBound = bounds[2];
        double bProjBound = bounds[3];
        LOGGER.trace("TL {}, {} - BR {}, {}", this.tProjBound_, this.lProjBound_, bProjBound, rProjBound);
        double outWW = this.rBound_ - this.lBound_;
        LOGGER.trace("outWW {}", (Object)outWW);
        if (outWW < 45.0) {
            Point2D.Double tlPt = nca.transformLL2XY(this.lBound_, this.tBound_);
            Point2D.Double mlPt = nca.transformLL2XY(this.lBound_, 0.5 * (this.tBound_ + this.bBound_));
            Point2D.Double blPt = nca.transformLL2XY(this.lBound_, this.bBound_);
            Point2D.Double trPt = nca.transformLL2XY(this.rBound_, this.tBound_);
            Point2D.Double mrPt = nca.transformLL2XY(this.rBound_, 0.5 * (this.tBound_ + this.bBound_));
            Point2D.Double brPt = nca.transformLL2XY(this.rBound_, this.bBound_);
            double leftRotLon = MathUtils.min(tlPt.x, mlPt.x, blPt.x);
            double[] dArray = new double[]{trPt.x, mrPt.x, brPt.x};
            double rightRotLon = MathUtils.max(dArray);
            if (leftRotLon > rightRotLon) {
                leftRotLon -= 360.0;
            }
            if (leftRotLon > this.lProjBound_) {
                this.lProjBound_ = leftRotLon;
            }
            if (rightRotLon < rProjBound) {
                rProjBound = rightRotLon;
            }
            Point2D.Double tmPt = nca.transformLL2XY(0.5 * (this.lBound_ + this.rBound_), this.tBound_);
            double[] dArray2 = new double[]{tlPt.y, tmPt.y, trPt.y};
            double topRotLat = MathUtils.max(dArray2);
            if (topRotLat < this.tProjBound_ && this.tProjBound_ > bProjBound) {
                this.tProjBound_ = topRotLat;
            } else if (topRotLat < bProjBound && bProjBound > this.tProjBound_) {
                bProjBound = topRotLat;
            }
            Point2D.Double bmPt = nca.transformLL2XY(0.5 * (this.lBound_ + this.rBound_), this.bBound_);
            double bottomRotLat = MathUtils.min(blPt.y, bmPt.y, brPt.y);
            if (bottomRotLat > bProjBound && bProjBound < this.tProjBound_) {
                bProjBound = bottomRotLat;
            } else if (bottomRotLat > this.tProjBound_ && this.tProjBound_ < bProjBound) {
                this.tProjBound_ = bottomRotLat;
            }
        }
        this.iigridWidth_ = this.gridWidth_;
        this.iigridHeight_ = this.gridHeight_;
        int iisize = this.iigridWidth_ * this.iigridHeight_;
        double[] bgrid = new double[iisize];
        for (int i = 0; i < iisize; ++i) {
            bgrid[i] = Double.NaN;
        }
        this.pcolXX_ = new double[this.iigridWidth_];
        this.prowYY_ = new double[this.iigridHeight_];
        double projPerXPxl = (rProjBound - this.lProjBound_) / (double)this.iigridWidth_;
        double projPerYPxl = (bProjBound - this.tProjBound_) / (double)this.iigridHeight_;
        for (int i = 0; i < this.iigridWidth_; ++i) {
            this.pcolXX_[i] = this.lProjBound_ + ((double)i + 0.5) * projPerXPxl;
        }
        for (int j = 0; j < this.iigridHeight_; ++j) {
            this.prowYY_[j] = this.tProjBound_ + ((double)j + 0.5) * projPerYPxl;
        }
        this.xPxlPerProj_ = (double)this.iigridWidth_ / (rProjBound - this.lProjBound_);
        this.yPxlPerProj_ = (double)this.iigridHeight_ / (bProjBound - this.tProjBound_);
        return bgrid;
    }

    private final void transformProjectedGrid(NcArrayLonLatProjected anca, double[] fromArray, double[] toArray) {
        for (int row = 0; row < this.gridHeight_; ++row) {
            double rowLat = this.tBound_ + ((double)row + 0.5) * this.yDegPerPxl_;
            for (int col = 0; col < this.gridWidth_; ++col) {
                double colLon = this.lBound_ + ((double)col + 0.5) * this.xDegPerPxl_;
                Point2D.Double fromXY = anca.transformLL2XY(colLon, rowLat);
                if (fromXY == null) continue;
                double altCol = (fromXY.x - this.lProjBound_) * this.xPxlPerProj_ + 0.5;
                double altRow = (fromXY.y - this.tProjBound_) * this.yPxlPerProj_ + 0.5;
                if (altRow < 0.0 || altRow >= (double)this.iigridHeight_ || altCol < 0.0 || altCol >= (double)this.iigridWidth_) continue;
                int fromIndex = (int)altRow * this.iigridWidth_ + (int)altCol;
                int toIndex = row * this.gridWidth_ + col;
                toArray[toIndex] = fromArray[fromIndex];
            }
        }
    }
}

