/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics;

import java.awt.Color;

public class CMYKColor {
    float c_;
    float m_;
    float y_;
    float k_;
    boolean scale100_;

    public CMYKColor(float c, float m, float y, float k) {
        this.c_ = c;
        this.m_ = m;
        this.y_ = y;
        this.k_ = k;
        this.scale100_ = c > 1.0f || m > 1.0f || y > 1.0f || k > 1.0f;
    }

    public float getC() {
        return this.c_;
    }

    public float getM() {
        return this.m_;
    }

    public float getY() {
        return this.y_;
    }

    public float getK() {
        return this.k_;
    }

    public boolean isScale100() {
        return this.scale100_;
    }

    public Color toRGBColor() {
        if (this.scale100_) {
            float r1 = 1.0f - Math.min(1.0f, (this.c_ + this.k_) * 0.01f);
            float g1 = 1.0f - Math.min(1.0f, (this.m_ + this.k_) * 0.01f);
            float b1 = 1.0f - Math.min(1.0f, (this.y_ + this.k_) * 0.01f);
            return new Color(r1, g1, b1);
        }
        float r1 = 1.0f - Math.min(1.0f, this.c_ + this.k_);
        float g1 = 1.0f - Math.min(1.0f, this.m_ + this.k_);
        float b1 = 1.0f - Math.min(1.0f, this.y_ + this.k_);
        return new Color(r1, g1, b1);
    }
}

