/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics;

import java.awt.Color;
import java.lang.invoke.MethodHandles;
import java.text.ParseException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ColorUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static Color getXORColor(Color c) {
        return new Color(c.getRGB() ^ 0xFFFFFF);
    }

    public static String colorToString(Color c) {
        StringBuilder sb = new StringBuilder("");
        if (c.getAlpha() < 255) {
            sb.append("rgba(");
        } else {
            sb.append("rgb(");
        }
        sb.append(c.getRed()).append(',').append(c.getGreen()).append(',').append(c.getBlue());
        if (c.getAlpha() < 255) {
            sb.append(',').append(c.getAlpha());
        }
        sb.append(')');
        String result = sb.toString();
        if (result.equalsIgnoreCase("rgb(0,0,0)")) {
            return "black";
        }
        if (result.equalsIgnoreCase("rgb(255,255,255)")) {
            return "white";
        }
        if (result.equalsIgnoreCase("rgb(255,0,0)")) {
            return "red";
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Color parseColor(String s) throws ParseException {
        Objects.requireNonNull(s, "Color string cannot be null.");
        if (s.startsWith("java.awt.Color[")) {
            block44: {
                try {
                    s = s.replaceFirst(".*\\[", "");
                    s = s.replaceFirst("\\].*", "");
                }
                catch (Exception exc) {
                    if (!LOGGER.isDebugEnabled()) break block44;
                    exc.printStackTrace();
                }
            }
            try {
                String[] rgbx = s.split(",");
                if (rgbx.length < 3) {
                    return null;
                }
                int[] rgb = new int[3];
                for (int i = 0; i < 3; ++i) {
                    rgbx[i] = rgbx[i].replaceAll("\\D", "");
                    rgb[i] = Integer.parseInt(rgbx[i]);
                    rgb[i] = Math.max(rgb[i], 0);
                    rgb[i] = Math.min(rgb[i], 255);
                }
                return new Color(rgb[0], rgb[1], rgb[2]);
            }
            catch (Exception exc) {
                if (!LOGGER.isDebugEnabled()) throw new ParseException("Unrecognized color name string", 0);
                exc.printStackTrace();
                throw new ParseException("Unrecognized color name string", 0);
            }
        }
        if (s.startsWith("rgb(") && s.indexOf(37) > -1) {
            block45: {
                try {
                    s = s.replaceFirst(".*\\(", "");
                    s = s.replaceFirst("\\).*", "");
                }
                catch (Exception exc) {
                    if (!LOGGER.isDebugEnabled()) break block45;
                    exc.printStackTrace();
                }
            }
            try {
                String[] rgbx = s.split(",");
                if (rgbx.length < 3) {
                    return null;
                }
                float[] rgb = new float[3];
                for (int i = 0; i < 3; ++i) {
                    rgbx[i] = rgbx[i].replaceAll("\\%", "");
                    rgbx[i] = rgbx[i].replaceAll("\\D", "");
                    rgb[i] = Float.parseFloat(rgbx[i]);
                    rgb[i] = Math.max(rgb[i], 0.0f);
                    rgb[i] = Math.min(rgb[i], 255.0f);
                }
                return new Color(rgb[0], rgb[1], rgb[2]);
            }
            catch (Exception rgbx) {
                throw new ParseException("Unrecognized color name string", 0);
            }
        }
        if (s.startsWith("rgb(") || s.startsWith("rgba(")) {
            block46: {
                try {
                    s = s.replaceFirst(".*\\(", "");
                    s = s.replaceFirst("\\).*", "");
                }
                catch (Exception exc) {
                    if (!LOGGER.isDebugEnabled()) break block46;
                    exc.printStackTrace();
                }
            }
            try {
                String[] rgbx = s.split(",");
                if (rgbx.length < 3) {
                    return null;
                }
                int[] rgb = new int[rgbx.length];
                for (int i = 0; i < rgbx.length; ++i) {
                    rgbx[i] = rgbx[i].replaceAll("\\D", "");
                    rgb[i] = Integer.parseInt(rgbx[i]);
                    rgb[i] = Math.max(rgb[i], 0);
                    rgb[i] = Math.min(rgb[i], 255);
                }
                if (rgb.length != 4) return new Color(rgb[0], rgb[1], rgb[2]);
                return new Color(rgb[0], rgb[1], rgb[2], rgb[3]);
            }
            catch (Exception rgbx) {
                throw new ParseException("Unrecognized color name string", 0);
            }
        }
        if (s.charAt(0) == '#') {
            if ((s = s.substring(1)).length() == 3) {
                char c1 = s.charAt(0);
                char c2 = s.charAt(1);
                char c3 = s.charAt(2);
                return Color.decode("0x" + c1 + c1 + c2 + c2 + c3 + c3);
            }
            if (s.length() != 6) throw new ParseException("Unrecognized color name string", 0);
            return Color.decode("0x" + s);
        }
        if (s.equalsIgnoreCase("black")) {
            return Color.BLACK;
        }
        if (s.equalsIgnoreCase("silver")) {
            return Color.LIGHT_GRAY;
        }
        if (s.equalsIgnoreCase("gray")) {
            return Color.GRAY;
        }
        if (s.equalsIgnoreCase("white")) {
            return Color.WHITE;
        }
        if (s.equalsIgnoreCase("maroon")) {
            return Color.decode("0x800000");
        }
        if (s.equalsIgnoreCase("red")) {
            return Color.RED;
        }
        if (s.equalsIgnoreCase("purple")) {
            return Color.decode("0x800080");
        }
        if (s.equalsIgnoreCase("fuchsia")) {
            return Color.MAGENTA;
        }
        if (s.equalsIgnoreCase("green")) {
            return Color.decode("0x008000");
        }
        if (s.equalsIgnoreCase("lime")) {
            return Color.GREEN;
        }
        if (s.equalsIgnoreCase("olive")) {
            return Color.decode("0x808000");
        }
        if (s.equalsIgnoreCase("yellow")) {
            return Color.YELLOW;
        }
        if (s.equalsIgnoreCase("navy")) {
            return Color.decode("0x000080");
        }
        if (s.equalsIgnoreCase("blue")) {
            return Color.BLUE;
        }
        if (s.equalsIgnoreCase("teal")) {
            return Color.decode("0x008080");
        }
        if (s.equalsIgnoreCase("aqua")) {
            return Color.decode("0x00ffff");
        }
        if (s.equalsIgnoreCase("cyan")) {
            return Color.CYAN;
        }
        if (s.equalsIgnoreCase("darkgray") || s.equalsIgnoreCase("dark_gray")) {
            return Color.DARK_GRAY;
        }
        if (s.equalsIgnoreCase("lightgray") || s.equalsIgnoreCase("light_gray")) {
            return Color.LIGHT_GRAY;
        }
        if (s.equalsIgnoreCase("magenta")) {
            return Color.MAGENTA;
        }
        if (s.equalsIgnoreCase("orange")) {
            return Color.ORANGE;
        }
        if (!s.equalsIgnoreCase("pink")) throw new ParseException("Unrecognized color name string", 0);
        return Color.PINK;
    }

    private ColorUtils() {
    }
}

