/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.io;

import com.centerkey.utils.BareBonesBrowserLaunch;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String SEPARATOR_PROPNAME = "file.separator";
    private static final String USERHOME_PROPNAME = "user.home";
    private static final String DOT = ".";
    private static final String GISS_JAVA_DIRNAME = ".gissjava";
    private static File cacheDir_;
    private static File supportDir_;
    private static File logsDir_;

    public static String extractFnameRoot(File f) {
        Objects.requireNonNull(f, "File cannot be null");
        return FileUtils.extractFnameRoot(f.getName());
    }

    public static String extractFnameRoot(String fname) {
        if (fname == null || fname.isEmpty()) {
            return null;
        }
        int lastDot = fname.lastIndexOf(DOT);
        if (lastDot < 0) {
            return fname;
        }
        if (lastDot == 0) {
            return null;
        }
        return fname.substring(0, lastDot);
    }

    public static String extractFnameExt(File f) {
        Objects.requireNonNull(f, "File cannot be null");
        return FileUtils.extractFnameExt(f.getName());
    }

    public static String extractFnameExt(String fname) {
        if (fname == null || fname.isEmpty()) {
            return null;
        }
        int lastDot = fname.lastIndexOf(DOT);
        if (lastDot < 0) {
            return null;
        }
        return fname.substring(lastDot + 1);
    }

    public static boolean deleteRecursive(File path) throws FileNotFoundException {
        if (!path.exists()) {
            throw new FileNotFoundException(path.getAbsolutePath());
        }
        boolean success = true;
        if (path.isDirectory()) {
            for (File f : path.listFiles()) {
                success = success && FileUtils.deleteRecursive(f);
            }
        }
        return success && path.delete();
    }

    public static boolean deleteDirectoryContents(File path) throws FileNotFoundException {
        if (path == null || !path.isDirectory()) {
            throw new IllegalArgumentException("Not a directory");
        }
        if (!path.exists()) {
            throw new FileNotFoundException(path.getAbsolutePath());
        }
        boolean success = true;
        if (path.isDirectory()) {
            for (File f : path.listFiles()) {
                success = success && FileUtils.deleteRecursive(f);
            }
        }
        return success;
    }

    public static File getUserCachesDirectory() {
        if (cacheDir_ == null) {
            String sep = System.getProperty(SEPARATOR_PROPNAME);
            String homePath = System.getProperty(USERHOME_PROPNAME);
            StringBuilder sb = new StringBuilder("");
            if (PlatformUtils.isMacintosh()) {
                String ppath = System.getProperty("CachesDirectory");
                if (ppath != null && ppath.startsWith(homePath)) {
                    sb.append(ppath);
                } else {
                    sb.append(homePath).append(sep).append("Library").append(sep).append("Caches");
                }
            } else {
                sb.append(homePath).append(sep).append(GISS_JAVA_DIRNAME).append(sep).append("cache");
            }
            String dirpath = sb.toString();
            try {
                cacheDir_ = new File(dirpath);
            }
            catch (Exception exc) {
                LOGGER.warn("Could not create File object for application cache dir {}", (Object)dirpath);
            }
        }
        return cacheDir_;
    }

    public static File getAppCacheDirectory(String appName, String qualifiedName) {
        try {
            String dirName = PlatformUtils.isMacintosh() ? qualifiedName : appName;
            return new File(FileUtils.getUserCachesDirectory(), dirName);
        }
        catch (Exception exc) {
            LOGGER.warn("Could not create File object for application cache directory.");
            return null;
        }
    }

    public static File getGISSAppSupportDirectory() {
        if (supportDir_ == null) {
            String sep = System.getProperty(SEPARATOR_PROPNAME);
            String homePath = System.getProperty(USERHOME_PROPNAME);
            StringBuilder sb = new StringBuilder("");
            if (PlatformUtils.isMacintosh()) {
                String ppath = System.getProperty("ApplicationSupportDirectory");
                if (ppath != null && ppath.startsWith(homePath)) {
                    sb.append(ppath);
                } else {
                    sb.append(homePath).append(sep).append("Library").append(sep).append("Application Support");
                }
                sb.append(sep).append("GISS");
            } else {
                sb.append(homePath).append(sep).append(GISS_JAVA_DIRNAME);
            }
            String dirpath = sb.toString();
            try {
                supportDir_ = new File(dirpath);
            }
            catch (Exception exc) {
                LOGGER.warn("Could not create File object for application support dir {}", (Object)dirpath);
            }
        }
        return supportDir_;
    }

    public static File getGISSAppSupportSubdirectory(String subdirName) {
        try {
            File gissSupportDir = FileUtils.getGISSAppSupportDirectory();
            File subdir = new File(gissSupportDir, subdirName);
            return subdir;
        }
        catch (Exception exc) {
            LOGGER.warn("Could not create File object for {} support directory", (Object)subdirName);
            return null;
        }
    }

    public static File getGISSLogsDirectory() {
        if (logsDir_ == null) {
            String sep = System.getProperty(SEPARATOR_PROPNAME);
            String homePath = System.getProperty(USERHOME_PROPNAME);
            StringBuilder sb = new StringBuilder("");
            if (PlatformUtils.isMacintosh()) {
                String ppath = System.getProperty("LibraryDirectory");
                if (ppath != null && ppath.startsWith(homePath)) {
                    sb.append(ppath).append(sep);
                } else {
                    sb.append(homePath).append(sep).append("Library");
                }
                sb.append("Logs").append(sep).append("GISS");
            } else {
                sb.append(homePath).append(sep).append(GISS_JAVA_DIRNAME).append(sep).append("logs");
            }
            String dirpath = sb.toString();
            try {
                logsDir_ = new File(dirpath);
            }
            catch (Exception exc) {
                LOGGER.warn("Could not create File object for logging dir {}", (Object)dirpath);
            }
        }
        return logsDir_;
    }

    public static Object convertStringToAddress(String s) throws MalformedURLException {
        Objects.requireNonNull(s, "Address  string cannot be null.");
        if (s.startsWith("http:") || s.startsWith("https:") || s.startsWith("ftp:")) {
            return new URL(s);
        }
        String ss = s.replaceFirst("file:", "");
        if (ss.charAt(0) == '~') {
            String homeDir = System.getProperty(USERHOME_PROPNAME);
            ss = homeDir + ss.substring(1);
        }
        return new File(ss);
    }

    public static List<File> getTransferredFileList(Transferable t) {
        try {
            List flist = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
            return flist;
        }
        catch (IOException exc) {
            LOGGER.warn("IOException getting transferred file list.");
        }
        catch (UnsupportedFlavorException exc) {
            LOGGER.warn("UnsupportedFlavorException getting transferred file list.");
        }
        return null;
    }

    public static void showFileError(Component parent, String fname, Exception exc) {
        if (exc == null) {
            FileUtils.showFileError(parent, fname, "");
        } else {
            FileUtils.showFileError(parent, fname, exc.toString());
        }
    }

    public static void showFileError(Component parent, String fname, String message) {
        int colon;
        String message2 = null;
        message2 = message == null ? "" : ((colon = message.indexOf(": ")) > -1 ? message.substring(colon + 2) : message);
        GuiUtils.showSlowMessage(parent, "File Error", "There was an error opening the file '" + fname + "':\n" + message2);
    }

    public static void openBrowserURL(String url) throws IOException, URISyntaxException {
        if (Desktop.isDesktopSupported()) {
            Desktop.getDesktop().browse(new URI(url));
        } else {
            BareBonesBrowserLaunch.openURL(url);
        }
    }

    public static void openMailtoURL(String mailtoURL) throws IOException, URISyntaxException {
        if (Desktop.isDesktopSupported()) {
            Desktop.getDesktop().mail(new URI(mailtoURL));
        } else {
            BareBonesBrowserLaunch.openURL(mailtoURL);
        }
    }

    private FileUtils() {
    }
}

