/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map;

import gov.nasa.giss.map.SymbolID;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;

public final class SymbolFactory {
    public static final double SQRT3_OVER_2 = 0.8660254037844386;
    private static HashMap<String, Path2D.Float> symbolHash_ = new HashMap();

    private SymbolFactory() {
    }

    public static Path2D.Float getSymbol(SymbolID id) {
        return SymbolFactory.getSymbol(id, 6.0f);
    }

    public static Path2D.Float getSymbol(SymbolID id, float fsize) {
        if (id == null || id == SymbolID.NONE) {
            return null;
        }
        String key = id + "-" + fsize;
        Path2D.Float path = symbolHash_.get(key);
        if (path != null) {
            return path;
        }
        path = new Path2D.Float();
        switch (id) {
            case DOT: {
                Ellipse2D.Float s = new Ellipse2D.Float(0.0f, 0.0f, 0.25f * fsize, 0.25f * fsize);
                path.append(s, false);
                break;
            }
            case CROSS: {
                path.moveTo(0.4f * fsize, 0.0f);
                path.lineTo(0.4f * fsize, 0.8f * fsize);
                path.moveTo(0.0f, 0.4f * fsize);
                path.lineTo(0.8f * fsize, 0.4f * fsize);
                break;
            }
            case SALTIRE: {
                path.moveTo(0.0f, 0.0f);
                path.lineTo(0.8f * fsize, 0.8f * fsize);
                path.moveTo(0.0f, 0.8f * fsize);
                path.lineTo(0.8f * fsize, 0.0f);
                break;
            }
            case ASTERISK: {
                path.moveTo(0.5f * fsize, 0.0f);
                path.lineTo(0.5f * fsize, fsize);
                path.moveTo(0.0669872981077807 * (double)fsize, 0.25 * (double)fsize);
                path.lineTo(0.9330127018922193 * (double)fsize, 0.75 * (double)fsize);
                path.moveTo(0.0669872981077807 * (double)fsize, 0.75 * (double)fsize);
                path.lineTo(0.9330127018922193 * (double)fsize, 0.25 * (double)fsize);
                break;
            }
            case ASTERISK8: {
                path.moveTo(0.5f * fsize, 0.0f);
                path.lineTo(0.5f * fsize, fsize);
                path.moveTo(0.0f, 0.5f * fsize);
                path.lineTo(fsize, 0.5f * fsize);
                path.moveTo(0.1464466094067262 * (double)fsize, 0.1464466094067262 * (double)fsize);
                path.lineTo(0.8535533905932737 * (double)fsize, 0.8535533905932737 * (double)fsize);
                path.moveTo(0.1464466094067262 * (double)fsize, 0.8535533905932737 * (double)fsize);
                path.lineTo(0.8535533905932737 * (double)fsize, 0.1464466094067262 * (double)fsize);
                break;
            }
            case CIRCLE: {
                path.append(new Ellipse2D.Float(0.0f, 0.0f, fsize, fsize), false);
                break;
            }
            case SQUARE: {
                path.append(new Rectangle2D.Float(0.0f, 0.0f, fsize, fsize), false);
                break;
            }
            case TRIANGLE: {
                path.moveTo(0.4330125f * fsize, 0.0f);
                path.lineTo(fsize, 0.866025f * fsize);
                path.lineTo(0.0f, 0.866025f * fsize);
                path.closePath();
                break;
            }
            case INV_TRIANGLE: {
                path.moveTo(0.0f, 0.0f);
                path.lineTo(fsize, 0.0f);
                path.lineTo(0.43301275f * fsize, 0.866025f * fsize);
                path.closePath();
                break;
            }
            case DIAMOND: {
                path.moveTo(0.4f * fsize, 0.0f);
                path.lineTo(0.8f * fsize, 0.5f * fsize);
                path.lineTo(0.4f * fsize, fsize);
                path.lineTo(0.0f, 0.5f * fsize);
                path.closePath();
                break;
            }
            case PENTAGON: {
                SymbolFactory.createPolygon(path, 5, 0.6f * fsize);
                break;
            }
            case HEXAGON: {
                SymbolFactory.createPolygon(path, 6, 0.6f * fsize);
                break;
            }
            case HEPTAGON: {
                SymbolFactory.createPolygon(path, 7, 0.6f * fsize);
                break;
            }
            case OCTAGON: {
                SymbolFactory.createPolygon(path, 8, 0.6f * fsize);
                break;
            }
            case STAR: {
                SymbolFactory.createStar(path, 5, 0.6f * fsize, false);
                break;
            }
            case INV_STAR: {
                SymbolFactory.createStar(path, 5, 0.6f * fsize, true);
                break;
            }
            case STAR6: {
                SymbolFactory.createStar(path, 6, 0.6f * fsize, false);
                break;
            }
            case STAR7: {
                SymbolFactory.createStar(path, 7, 0.6f * fsize, false);
                break;
            }
            case STAR8: {
                SymbolFactory.createStar(path, 8, 0.6f * fsize, false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown symbol ID");
            }
        }
        if (path != null) {
            symbolHash_.put(key, path);
        }
        return path;
    }

    private static Path2D.Float createPolygon(Path2D.Float path, int numpoints, float radius) {
        double addAngle = Math.PI * 2 / (double)numpoints;
        double angle = -1.5707963267948966;
        path.moveTo((double)radius * Math.cos(angle), (double)radius * Math.sin(angle));
        for (int i = 0; i < numpoints; ++i) {
            if (i > 0) {
                path.lineTo((float)((double)radius * Math.cos(angle)), (float)((double)radius * Math.sin(angle)));
            }
            angle += addAngle;
        }
        path.closePath();
        return path;
    }

    private static Path2D.Float createStar(Path2D.Float path, int numpoints, float radius, boolean inverted) {
        int n = numpoints;
        int m = (numpoints - 1) / 2;
        int mm1 = m - 1;
        float innerR = radius * (float)(Math.cos((double)m * Math.PI / (double)n) / Math.cos((double)mm1 * Math.PI / (double)n));
        double addAngle = Math.PI * 2 / (double)numpoints;
        double angle = -1.5707963267948966;
        if (inverted) {
            angle += Math.PI;
        }
        double innerAngle = angle + Math.PI / (double)numpoints;
        path.moveTo((double)radius * Math.cos(angle), (double)radius * Math.sin(angle));
        for (int i = 0; i < numpoints; ++i) {
            if (i > 0) {
                path.lineTo((float)((double)radius * Math.cos(angle)), (float)((double)radius * Math.sin(angle)));
            }
            path.lineTo((float)((double)innerR * Math.cos(innerAngle)), (float)((double)innerR * Math.sin(innerAngle)));
            angle += addAngle;
            innerAngle += addAngle;
        }
        path.closePath();
        return path;
    }
}

