/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.gfx;

import gov.nasa.giss.util.DescribedItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum StrokeStyle implements DescribedItem
{
    NONE("None", null),
    SOLID("Solid", 1.0f),
    LONGDASHES("Long Dashes", 10.0f, 4.0f),
    SHORTDASHES("Short Dashes", 5.0f, 3.0f),
    MIXEDDASHES("Mixed Dashes", 10.0f, 3.0f, 5.0f, 3.0f),
    DOTS("Dots", 2.0f, 2.5f),
    DOTDASH("Dot-Dash", 5.0f, 2.5f, 2.0f, 2.5f);

    private static final Logger LOGGER;
    private final String description_;
    private final float[] pattern_;

    private StrokeStyle(String description, float ... pattern) {
        this.description_ = description;
        this.pattern_ = pattern;
    }

    @Override
    public String getDescription() {
        return this.description_;
    }

    public String toString() {
        return this.description_;
    }

    public float[] getPattern() {
        if (this.pattern_ == null) {
            return null;
        }
        float[] target = new float[this.pattern_.length];
        System.arraycopy(this.pattern_, 0, target, 0, this.pattern_.length);
        return target;
    }

    public float[] getScaledPattern(float scaling) {
        float[] target = this.getPattern();
        if (target == null) {
            return null;
        }
        for (int i = 0; i < target.length; ++i) {
            target[i] = scaling * target[i];
        }
        return target;
    }

    public static StrokeStyle matching(String s) {
        for (StrokeStyle item : StrokeStyle.values()) {
            if (!item.matches(s)) continue;
            return item;
        }
        LOGGER.debug("No match; returning NONE");
        return NONE;
    }

    @Override
    public boolean matches(String text) {
        return this.name().equalsIgnoreCase(text) || this.description_.equalsIgnoreCase(text);
    }

    static {
        LOGGER = LoggerFactory.getLogger(StrokeStyle.class);
    }
}

