/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.ProjectionUtils;
import gov.nasa.giss.math.Elliptic;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class AdamsWorldInASquare2
extends AbstractProjection {
    public static final String PROJECTION_NAME = "Adams World in a Square II";
    public static final int PROPERTIES = 4096;
    private static final double MODULUS = 0.7071067811865476;
    private static final double MODULUS2 = 0.5000000000000001;
    private static final double CAP_K = 1.854074677301372;
    private static final double SQRT2_TIMES_K = 2.62205755429212;
    private static final double WIDTH_FACTOR = 2.62205755429212;
    private static final double HEIGHT_FACTOR = 2.62205755429212;
    private double sqrt2timesKRS_;

    public AdamsWorldInASquare2(int width, int height) {
        this(width, height, 0, 0);
    }

    public AdamsWorldInASquare2(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public AdamsWorldInASquare2(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4096, width, height, xmargin, ymargin, 2.62205755429212, 2.62205755429212);
        this.finishScaling();
    }

    @Override
    protected void finishScaling() {
        this.sqrt2timesKRS_ = 2.62205755429212 * this.rS_;
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        if (lat > 89.99999) {
            return new Point2D.Double(this.outCenterX_, (double)this.outCenterY_ - this.sqrt2timesKRS_);
        }
        if (lat < -89.99999) {
            return new Point2D.Double(this.outCenterX_, (double)this.outCenterY_ + this.sqrt2timesKRS_);
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double absLambdaRad = Math.abs(lambdaRad);
        double sinHalfLambda = Math.sin(0.5 * absLambdaRad);
        double phiRad = Math.toRadians(lat);
        double absPhiRad = Math.abs(phiRad);
        double sinPhiP = Math.tan(0.5 * absPhiRad);
        double cosPhiP = Math.sqrt(1.0 - sinPhiP * sinPhiP);
        double cosA = cosPhiP * sinHalfLambda;
        double cosB = sinPhiP;
        double sinA = Math.sqrt(1.0 - cosA * cosA);
        double sinB = Math.sqrt(1.0 - cosB * cosB);
        double cosAcosB = cosA * cosB;
        double sinAsinB = sinA * sinB;
        double sinM = Math.sqrt(1.0 + cosAcosB - sinAsinB);
        double sinN = Math.sqrt(1.0 - cosAcosB - sinAsinB);
        double mmm = Math.asin(sinM);
        double nnn = Math.asin(sinN);
        if (sinPhiP + cosA < 0.0) {
            mmm = -mmm;
        }
        if (sinPhiP - cosA < 0.0) {
            nnn = -nnn;
        }
        double x = Elliptic.ellipticF(mmm, 0.5000000000000001);
        double y = Elliptic.ellipticF(nnn, 0.5000000000000001);
        double xx = 0.7071067811865476 * (x - y);
        double yy = 0.7071067811865476 * (x + y);
        if (lambdaRad < 0.0) {
            xx = -xx;
        }
        if (phiRad < 0.0) {
            yy = -yy;
        }
        x = (double)this.outCenterX_ + xx * this.rS_;
        y = (double)this.outCenterY_ - yy * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double yOverRS;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) + Math.abs(y) > this.sqrt2timesKRS_) {
            return null;
        }
        double xOverRS = Math.abs(x) * this.invRS_;
        double[] absLL = this.transformAbsXYrs2LL(xOverRS, yOverRS = Math.abs(y) * this.invRS_);
        if (absLL == null) {
            return null;
        }
        double lambda = absLL[0];
        double phi = absLL[1];
        if (y < 0.0) {
            phi = -phi;
        }
        if (x < 0.0) {
            lambda = -lambda;
        }
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        AdamsWorldInASquare2 adamsWorldInASquare2 = this;
        synchronized (adamsWorldInASquare2) {
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double x;
                double xOverRS;
                double[] absLL;
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                for (int ix = 0; ix < this.dxMax_ && iy + ix <= this.dxMax_ && (absLL = this.transformAbsXYrs2LL(xOverRS = (x = (double)ix + 0.5) * this.invRS_, yOverRS)) != null; ++ix) {
                    this.set4SymmetricPoints(ix, iy, absLL[0], absLL[1]);
                }
            }
        }
    }

    private double[] transformAbsXYrs2LL(double x, double y) {
        double cosB;
        double xx = 0.7071067811865476 * (x + y);
        double yy = 0.7071067811865476 * (-x + y);
        double[] jacobiM = Elliptic.jacobiSnCnDn(xx, 0.5000000000000001);
        double[] jacobiN = Elliptic.jacobiSnCnDn(yy, 0.5000000000000001);
        double sinM = jacobiM[0];
        double sinN = jacobiN[0];
        double sinSqM = sinM * sinM;
        double sinSqN = sinN * sinN;
        double sinAsinB = -0.5 * (sinSqM + sinSqN - 2.0);
        double cosAcosB = 0.5 * (sinSqM - sinSqN);
        double cosAplusB = cosAcosB - sinAsinB;
        double cosAminusB = cosAcosB + sinAsinB;
        double aPlusB = Math.acos(cosAplusB);
        double aMinusB = y > x ? Math.acos(cosAminusB) : -Math.acos(cosAminusB);
        double a = 0.5 * (aPlusB + aMinusB);
        double b = 0.5 * (aPlusB - aMinusB);
        double cosA = Math.cos(a);
        double sinPhiP = cosB = Math.cos(b);
        double phiPRad = Math.asin(sinPhiP);
        double cosPhiP = Math.cos(phiPRad);
        double phiRad = 2.0 * Math.atan(sinPhiP);
        double sinHalfLambda = cosA / cosPhiP;
        double lambdaRad = 2.0 * Math.asin(sinHalfLambda);
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new double[]{lambda, phi};
    }

    protected void set4SymmetricPoints(int ix, int iy, double lambda, double phi) {
        int col = this.outCenterX_ + ix;
        int colF = this.outCenterX_ - 1 - ix;
        int row = this.outCenterY_ - 1 - iy;
        int rowF = this.outCenterY_ + iy;
        if (row < 0 || row >= this.outHeight_ || rowF < 0 || rowF >= this.outHeight_ || col < 0 || col >= this.outWidth_ || colF < 0 || colF >= this.outWidth_) {
            return;
        }
        int indexTR = row * this.outWidth_ + col;
        int indexTL = row * this.outWidth_ + colF;
        int indexBR = rowF * this.outWidth_ + col;
        int indexBL = rowF * this.outWidth_ + colF;
        this.invArrayLon_[indexTR] = MapUtils.normalize360(this.lambdaC_ + lambda);
        this.invArrayLon_[indexTL] = MapUtils.normalize360(this.lambdaC_ - lambda);
        this.invArrayLon_[indexBR] = this.invArrayLon_[indexTR];
        this.invArrayLon_[indexBL] = this.invArrayLon_[indexTL];
        this.invArrayLat_[indexTR] = phi;
        this.invArrayLat_[indexTL] = phi;
        this.invArrayLat_[indexBR] = -phi;
        this.invArrayLat_[indexBL] = -phi;
        int srcY = this.getSrcPixelY(phi);
        int srcYF = this.getSrcPixelY(-phi);
        int srcX = this.getSrcPixelX(this.lambdaC_ + lambda);
        int srcXF = this.getSrcPixelX(this.lambdaC_ - lambda);
        if (srcY > -1) {
            if (srcX > -1) {
                this.invArray_[indexTR] = srcY * this.srcWidth_ + srcX;
            }
            if (srcXF > -1) {
                this.invArray_[indexTL] = srcY * this.srcWidth_ + srcXF;
            }
        }
        if (srcYF > -1) {
            if (srcX > -1) {
                this.invArray_[indexBR] = srcYF * this.srcWidth_ + srcX;
            }
            if (srcXF > -1) {
                this.invArray_[indexBL] = srcYF * this.srcWidth_ + srcXF;
            }
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        Stroke oldstroke = g2d.getStroke();
        g2d.setStroke(ProjectionUtils.getSquareMiterStroke(oldstroke));
        double dd = this.sqrt2timesKRS_;
        Path2D.Double path = new Path2D.Double();
        path.moveTo(this.outCenterX_, (double)this.outCenterY_ - dd);
        path.lineTo((double)this.outCenterX_ + dd, this.outCenterY_);
        path.lineTo(this.outCenterX_, (double)this.outCenterY_ + dd);
        path.lineTo((double)this.outCenterX_ - dd, this.outCenterY_);
        path.closePath();
        g2d.draw(path);
        g2d.setStroke(oldstroke);
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        if (Math.abs(lat) < 1.0E-5) {
            double ll = (double)this.outCenterX_ - this.sqrt2timesKRS_;
            double rr = (double)this.outCenterX_ + this.sqrt2timesKRS_;
            GraphicUtils.drawLine(g2d, ll, this.outCenterY_, rr, this.outCenterY_);
        } else {
            super.drawParallel(g2d, lat, label);
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        double absLambda = Math.abs(MapUtils.normalizeMP180(lon - this.lambdaC_));
        if (absLambda > 179.99999) {
            return;
        }
        if (absLambda < 1.0E-5) {
            double tt = (double)this.outCenterY_ - this.sqrt2timesKRS_;
            double bb = (double)this.outCenterY_ + this.sqrt2timesKRS_;
            GraphicUtils.drawLine(g2d, this.outCenterX_, tt, this.outCenterX_, bb);
        } else {
            Bezier bcurve = this.makeMeridianBezier(lon);
            if (bcurve != null) {
                bcurve.draw(g2d);
            }
        }
    }

    private Bezier makeMeridianBezier(double lon) {
        ArrayList<Point2D.Double> ptlist = new ArrayList<Point2D.Double>(240);
        double lat = -90.0;
        while (lat <= 90.0) {
            double absLat;
            Point2D.Double dot = this.transformLL2XY(lon, lat);
            if (dot != null) {
                ptlist.add(new Point2D.Double(dot.x, dot.y));
            }
            if ((absLat = Math.abs(lat)) >= 89.0) {
                lat += 0.1;
                continue;
            }
            if (absLat >= 85.0) {
                lat += 0.25;
                continue;
            }
            lat += 0.5;
        }
        return new Bezier(false, ptlist);
    }
}

