/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.ConcavePoleProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class CantersPolyconicW13
extends ConcavePoleProjection {
    public static final String PROJECTION_NAME = "Canters Polyconic W13";
    public static final int PROPERTIES = 32;
    private static final double C2 = 0.8478;
    private static final double C9 = -0.1702;
    private static final double C18 = -0.0062;
    private static final double C20 = 0.0036;
    private static final double C3P = 0.9964;
    private static final double C8P = 0.0313;
    private static final double C17P = 9.0E-4;
    private static final double C19P = -0.01;
    private static final double WIDTH_FACTOR = CantersPolyconicW13.equation17(Math.PI, 0.0);
    private static final double HEIGHT_FACTOR = CantersPolyconicW13.equation18(Math.PI, 1.5707963267948966);

    public CantersPolyconicW13(int width, int height) {
        this(width, height, 0, 0);
    }

    public CantersPolyconicW13(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public CantersPolyconicW13(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 32, width, height, xmargin, ymargin, WIDTH_FACTOR, HEIGHT_FACTOR);
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double x = CantersPolyconicW13.equation17(lambdaRad, phiRad);
        double y = CantersPolyconicW13.equation18(lambdaRad, phiRad);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double absX = Math.abs(x);
        double absY = Math.abs(y);
        double lambdaRad0 = 2.5132741228718345;
        double phiRad0 = absY < 1.5651414600184348 * this.rS_ ? absY * this.invRS_ / 0.9964 : Math.toRadians(89.0);
        double[] llRad = this.iterateXY2LL(absX, absY, 2.5132741228718345, phiRad0);
        if (llRad == null) {
            return null;
        }
        double lambda = Math.toDegrees(llRad[0]);
        double phi = Math.toDegrees(llRad[1]);
        if (x < 0.0) {
            lambda = -lambda;
        }
        if (y < 0.0) {
            phi = -phi;
        }
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        CantersPolyconicW13 cantersPolyconicW13 = this;
        synchronized (cantersPolyconicW13) {
            double yy = 1.5651414600184348 * this.rS_;
            block3: for (int iy = 0; iy < this.dyMax_; ++iy) {
                double lambdaRad;
                double phiRad;
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                if (y < yy) {
                    phiRad = yOverRS / 0.9964;
                    lambdaRad = 0.0;
                } else {
                    phiRad = Math.toRadians(89.0);
                    lambdaRad = Math.toRadians(160.0);
                }
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double[] llRad = this.iterateXY2LL(x, y, lambdaRad, phiRad);
                    if (llRad == null) {
                        if (!(Math.abs(lambdaRad) > Math.PI)) continue;
                        continue block3;
                    }
                    lambdaRad = llRad[0] + 1.0E-5;
                    this.set4SymmetricPoints(ix, iy, Math.toDegrees(llRad[0]), Math.toDegrees(llRad[1]));
                }
            }
        }
    }

    private double[] iterateXY2LL(double x, double y, double lambdaRad0, double phiRad0) {
        double yOverRS = y * this.invRS_;
        double xOverRS = x * this.invRS_;
        boolean found = false;
        double lambdaRad = lambdaRad0;
        double phiRad = phiRad0;
        double itermax = phiRad0 > Math.toRadians(88.0) ? 330.0 : 33.0;
        int iter = 0;
        while ((double)iter < itermax) {
            double lambdaRad2 = lambdaRad * lambdaRad;
            double phiRad2 = phiRad * phiRad;
            double f1 = CantersPolyconicW13.equation17(lambdaRad, phiRad) - xOverRS;
            double f2 = CantersPolyconicW13.equation18(lambdaRad, phiRad) - yOverRS;
            double df1dPhi = lambdaRad * phiRad * (-0.3404 + -0.0124 * lambdaRad2 + 0.0144 * phiRad2);
            double df1dLambda = 0.8478 + phiRad2 * (-0.1702 + -0.0186 * lambdaRad2 + 0.0036 * phiRad2);
            double df2dPhi = 0.9964 + lambdaRad2 * (0.0313 + 9.0E-4 * lambdaRad2 + -0.03 * phiRad2);
            double df2dLambda = phiRad * lambdaRad * (0.0626 + 0.0036 * lambdaRad2 + -0.02 * phiRad2);
            double denom = df1dPhi * df2dLambda - df2dPhi * df1dLambda;
            double dphi = (f1 * df2dLambda - f2 * df1dLambda) / denom;
            double dlambda = (f2 * df1dPhi - f1 * df2dPhi) / denom;
            phiRad -= dphi;
            lambdaRad -= dlambda;
            if (Math.abs(dphi) < 1.0E-5 && Math.abs(dlambda) < 1.0E-5) {
                found = true;
                break;
            }
            ++iter;
        }
        if (!found) {
            return null;
        }
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        return new double[]{lambdaRad, phiRad};
    }

    private static double equation17(double lambdaRad, double phiRad) {
        double lambdaRad2 = lambdaRad * lambdaRad;
        double phiRad2 = phiRad * phiRad;
        return lambdaRad * (0.8478 + phiRad2 * (-0.1702 + -0.0062 * lambdaRad2 + 0.0036 * phiRad2));
    }

    private static double equation18(double lambdaRad, double phiRad) {
        double lambdaRad2 = lambdaRad * lambdaRad;
        double phiRad2 = phiRad * phiRad;
        return phiRad * (0.9964 + lambdaRad2 * (0.0313 + 9.0E-4 * lambdaRad2 + -0.01 * phiRad2));
    }
}

