/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.AzimuthalProjection;
import java.awt.Dimension;

public class Gnomonic
extends AzimuthalProjection {
    public static final String PROJECTION_NAME = "Gnomonic";
    private static final double MAX_RADIUS = 85.0;
    private static final double DEFAULT_RADIUS = 15.0;

    public Gnomonic(int width, int height) {
        this(width, height, 0, 0);
    }

    public Gnomonic(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Gnomonic(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x200040, width, height, xmargin, ymargin, 1.0, 1.0);
        this.addEdgeRadiusParameter(15.0, 85.0, true);
        this.addFillParameter();
        this.parameterChanged(null);
    }

    @Override
    public void setEdgeRadius(double r) {
        this.radiusDeg_ = r;
        this.radiusRad_ = Math.toRadians(this.radiusDeg_);
        this.autoscale();
    }

    @Override
    protected void prepareScaling() {
        double rhoMaxOverR = 1.0 / Math.tan(1.5707963267948966 - this.radiusRad_);
        this.setSizeFactor(rhoMaxOverR);
    }

    @Override
    protected final void finishScaling() {
        if (this.fillCorners_) {
            double rhoBOverR = 1.0 / Math.tan(1.5707963267948966 - Math.toRadians(85.0));
            this.rhoBorder_ = rhoBOverR * this.rS_;
        } else {
            this.rhoBorder_ = this.xmRS_;
        }
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
    }

    @Override
    protected double getKForCosZ(double cosZ) {
        if (cosZ <= 0.0) {
            return -1.0;
        }
        return 1.0 / cosZ;
    }

    @Override
    protected double getZForRhoRS(double rhoRS) {
        return Math.atan(rhoRS * this.invRS_);
    }
}

