/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.map.proj.ProjectionUtils;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hufnagel
extends GlobalPseudocylindric {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Hufnagel";
    private static final int LUT_SIZE = 201;
    private static final double EPS = 1.0E-14;
    private double capA_ = 0.6666666666666666;
    private double capB_ = 0.3333333333333333;
    private double psiMax_ = 90.0;
    private double psiMaxRad_ = 0.7853981633974483;
    private double alpha_ = 2.0;
    private double capK_ = 1.0;
    private double capK2_ = 1.0;
    private double capC_ = 1.0;
    private double halfB_;
    private double aPlusB_;
    private double onePlusAMinusHalfB_;
    private double cOverK_;
    private double kOverC_;
    private double kC_;
    private double[] phiLUT_;
    private double[] yLUT_;
    private double[] psiLUT_;
    private double psiRadOfMaxX_;

    public Hufnagel(int width, int height) {
        this(width, height, 0, 0);
    }

    public Hufnagel(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Hufnagel(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, 1.0, 1.0);
        this.addParameter(new ProjDoubleParameter("Parameter A", "A", "", 0.6666666666666666, -1.0, 1.0));
        this.addParameter(new ProjDoubleParameter("Parameter B", "B", "", 0.3333333333333333, -1.0, 1.0));
        this.addParameter(new ProjDoubleParameter("Parameter angle \u03a8max", "\u03a8max", "\u00b0", 45.0, 0.0, 90.0));
        this.addParameter(new ProjDoubleParameter("Aspect ratio", "\u03b1", "", 2.0, 1.0, 2.5));
        this.autoscale();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        this.capA_ = ((ProjDoubleParameter)this.getParameter(0)).getValue();
        this.capB_ = ((ProjDoubleParameter)this.getParameter(1)).getValue();
        this.psiMax_ = ((ProjDoubleParameter)this.getParameter(2)).getValue();
        this.alpha_ = ((ProjDoubleParameter)this.getParameter(3)).getValue();
        this.autoscale();
    }

    @Override
    protected void prepareScaling() {
        double hf;
        double wf;
        this.initMe();
        if (Math.abs(this.psiMax_) < 1.0E-5) {
            wf = Math.PI * this.capK_;
            hf = 1.0 / this.capK_;
        } else {
            if (this.psiRadOfMaxX_ < 1.0E-5) {
                wf = this.kC_ * Math.sqrt(1.0 + this.capA_ + this.capB_);
            } else {
                double cos2Psi = Math.cos(2.0 * this.psiRadOfMaxX_);
                double cos4Psi = Math.cos(4.0 * this.psiRadOfMaxX_);
                double r2 = 1.0 + this.capA_ * cos2Psi + this.capB_ * cos4Psi;
                double r = Math.sqrt(r2);
                wf = this.kC_ * r * Math.cos(this.psiRadOfMaxX_);
            }
            double psi90Rad = this.psiFromPhi(1.5707963267948966);
            double sinPsi = Math.sin(psi90Rad);
            double cos2Psi = Math.cos(2.0 * psi90Rad);
            double cos4Psi = Math.cos(4.0 * psi90Rad);
            double r2 = 1.0 + this.capA_ * cos2Psi + this.capB_ * cos4Psi;
            double r = Math.sqrt(r2);
            hf = this.kOverC_ * r * sinPsi;
        }
        this.setSizeFactors(wf, hf);
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double y;
        double x;
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        if (Math.abs(this.psiMax_) < 1.0E-5) {
            x = lambdaRad * this.capK_;
            y = Math.sin(phiRad) / this.capK_;
        } else {
            double psiRad = this.psiFromPhi(phiRad);
            if (Double.isNaN(psiRad) || Math.abs(psiRad) > this.psiMaxRad_) {
                return null;
            }
            double sinPsi = Math.sin(psiRad);
            double cosPsi = Math.cos(psiRad);
            double cos2Psi = Math.cos(2.0 * psiRad);
            double cos4Psi = Math.cos(4.0 * psiRad);
            double r2 = 1.0 + this.capA_ * cos2Psi + this.capB_ * cos4Psi;
            double r = Math.sqrt(r2);
            x = this.kC_ * r * lambdaRad * 0.3183098861837907 * cosPsi;
            y = this.kOverC_ * r * sinPsi;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double phiRad;
        double lambdaRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        if (this.psiMaxRad_ == 0.0) {
            if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
                return null;
            }
            lambdaRad = x * this.invRS_ / this.capK_;
            phiRad = Math.asin(y * this.invRS_ * this.capK_);
        } else {
            double sin6Psi;
            double sin4Psi;
            double psiRad = this.psiFromY(y * this.invRS_);
            if (Double.isNaN(psiRad) || Math.abs(psiRad) > this.psiMaxRad_) {
                return null;
            }
            double sin2Psi = Math.sin(2.0 * psiRad);
            double piSinPhi = 0.25 * this.capK2_ * (2.0 * psiRad + this.onePlusAMinusHalfB_ * sin2Psi + 0.5 * this.aPlusB_ * (sin4Psi = Math.sin(4.0 * psiRad)) + 0.5 * this.capB_ * (sin6Psi = Math.sin(6.0 * psiRad)));
            double sinPhi = piSinPhi * 0.3183098861837907;
            if (Math.abs(sinPhi) > 1.0) {
                return null;
            }
            phiRad = Math.asin(sinPhi);
            double cosPsi = Math.cos(psiRad);
            double cos2Psi = Math.cos(2.0 * psiRad);
            double cos4Psi = Math.cos(4.0 * psiRad);
            double r2 = 1.0 + this.capA_ * cos2Psi + this.capB_ * cos4Psi;
            double r = Math.sqrt(r2);
            lambdaRad = x * this.invRS_ * Math.PI / (this.kC_ * r * cosPsi);
        }
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Hufnagel hufnagel = this;
        synchronized (hufnagel) {
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double x;
                double lambdaRad;
                double xFactor;
                double phiRad;
                double y = (double)iy + 0.5;
                if (this.psiMaxRad_ == 0.0) {
                    phiRad = Math.asin(y * this.invRS_ * this.capK_);
                    xFactor = 1.0 / this.capK_;
                } else {
                    double sin6Psi;
                    double sin4Psi;
                    double psiRad;
                    try {
                        psiRad = this.psiFromY(y * this.invRS_);
                    }
                    catch (Exception c) {
                        break;
                    }
                    if (Double.isNaN(psiRad) || Math.abs(psiRad) > this.psiMaxRad_) break;
                    double twoPsiRad = 2.0 * psiRad;
                    double fourPsiRad = 4.0 * psiRad;
                    double sin2Psi = Math.sin(twoPsiRad);
                    double piSinPhi = 0.25 * this.capK2_ * (2.0 * psiRad + this.onePlusAMinusHalfB_ * sin2Psi + 0.5 * this.aPlusB_ * (sin4Psi = Math.sin(fourPsiRad)) + 0.5 * this.capB_ * (sin6Psi = Math.sin(6.0 * psiRad)));
                    double sinPhi = piSinPhi * 0.3183098861837907;
                    if (Math.abs(sinPhi) > 1.0) break;
                    phiRad = Math.asin(sinPhi);
                    double cosPsi = Math.cos(psiRad);
                    double cos2Psi = Math.cos(twoPsiRad);
                    double cos4Psi = Math.cos(fourPsiRad);
                    double r = Math.sqrt(1.0 + this.capA_ * cos2Psi + this.capB_ * cos4Psi);
                    xFactor = Math.PI / (this.kC_ * r * cosPsi);
                }
                if (phiRad > 1.5707963267948966) break;
                double phi = Math.toDegrees(phiRad);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * this.invRS_ * xFactor) > Math.PI); ++ix) {
                    this.set4SymmetricPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        if (this.psiMaxRad_ < 1.0E-5) {
            ProjectionUtils.drawRectBorder(g2d, this.outCenterX_ - this.dxMax_, this.outCenterY_ - this.dyMax_, 2.0 * (double)this.dxMax_, 2.0 * (double)this.dyMax_);
            return;
        }
        Bezier[] curves = this.makeOuterBezier();
        if (curves != null) {
            if (curves[0] != null) {
                curves[0].draw(g2d);
            }
            if (curves[1] != null) {
                curves[1].draw(g2d);
            }
        }
        if (Math.abs(this.psiMaxRad_ - 1.5707963267948966) < 1.0E-5) {
            return;
        }
        Point2D.Double dot = this.transformLL2XYIgnoreMargins(this.lambdaC_ + 180.0, 90.0);
        if (dot == null) {
            LOGGER.debug("Got null XY for pole {}", (Object)(this.lambdaC_ + 180.0));
            return;
        }
        if (Math.abs(dot.x - (double)this.outCenterX_) < 1.0E-5) {
            LOGGER.debug("Got small dX for pole {}", (Object)(this.lambdaC_ + 180.0));
            return;
        }
        g2d.draw(new Line2D.Double(dot.x, dot.y, 2.0 * (double)this.outCenterX_ - dot.x, dot.y));
        g2d.draw(new Line2D.Double(dot.x, 2.0 * (double)this.outCenterY_ - dot.y, 2.0 * (double)this.outCenterX_ - dot.x, 2.0 * (double)this.outCenterY_ - dot.y));
    }

    private void initMe() {
        this.psiMaxRad_ = Math.toRadians(this.psiMax_);
        this.halfB_ = 0.5 * this.capB_;
        this.aPlusB_ = this.capA_ + this.capB_;
        this.onePlusAMinusHalfB_ = 1.0 + this.capA_ - this.halfB_;
        if (Math.abs(this.psiMax_) < 1.0E-5) {
            this.capK_ = Math.sqrt(this.alpha_ * 0.3183098861837907);
            this.capC_ = 1.0E-5;
        } else {
            double c2;
            double twoPsiMaxRad = 2.0 * this.psiMaxRad_;
            double fourPsiMaxRad = 4.0 * this.psiMaxRad_;
            double sixPsiMaxRad = 6.0 * this.psiMaxRad_;
            this.capK2_ = Math.PI * 4 / (2.0 * this.psiMaxRad_ + this.onePlusAMinusHalfB_ * Math.sin(twoPsiMaxRad) + 0.5 * this.aPlusB_ * Math.sin(fourPsiMaxRad) + this.halfB_ * Math.sin(sixPsiMaxRad));
            this.capK_ = Math.sqrt(this.capK2_);
            double c2term = (1.0 + this.capA_ * Math.cos(twoPsiMaxRad) + this.capB_ * Math.cos(fourPsiMaxRad)) / (1.0 + this.aPlusB_);
            if (c2term <= 0.0) {
                LOGGER.warn("BAD PARAMETER COMBINATION");
                LOGGER.warn("Width to height ratio is less than 0");
                LOGGER.warn("Stretching factor C cannot be calculated.");
                c2 = 1.0E-5;
            } else {
                c2 = this.alpha_ * Math.sin(this.psiMaxRad_) * Math.sqrt(c2term);
            }
            this.capC_ = Math.sqrt(c2);
        }
        this.cOverK_ = this.capC_ / this.capK_;
        this.kOverC_ = this.capK_ / this.capC_;
        this.kC_ = this.capK_ * this.capC_;
        this.phiLUT_ = new double[201];
        this.yLUT_ = new double[201];
        this.psiLUT_ = new double[201];
        double maxX = 0.0;
        this.psiRadOfMaxX_ = 0.0;
        for (int i = 0; i < 201; ++i) {
            double sin6Psi;
            double sin4Psi;
            double sin2Psi;
            double piSinPhi;
            double sinPhi;
            double psiRad = this.psiMaxRad_ * (double)i / 200.0;
            double twoPsiRad = 2.0 * psiRad;
            double fourPsiRad = 4.0 * psiRad;
            double sixPsiRad = 6.0 * psiRad;
            double phiRad = i == 0 ? 0.0 : (i == 200 ? 1.5707963267948966 : (Math.abs(sinPhi = (piSinPhi = 0.25 * this.capK2_ * (twoPsiRad + this.onePlusAMinusHalfB_ * (sin2Psi = Math.sin(twoPsiRad)) + 0.5 * this.aPlusB_ * (sin4Psi = Math.sin(fourPsiRad)) + this.halfB_ * (sin6Psi = Math.sin(sixPsiRad)))) * 0.3183098861837907) > 1.0 ? (sinPhi > 0.0 ? 1.5707963267948966 : -1.5707963267948966) : Math.asin(sinPhi)));
            double sinPsi = Math.sin(psiRad);
            double cosPsi = Math.cos(psiRad);
            double cos2Psi = Math.cos(twoPsiRad);
            double cos4Psi = Math.cos(fourPsiRad);
            double r2 = 1.0 + this.capA_ * cos2Psi + this.capB_ * cos4Psi;
            double r = Math.sqrt(r2);
            double x = this.kC_ * 0.3183098861837907 * r * cosPsi;
            double y = this.kOverC_ * r * sinPsi;
            if (x > maxX) {
                this.psiRadOfMaxX_ = psiRad;
                maxX = x;
            }
            this.yLUT_[i] = y;
            this.phiLUT_[i] = phiRad;
            this.psiLUT_[i] = psiRad;
        }
    }

    private double approximatePsiFromTable(double v, double[] table) {
        double psiRad;
        int imid;
        double absV = Math.abs(v);
        int imin = 0;
        int imax = 201;
        while ((imid = (int)Math.floor((imin + imax) / 2)) != imin) {
            if (absV > table[imid]) {
                imin = imid;
                continue;
            }
            imax = imid;
        }
        try {
            double w = (absV - table[imin]) / (table[imin + 1] - table[imin]);
            psiRad = w * (this.psiLUT_[imin + 1] - this.psiLUT_[imin]) + this.psiLUT_[imin];
        }
        catch (Exception exc) {
            LOGGER.debug("approximatePsiFromTable error for absV = {}, imin = {}", (Object)absV, (Object)imin);
            return Double.NaN;
        }
        return v < 0.0 ? -psiRad : psiRad;
    }

    private double psiFromPhi(double phiRad) {
        double psiRad = this.approximatePsiFromTable(phiRad, this.phiLUT_);
        if (Double.isNaN(psiRad)) {
            return Double.NaN;
        }
        int i = 0;
        while (true) {
            double twoPsiRad = 2.0 * psiRad;
            double fourPsiRad = 4.0 * psiRad;
            double sixPsiRad = 6.0 * psiRad;
            double sin2Psi = Math.sin(twoPsiRad);
            double sin4Psi = Math.sin(fourPsiRad);
            double sin6Psi = Math.sin(sixPsiRad);
            double cos2Psi = Math.cos(twoPsiRad);
            double cos4Psi = Math.cos(fourPsiRad);
            double cos6Psi = Math.cos(sixPsiRad);
            double numerator = 0.25 * this.capK2_ * (twoPsiRad + this.onePlusAMinusHalfB_ * sin2Psi + 0.5 * this.aPlusB_ * sin4Psi + this.halfB_ * sin6Psi) - Math.PI * Math.sin(phiRad);
            if (Math.abs(numerator) < 1.0E-14) break;
            double denominator = 0.5 * this.capK2_ * (1.0 + this.onePlusAMinusHalfB_ * cos2Psi + this.aPlusB_ * cos4Psi + 3.0 * this.halfB_ * cos6Psi);
            double deltaPsiRad = numerator / denominator;
            if (Double.isNaN(deltaPsiRad) || Double.isInfinite(deltaPsiRad) || i++ > 33) {
                return Double.NaN;
            }
            psiRad -= deltaPsiRad;
        }
        return psiRad;
    }

    private double psiFromY(double y) {
        double psiRad = this.approximatePsiFromTable(y, this.yLUT_);
        if (Double.isNaN(psiRad)) {
            return Double.NaN;
        }
        int i = 0;
        while (true) {
            double scaledY;
            double cos4Psi;
            double twoPsiRad = 2.0 * psiRad;
            double sinPsi = Math.sin(psiRad);
            double sin2Psi = Math.sin(twoPsiRad);
            double cos2Psi = Math.cos(twoPsiRad);
            double r2 = 1.0 + this.capA_ * cos2Psi + this.capB_ * (cos4Psi = Math.cos(2.0 * twoPsiRad));
            double numerator = r2 * sinPsi * sinPsi - (scaledY = y * this.cOverK_) * scaledY;
            if (Math.abs(numerator) < 1.0E-14) break;
            double denominator = sin2Psi * (1.0 - this.capA_ + 2.0 * this.capB_ + (2.0 * this.capA_ - 4.0 * this.capB_) * cos2Psi + 3.0 * this.capB_ * cos4Psi);
            double deltaPsiRad = numerator / denominator;
            if (Double.isNaN(deltaPsiRad) || Double.isInfinite(deltaPsiRad) || i++ > 33) {
                return Double.NaN;
            }
            psiRad -= deltaPsiRad;
        }
        return psiRad;
    }
}

