/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.LonLatRotator;
import gov.nasa.giss.map.proj.BiSymmetricProjection;
import gov.nasa.giss.map.proj.ProjBooleanParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.map.proj.ProjectionUtils;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class Littrow
extends BiSymmetricProjection {
    public static final String PROJECTION_NAME = "Littrow";
    public static final int PROPERTIES = 2103296;
    private static final double WIDTH_FACTOR = 2.0;
    private static final double HEIGHT_FACTOR = 1.7320508075688772;
    protected double cosPhiC_;
    protected double sinPhiC_;
    private ProjBooleanParameter fillParam_;
    private boolean fillCorners_;
    private LonLatRotator rotMatrices_;

    public Littrow(int width, int height) {
        this(width, height, 0, 0);
    }

    public Littrow(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Littrow(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 2103296, width, height, xmargin, ymargin, 2.0, 1.7320508075688772);
        this.rotMatrices_ = new LonLatRotator(this.lambdaC_, this.phiC_);
        this.fillParam_ = new ProjBooleanParameter("Map is not limited to purely circular area", "Fill corners", false);
        this.addParameter(this.fillParam_);
        this.parameterChanged(null);
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p != null && p != this.fillParam_) {
            throw new IllegalArgumentException("Unknown parameter");
        }
        this.setFillCorners(this.fillParam_.isSelected());
    }

    public void setFillCorners(boolean fill) {
        this.fillCorners_ = fill;
        this.autoscale();
    }

    @Override
    public void setCenter(double lon, double lat) {
        super.setCenter(lon, lat);
        this.cosPhiC_ = Math.cos(this.phiCRad_);
        this.sinPhiC_ = Math.sin(this.phiCRad_);
        if (this.rotMatrices_ != null) {
            this.rotMatrices_.setAngles(lon, lat);
        }
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double secPhi;
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double[] llP = this.rotMatrices_.rotate(lon, lat);
        double latP = llP[1];
        if (!this.fillCorners_ && Math.abs(latP) > 60.0) {
            return null;
        }
        double lonP = llP[0];
        double lambdaRad = Math.toRadians(lonP);
        if (Math.abs(lambdaRad) >= 1.5707963267948966) {
            return null;
        }
        double cosLambda = Math.cos(lambdaRad);
        double phiRad = Math.toRadians(Math.abs(latP));
        double cosPhi = Math.cos(phiRad);
        double sinPhi = Math.sin(phiRad);
        double tanPhi = sinPhi * (secPhi = 1.0 / cosPhi);
        double y = cosLambda * tanPhi;
        if (y < 0.0) {
            return null;
        }
        if (latP < 0.0) {
            y = -y;
        }
        double sinLambda = Math.sin(lambdaRad);
        double x = sinLambda * secPhi;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double xOverRS = x * this.invRS_;
        double yOverRS = y * this.invRS_;
        double phiRad = 0.0;
        double lambdaRad = 0.0;
        double phiP = Math.toDegrees(phiRad);
        double lambdaP = Math.toDegrees(lambdaRad);
        if (yOverRS == 0.0) {
            if (Math.abs(x) > this.xmRS_) {
                return null;
            }
            phiRad = 0.0;
            lambdaRad = Math.asin(xOverRS);
            phiP = Math.toDegrees(phiRad);
            lambdaP = Math.toDegrees(lambdaRad);
        } else if (xOverRS == 0.0) {
            lambdaRad = 0.0;
            phiRad = Math.acos(1.0 / Math.sqrt(yOverRS * yOverRS + 1.0));
            phiP = Math.toDegrees(phiRad);
            lambdaP = Math.toDegrees(lambdaRad);
        } else {
            double x2 = xOverRS * xOverRS;
            double y2 = yOverRS * yOverRS;
            double x2Plusy2Plus1 = x2 + y2 + 1.0;
            double x2Plusy2Plus1Sq = x2Plusy2Plus1 * x2Plusy2Plus1;
            double cos2Phi = 0.5 * (x2Plusy2Plus1 - Math.sqrt(x2Plusy2Plus1Sq - 4.0 * x2)) / x2;
            phiRad = Math.acos(Math.sqrt(cos2Phi));
            double sinLambda = xOverRS * Math.cos(phiRad);
            lambdaRad = Math.asin(sinLambda);
            phiP = Math.toDegrees(phiRad);
            if (!this.fillCorners_ && phiP > 60.0) {
                return null;
            }
            lambdaP = Math.toDegrees(lambdaRad);
        }
        try {
            double[] ll = this.rotMatrices_.inverse(lambdaP, phiP);
            return new PointLL(ll[0], ll[1]);
        }
        catch (Exception exc) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Littrow littrow = this;
        synchronized (littrow) {
            block3: for (int iy = 0; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                double y2 = yOverRS * yOverRS;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double xOverRS = x * this.invRS_;
                    double x2 = xOverRS * xOverRS;
                    double x2PlusY2Plus1 = x2 + y2 + 1.0;
                    double x2PlusY2Plus1Sq = x2PlusY2Plus1 * x2PlusY2Plus1;
                    double cos2Phi = 0.5 * (x2PlusY2Plus1 - Math.sqrt(x2PlusY2Plus1Sq - 4.0 * x2)) / x2;
                    double phiRad = Math.acos(Math.sqrt(cos2Phi));
                    double sinLambda = xOverRS * Math.cos(phiRad);
                    double lambdaRad = Math.asin(sinLambda);
                    double phiP = Math.toDegrees(phiRad);
                    if (!this.fillCorners_ && phiP > 60.0) continue block3;
                    double lambdaP = Math.toDegrees(lambdaRad);
                    double[] ll = this.rotMatrices_.inverse(lambdaP, phiP);
                    this.set2SymmetricPoints(ix, iy, ll[0] - this.lambdaC_, ll[1]);
                    ll = this.rotMatrices_.inverse(lambdaP, -phiP);
                    this.set2SymmetricPoints(ix, -iy - 1, ll[0] - this.lambdaC_, ll[1]);
                }
            }
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        if (this.fillCorners_) {
            ProjectionUtils.drawRect(g2d, this.outCenterX_ - this.dxMax_, this.outCenterY_ - this.dyMax_, 2.0 * (double)this.dxMax_, 2.0 * (double)this.dyMax_);
            GraphicUtils.drawLine(g2d, (double)this.outCenterX_ + 0.5 * this.xmRS_, this.outCenterY_, this.outCenterX_ + this.dxMax_, this.outCenterY_);
            GraphicUtils.drawLine(g2d, this.outCenterX_ - this.dxMax_, this.outCenterY_, (double)this.outCenterX_ - 0.5 * this.xmRS_, this.outCenterY_);
        } else {
            ProjectionUtils.drawEllipse(g2d, this.outCenterX_, this.outCenterY_, this.xmRS_, this.ymRS_);
            GraphicUtils.drawLine(g2d, (double)this.outCenterX_ + 0.5 * this.xmRS_, this.outCenterY_, (double)this.outCenterX_ + this.xmRS_, this.outCenterY_);
            GraphicUtils.drawLine(g2d, (double)this.outCenterX_ - this.xmRS_, this.outCenterY_, (double)this.outCenterX_ - 0.5 * this.xmRS_, this.outCenterY_);
        }
    }
}

