/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.Elliptic;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mayr
extends GlobalPseudocylindric {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Mayr";
    private static final boolean USE_ELLIPTIC = true;
    private static final boolean TEST_VALIDATE = false;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.198140234716017;
    private static final double A1 = -0.08333333333333333;
    private static final double A2 = -0.0020833333333333333;
    private static final double A3 = -4.7123015873015874E-4;
    private static final double A4 = -9.627838403880071E-5;
    private static final double A5 = -2.2815424833654E-5;
    private static final double MODULUS = 0.7071067811865476;
    private static final double MODULUS2 = 0.5000000000000001;

    public Mayr(int width, int height) {
        this(width, height, 0, 0);
    }

    public Mayr(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Mayr(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, Math.PI, 1.198140234716017);
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double y;
        double x;
        double absLat = Math.abs(lat);
        if (absLat > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        if (absLat < 1.0E-5) {
            x = lambdaRad;
            y = 0.0;
        } else if (90.0 - absLat < 1.0E-5) {
            x = 0.0;
            y = lat > 0.0 ? 1.198140234716017 : -1.198140234716017;
        } else {
            double phiRad = Math.toRadians(absLat);
            double phi1Rad = Math.asin(1.4142135623730951 * Math.sin(0.5 * phiRad));
            y = 2.8284271247461903 * (Elliptic.ellipticE(phi1Rad, 0.5000000000000001) - 0.5 * Elliptic.ellipticF(phi1Rad, 0.5000000000000001));
            if (lat < 0.0) {
                y = -y;
            }
            double sqrtCosPhi = Math.sqrt(Math.cos(phiRad));
            x = lambdaRad * sqrtCosPhi;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absY = Math.abs(y);
        if (Math.abs(x) > (double)this.dxMax_ || absY > (double)this.dyMax_) {
            return null;
        }
        if (absY > this.ymRS_) {
            return null;
        }
        double phiRad = Double.NaN;
        try {
            phiRad = this.iterateAbsYToPhiRad(absY);
        }
        catch (Exception exc) {
            LOGGER.debug("{}", (Object)exc.toString());
            LOGGER.debug("y/RS {}", (Object)(y * this.invRS_));
            return null;
        }
        if (Double.isNaN(phiRad)) {
            return null;
        }
        if (y < 0.0) {
            phiRad = -phiRad;
        }
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double cosPhi = Math.cos(phiRad);
        double xOverRS = x * this.invRS_;
        double d = lambdaRad = cosPhi > 0.0 ? xOverRS / Math.sqrt(cosPhi) : 0.0;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Mayr mayr = this;
        synchronized (mayr) {
            double y;
            for (int iy = 0; iy < this.dyMax_ && !((y = (double)iy + 0.5) > this.ymRS_); ++iy) {
                double x;
                double lambdaRad;
                double phiRad = this.iterateAbsYToPhiRad(y);
                if (Double.isNaN(phiRad)) continue;
                if (phiRad > 1.5707963267948966) break;
                double phi = Math.toDegrees(phiRad);
                double xfactor = this.invRS_ / Math.sqrt(Math.cos(phiRad));
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xfactor) > Math.PI); ++ix) {
                    this.set4SymmetricPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }

    private double iterateAbsYToPhiRad(double absY) {
        if (absY < 1.0E-10) {
            return 0.0;
        }
        double yOverRS = absY * this.invRS_;
        if (yOverRS > 1.198130234716017) {
            return 1.5707963267948966;
        }
        double phiRad = 1.5707963267948966 * (yOverRS / 1.198140234716017);
        for (int iter = 0; iter < 33; ++iter) {
            double cosPhi = Math.cos(phiRad);
            double phi1Rad = Math.asin(1.4142135623730951 * Math.sin(0.5 * phiRad));
            double elliptic = 2.8284271247461903 * (Elliptic.ellipticE(phi1Rad, 0.5000000000000001) - 0.5 * Elliptic.ellipticF(phi1Rad, 0.5000000000000001));
            double func = elliptic - yOverRS;
            double dfunc = Math.sqrt(cosPhi);
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        return phiRad;
    }

    private void validateForward() {
        for (int i = 0; i <= 90; i += 5) {
            double phiRad = Math.toRadians(i);
            double phi1Rad = Math.asin(1.4142135623730951 * Math.sin(0.5 * phiRad));
            double yE = 2.8284271247461903 * (Elliptic.ellipticE(phi1Rad, 0.5000000000000001) - 0.5 * Elliptic.ellipticF(phi1Rad, 0.5000000000000001));
            double phiRad2 = phiRad * phiRad;
            double phiRad4 = phiRad2 * phiRad2;
            double phiRad6 = phiRad4 * phiRad2;
            double phiRad8 = phiRad4 * phiRad4;
            double phiRad10 = phiRad6 * phiRad4;
            double yM = phiRad * (1.0 + -0.08333333333333333 * phiRad2 + -0.0020833333333333333 * phiRad4 + -4.7123015873015874E-4 * phiRad6 + -9.627838403880071E-5 * phiRad8 + -2.2815424833654E-5 * phiRad10);
            LOGGER.trace("phi {}, yE {}, yM {}", i, yE, yM);
        }
    }

    private void validateInverse() {
        for (int i = 5; i < 120; i += 10) {
            double dphiRad;
            double dfunc;
            double func;
            double y = 0.01 * (double)i;
            double phiRad = y / 1.198140234716017 * 1.5707963267948966;
            for (int iter = 0; iter < 33; ++iter) {
                double cosPhi = Math.cos(phiRad);
                double phi1Rad = Math.asin(1.4142135623730951 * Math.sin(0.5 * phiRad));
                double ellipticE = Elliptic.ellipticE(phi1Rad, 0.5000000000000001);
                double ellipticF = Elliptic.ellipticF(phi1Rad, 0.5000000000000001);
                double elliptic = 2.8284271247461903 * (ellipticE - 0.5 * ellipticF);
                func = elliptic - y;
                dfunc = Math.sqrt(cosPhi);
                dphiRad = -func / dfunc;
                phiRad += dphiRad;
                if (Math.abs(dphiRad) < 1.0E-5) break;
            }
            double phiE = phiRad;
            phiRad = y / 1.198140234716017 * 1.5707963267948966;
            for (int iter = 0; iter < 33; ++iter) {
                double phiRad2 = phiRad * phiRad;
                double phiRad4 = phiRad2 * phiRad2;
                double phiRad6 = phiRad4 * phiRad2;
                double phiRad8 = phiRad4 * phiRad4;
                double phiRad10 = phiRad6 * phiRad4;
                func = phiRad * (1.0 + -0.08333333333333333 * phiRad2 + -0.0020833333333333333 * phiRad4 + -4.7123015873015874E-4 * phiRad6 + -9.627838403880071E-5 * phiRad8 + -2.2815424833654E-5 * phiRad10) - y;
                dfunc = 1.0 + -0.25 * phiRad2 + -0.010416666666666666 * phiRad4 + -0.003298611111111111 * phiRad6 + -8.665054563492064E-4 * phiRad8 + -2.5096967317019404E-4 * phiRad10;
                dphiRad = -func / dfunc;
                phiRad += dphiRad;
                if (Math.abs(dphiRad) < 1.0E-5) break;
            }
            double phiM = phiRad;
            LOGGER.trace("i {}, phiE {}, phiM {}", i, phiE, phiM);
        }
    }
}

