/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalCylindric;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class Mercator
extends GlobalCylindric {
    public static final String PROJECTION_NAME = "Mercator";
    public static final int PROPERTIES = 4100;
    private static final double DEFAULT_MAXLAT = 85.05;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = Math.log(Math.tan(1.527599427808037));
    public double maxLat_ = 85.05;
    private ProjDoubleParameter maxLatParam_ = new ProjDoubleParameter("Latitude at top of map", "Max. Latitude", "\u00b0", 85.05, 45.0, 89.9875, true, false);

    public Mercator(int width, int height) {
        this(width, height, 0, 0);
    }

    public Mercator(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Mercator(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4100, width, height, xmargin, ymargin, Math.PI, HEIGHT_FACTOR);
        this.addParameter(this.maxLatParam_);
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p == this.maxLatParam_) {
            this.setMaximumLatitude(this.maxLatParam_.getValue());
        } else if (p != this.getParameter(0)) {
            throw new IllegalArgumentException("Unknown parameter");
        }
    }

    public void setMaximumLatitude(double lat) {
        this.maxLat_ = lat;
        this.autoscale();
    }

    @Override
    protected void prepareScaling() {
        double heightFactor = Math.log(Math.tan(0.5 * (1.5707963267948966 + Math.toRadians(this.maxLat_))));
        this.setSizeFactors(Math.PI, heightFactor);
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > this.maxLat_) {
            return null;
        }
        double x = this.lonToLambdaRad(lon);
        double y = Math.log(Math.tan(0.5 * (1.5707963267948966 + Math.toRadians(lat))));
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double phiRad = 2.0 * Math.atan(Math.exp(y * this.invRS_)) - 1.5707963267948966;
        if (Math.abs(Math.toDegrees(phiRad)) > this.maxLat_) {
            return null;
        }
        double lambdaRad = x * this.invRS_;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Mercator mercator = this;
        synchronized (mercator) {
            double y;
            double phiRad;
            double phi;
            for (int iy = 0; iy < this.dyMax_ && !((phi = Math.toDegrees(phiRad = 2.0 * Math.atan(Math.exp((y = (double)iy + 0.5) * this.invRS_)) - 1.5707963267948966)) > this.maxLat_); ++iy) {
                double x;
                double lambdaRad;
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * this.invRS_) > Math.PI); ++ix) {
                    this.set4SymmetricPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

