/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.math.ComplexNumber;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ModifiedStereographicProjection
extends AbstractProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int PROPERTIES = 1024;
    protected double sinPhiC_;
    protected double cosPhiC_;
    protected double xshift_;
    protected double yshift_;
    protected int m_;
    protected int mp1_;
    protected int mm1_;
    protected double[] capA_;
    protected double[] capB_;
    protected ComplexNumber[] knuthA_;
    protected ComplexNumber[] knuthB_;
    protected ComplexNumber[] knuthC_;
    protected ComplexNumber[] knuthD_;
    protected ComplexNumber[] knuthG_;

    public ModifiedStereographicProjection(String name, int properties, int width, int height, int xmargin, int ymargin, double widthFactor, double heightFactor, double lambdaC, double phiC, double xshift, double yshift, double[] a, double[] b) {
        super(name, properties, width, height, xmargin, ymargin, widthFactor, heightFactor);
        super.setCenter(lambdaC, phiC);
        this.sinPhiC_ = Math.sin(this.phiCRad_);
        this.cosPhiC_ = Math.cos(this.phiCRad_);
        this.xshift_ = xshift;
        this.yshift_ = yshift;
        this.m_ = a.length - 1;
        this.mp1_ = a.length;
        this.mm1_ = this.m_ - 1;
        this.capA_ = new double[this.mp1_];
        this.capB_ = new double[this.mp1_];
        this.knuthA_ = new ComplexNumber[this.mp1_];
        this.knuthB_ = new ComplexNumber[this.mp1_];
        this.knuthC_ = new ComplexNumber[this.mp1_];
        this.knuthD_ = new ComplexNumber[this.mp1_];
        this.knuthG_ = new ComplexNumber[this.mp1_];
        for (int i = 0; i < this.mp1_; ++i) {
            this.capA_[i] = a[i];
            this.capB_[i] = b[i];
            this.knuthG_[i] = new ComplexNumber(a[i], b[i]);
        }
    }

    @Override
    public void setCenter(double lon) {
        LOGGER.trace("Projection does not support changing center.");
    }

    @Override
    public void setCenter(PointLL pt) {
        LOGGER.trace("Projection does not support changing center.");
    }

    @Override
    public void setCenter(double lon, double lat) {
        LOGGER.trace("Projection does not support changing center.");
    }

    @Override
    public boolean isRecenterableLon() {
        return false;
    }

    @Override
    public boolean isRecenterableLat() {
        return false;
    }

    public abstract boolean isWithinBounds(double var1, double var3);

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (!this.isWithinBounds(lon, lat)) {
            return null;
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double cosLambda = Math.cos(lambdaRad);
        double sinLambda = Math.sin(lambdaRad);
        double phiRad = Math.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double sinPhi = Math.sin(phiRad);
        double kp = 2.0 / (1.0 + this.sinPhiC_ * sinPhi + this.cosPhiC_ * cosPhi * cosLambda);
        double xp = kp * cosPhi * sinLambda;
        double yp = kp * (this.cosPhiC_ * sinPhi - this.sinPhiC_ * cosPhi * cosLambda);
        ComplexNumber xpyi = this.knuthAlgorithm(xp, yp);
        double x = xpyi.getReal() + this.xshift_;
        double y = xpyi.getImaginary() + this.yshift_;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double[] llRad = this.iterateXY2LL(x, y);
        if (llRad == null) {
            return null;
        }
        double lambdaRad = llRad[0];
        double phiRad = llRad[1];
        double lambda = Math.toDegrees(lambdaRad);
        double phi = Math.toDegrees(phiRad);
        return new PointLL(lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        ModifiedStereographicProjection modifiedStereographicProjection = this;
        synchronized (modifiedStereographicProjection) {
            for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double x;
                double[] llRad;
                double y = (double)iy + 0.5;
                for (int ix = -this.dxMax_; ix < this.dxMax_ && (llRad = this.iterateXY2LL(x = (double)ix + 0.5, y)) != null; ++ix) {
                    double phi;
                    double lambdaRad = llRad[0];
                    double phiRad = llRad[1];
                    double lambda = Math.toDegrees(lambdaRad);
                    if (!this.isWithinBounds(lambda, phi = Math.toDegrees(phiRad))) continue;
                    this.setGridPoint(ix, iy, lambda, phi);
                }
            }
        }
    }

    protected ComplexNumber knuthAlgorithm(double xp, double yp) {
        double r = 2.0 * xp;
        double sp = xp * xp + yp * yp;
        this.knuthA_[1] = this.knuthG_[this.m_];
        this.knuthB_[1] = this.knuthG_[this.mm1_];
        this.knuthC_[1] = this.knuthA_[1].multiplyBy(this.m_);
        this.knuthD_[1] = this.knuthB_[1].multiplyBy(this.mm1_);
        for (int j = 2; j < this.mp1_; ++j) {
            this.knuthA_[j] = this.knuthB_[j - 1].add(this.knuthA_[j - 1].multiplyBy(r));
            this.knuthB_[j] = this.knuthG_[this.m_ - j].subtract(this.knuthA_[j - 1].multiplyBy(sp));
            this.knuthC_[j] = this.knuthD_[j - 1].add(this.knuthC_[j - 1].multiplyBy(r));
            this.knuthD_[j] = this.knuthG_[this.m_ - j].multiplyBy(this.m_ - j).subtract(this.knuthC_[j - 1].multiplyBy(sp));
        }
        return new ComplexNumber(xp, yp).multiplyBy(this.knuthA_[this.m_]).add(this.knuthB_[this.m_]);
    }

    private double[] iterateXY2LL(double x, double y) {
        double xOverRS = x * this.invRS_ - this.xshift_;
        double yOverRS = y * this.invRS_ - this.yshift_;
        ComplexNumber xyOverR = new ComplexNumber(xOverRS, yOverRS);
        double xp = xOverRS;
        double yp = yOverRS;
        ComplexNumber guess = new ComplexNumber(xOverRS, yOverRS);
        for (int iter = 0; iter < 33; ++iter) {
            xp = guess.getReal();
            yp = guess.getImaginary();
            ComplexNumber numerator = this.knuthAlgorithm(xp, yp).subtract(xyOverR);
            ComplexNumber divisor = new ComplexNumber(xp, yp).multiplyBy(this.knuthC_[this.mm1_]).add(this.knuthD_[this.mm1_]);
            ComplexNumber negdelta = numerator.divideBy(divisor);
            guess = guess.subtract(negdelta);
            if (Math.abs(negdelta.getReal()) < 1.0E-5 && Math.abs(negdelta.getImaginary()) < 1.0E-5) break;
        }
        xp = guess.getReal();
        yp = guess.getImaginary();
        double rho = Math.sqrt(xp * xp + yp * yp);
        double c = 2.0 * Math.atan2(rho, 2.0);
        double cosC = Math.cos(c);
        double sinC = Math.sin(c);
        double dlambdaRad = Math.atan2(xp * sinC, rho * this.cosPhiC_ * cosC - yp * this.sinPhiC_ * sinC);
        double phiRad = Math.asin(cosC * this.sinPhiC_ + yp * sinC * this.cosPhiC_ / rho);
        return new double[]{this.lambdaCRad_ + dlambdaRad, phiRad};
    }

    protected void setGridPoint(int ix, int iy, double lambda, double phi) {
        int srcX;
        int row = this.outCenterY_ - iy - 1;
        int col = this.outCenterX_ + ix;
        if (row < 0 || row >= this.outHeight_ || col < 0 || col >= this.outWidth_) {
            return;
        }
        int index = row * this.outWidth_ + col;
        this.invArrayLon_[index] = MapUtils.normalize360(lambda);
        this.invArrayLat_[index] = phi;
        int srcY = this.getSrcPixelY(phi);
        if (srcY > -1 && (srcX = this.getSrcPixelX(lambda)) > -1) {
            this.invArray_[index] = srcY * this.srcWidth_ + srcX;
        }
    }
}

