/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.TwoHemisphereGlobularProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;

public class NicolosiGlobular2H
extends TwoHemisphereGlobularProjection {
    public static final String PROJECTION_NAME = "Nicolosi Globular (Two-Hemisphere)";
    public static final int PROPERTIES = 0x6000020;
    private static final double RADIUS_FACTOR = 1.5707963267948966;

    public NicolosiGlobular2H(int width, int height) {
        this(width, height, 0, 0);
    }

    public NicolosiGlobular2H(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public NicolosiGlobular2H(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x6000020, width, height, xmargin, ymargin, 1.5707963267948966);
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        Point2D.Double altXY;
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        boolean rightside = Math.abs(lambdaRad) > 1.5707963267948966;
        double altLon = MapUtils.normalizeMP180(lon);
        if (rightside) {
            altLon = altLon < 0.0 ? (altLon += 180.0) : (altLon -= 180.0);
        }
        if ((altXY = this.transformAltLL2XYIgnoreMargins(altLon, lat)) == null) {
            return null;
        }
        double x = rightside ? altXY.x + (double)this.rightCenterX_ : altXY.x + (double)this.leftCenterX_;
        double y = altXY.y;
        return new Point2D.Double(x, y);
    }

    private Point2D.Double transformAltLL2XYIgnoreMargins(double lon, double lat) {
        double lambdaRad = this.lonToLambdaRad(lon);
        double absLambdaRad = Math.abs(lambdaRad);
        if (absLambdaRad > 1.5707963267948966) {
            return null;
        }
        double phiRad = Math.toRadians(lat);
        double absPhiRad = Math.abs(phiRad);
        double x = 0.0;
        double y = 0.0;
        if (lat == 0.0) {
            x = lambdaRad;
        } else if (absLambdaRad < 1.0E-5 || Math.abs(absPhiRad - 1.5707963267948966) < 1.0E-5) {
            y = phiRad;
        } else if (absLambdaRad > 1.5707863267948965) {
            double cosPhi = Math.cos(phiRad);
            double sinPhi = Math.sin(phiRad);
            x = lambdaRad * cosPhi;
            y = Math.abs(lambdaRad) * sinPhi;
        } else {
            double cosPhi = Math.cos(phiRad);
            double sinPhi = Math.sin(phiRad);
            double cossqPhi = cosPhi * cosPhi;
            double sinsqPhi = sinPhi * sinPhi;
            double f2 = phiRad * 0.6366197723675814;
            double f1 = (1.0 - f2 * f2) / (sinPhi - f2);
            double l1 = 1.5707963267948966 / lambdaRad - lambdaRad * 0.6366197723675814;
            double f1OverL1 = f1 / l1;
            double f1OverL1Sq = f1OverL1 * f1OverL1;
            double b = 1.0 / (1.0 + f1OverL1Sq);
            double c = 1.0 / (1.0 + 1.0 / f1OverL1Sq);
            double d = c * (l1 * sinPhi / f1 - 0.5 * l1);
            double e = b * (f1OverL1Sq * sinPhi + 0.5 * f1);
            double d2 = d * d;
            double e2 = e * e;
            double signLambda = lambdaRad / absLambdaRad;
            double signPhi = phiRad / absPhiRad;
            x = 1.5707963267948966 * (d + signLambda * Math.sqrt(d2 + c * cossqPhi));
            y = 1.5707963267948966 * (e - signPhi * Math.sqrt(e2 - b * (f1OverL1Sq * sinsqPhi + f1 * sinPhi - 1.0)));
        }
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x *= this.rS_, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        boolean leftside = xx < (double)this.outCenterX_;
        double x = leftside ? xx - (double)this.leftCenterX_ : xx - (double)this.rightCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double xOverRS = x * this.invRS_;
        double yOverRS = y * this.invRS_;
        double absXOverRS = Math.abs(xOverRS);
        double absYOverRS = Math.abs(yOverRS);
        if (absXOverRS > 1.5707963267948966 || absYOverRS > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = 0.0;
        double phiRad = 0.0;
        if (x == 0.0) {
            phiRad = yOverRS;
        } else if (y == 0.0) {
            lambdaRad = xOverRS;
        } else {
            double[] lambdaPhi = this.transformUnscaledXYtoLambdaPhi(absXOverRS, absYOverRS);
            if (lambdaPhi == null) {
                return null;
            }
            lambdaRad = lambdaPhi[0];
            phiRad = lambdaPhi[1];
            if (x < 0.0) {
                lambdaRad = -lambdaRad;
            }
            if (y < 0.0) {
                phiRad = -phiRad;
            }
        }
        if (!leftside) {
            lambdaRad += Math.PI;
        }
        return new PointLL(this.lambdaC_ + Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        NicolosiGlobular2H nicolosiGlobular2H = this;
        synchronized (nicolosiGlobular2H) {
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double x;
                double xOverRS;
                double[] lambdaPhi;
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                for (int ix = 0; ix < this.dxMax_ && (lambdaPhi = this.transformUnscaledXYtoLambdaPhi(xOverRS = (x = (double)ix + 0.5) * this.invRS_, yOverRS)) != null; ++ix) {
                    double lambdaRad = lambdaPhi[0];
                    double phiRad = lambdaPhi[1];
                    double lambdaP = Math.toDegrees(lambdaRad);
                    double phiP = Math.toDegrees(phiRad);
                    this.setEightPoints(ix, iy, lambdaP, phiP);
                }
            }
        }
    }

    final double[] transformUnscaledXYtoLambdaPhi(double x, double y) {
        double xSq = x * x;
        double ySq = y * y;
        double xSqPlusYSq = xSq + ySq;
        if (xSqPlusYSq > 2.4674011002723395) {
            return null;
        }
        if (x < 1.0E-10) {
            if (y > 1.5707963267948966) {
                return null;
            }
            return new double[]{x, y};
        }
        if (y < 1.0E-10) {
            return new double[]{0.0, y};
        }
        double x0 = 0.5 / x * (xSqPlusYSq - 2.4674011002723395);
        double rho0Sq = x0 * x0 + 2.4674011002723395;
        double rho0 = Math.sqrt(rho0Sq);
        double lambdaRad = x0 + rho0;
        if (Double.isNaN(lambdaRad) || lambdaRad > Math.PI) {
            return null;
        }
        double phiRad = 0.9 * y;
        for (int i = 0; i < 33; ++i) {
            double thetaRad = phiRad;
            double dthetaDphi = 1.0;
            double cosTheta = Math.cos(thetaRad);
            double sinTheta = Math.sin(thetaRad);
            double xa = 1.5707963267948966 * cosTheta;
            double ya = 1.5707963267948966 * sinTheta;
            if (xa < x) {
                phiRad -= Math.toRadians(1.0);
                continue;
            }
            double aa = xa;
            double bb = ya - phiRad;
            double aSqPlusBSq = aa * aa + bb * bb;
            double invB = 1.0 / bb;
            double inv2B = 0.5 * invB;
            double rp = inv2B * aSqPlusBSq;
            double rpSqMinusXSq = rp * rp - xSq;
            double sqrtRp2MinusX2 = Math.sqrt(rpSqMinusXSq);
            double daDphi = -1.5707963267948966 * sinTheta * 1.0;
            double dbDphi = 1.5707963267948966 * cosTheta * 1.0 - 1.0;
            double drpDphi = inv2B * (2.0 * (aa * daDphi + bb * dbDphi) - invB * aSqPlusBSq * dbDphi);
            double func = phiRad + rp - sqrtRp2MinusX2 - y;
            double dfunc = 1.0 + (1.0 - 0.5 / sqrtRp2MinusX2 * (2.0 * rp)) * drpDphi;
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        return new double[]{lambdaRad, phiRad};
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        for (int i = 0; i < 2; ++i) {
            double lambdaCH = i == 0 ? this.lambdaC_ : this.lambdaC_ + 180.0;
            double outCenterHX = i == 0 ? (double)this.leftCenterX_ : (double)this.rightCenterX_;
            Point2D.Double west = this.transformLL2XYIgnoreMargins(lambdaCH + -89.99999, lat);
            Point2D.Double east = this.transformLL2XYIgnoreMargins(lambdaCH + 89.99999, lat);
            if (lat == 0.0) {
                GraphicUtils.drawLine(g2d, west, east);
                continue;
            }
            Point2D.Double center = this.transformLL2XYIgnoreMargins(lambdaCH, lat);
            boolean pos = lat > 0.0;
            double yyC = Math.abs((double)this.outCenterY_ - center.y);
            double xxE = east.x - outCenterHX;
            double yyE = Math.abs((double)this.outCenterY_ - east.y);
            double yy0 = 0.5 / (yyE - yyC) * (xxE * xxE + yyE * yyE - yyC * yyC);
            double x0 = outCenterHX;
            double y0 = pos ? (double)this.outCenterY_ - yy0 : (double)this.outCenterY_ + yy0;
            double r = Math.abs(yyC - yy0);
            double eAngleRad = Math.asin(xxE / r);
            double eAngle = Math.toDegrees(eAngleRad);
            double startAngle = pos ? eAngle - 90.0 : eAngle + 90.0;
            Arc2D.Double arc = new Arc2D.Double(0);
            arc.setArcByCenter(x0, y0, r, startAngle, -2.0 * eAngle, 0);
            g2d.draw(arc);
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        double lambda = this.lonToLambda(lon);
        if (Math.abs(lambda) == 90.0) {
            return;
        }
        double lambdaRad = Math.toRadians(lambda);
        boolean rightside = Math.abs(lambdaRad) > 1.5707963267948966;
        double altLon = MapUtils.normalizeMP180(lon);
        double centerX = this.leftCenterX_;
        if (rightside) {
            centerX = this.rightCenterX_;
            altLon = altLon < 0.0 ? (altLon += 180.0) : (altLon -= 180.0);
        }
        Point2D.Double npole = this.transformAltLL2XYIgnoreMargins(this.lambdaC_, 90.0);
        Point2D.Double spole = this.transformAltLL2XYIgnoreMargins(this.lambdaC_, -90.0);
        if (lambdaRad == 0.0 || Math.abs(lambdaRad - Math.PI) < 1.0E-5) {
            GraphicUtils.drawLine(g2d, centerX + npole.x, npole.y, centerX + spole.x, spole.y);
        } else {
            Point2D.Double equat = this.transformAltLL2XYIgnoreMargins(altLon, 0.0);
            boolean pos = equat.x > npole.x;
            double xxE = pos ? equat.x - npole.x : npole.x - equat.x;
            double yyN = -(npole.y - equat.y);
            double xx0 = 0.5 / xxE * (xxE * xxE - yyN * yyN);
            double x0 = pos ? npole.x + xx0 : npole.x - xx0;
            double y0 = equat.y;
            double r = Math.abs(equat.x - x0);
            double npAngleRad = Math.asin(yyN / r);
            double npAngle = Math.toDegrees(npAngleRad);
            double startAngle = pos ? npAngle : npAngle + 180.0;
            Arc2D.Double arc = new Arc2D.Double(0);
            arc.setArcByCenter(centerX + x0, y0, r, startAngle, -2.0 * npAngle, 0);
            g2d.draw(arc);
        }
    }
}

