/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.map.proj.ProjBooleanParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.map.proj.ProjectionUtils;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class OrteliusOval
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Ortelius Oval";
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    private ProjBooleanParameter globalParam_ = new ProjBooleanParameter("Show full globe rather than hemisphere", "Global", true);

    public OrteliusOval(int width, int height) {
        this(width, height, 0, 0);
    }

    public OrteliusOval(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public OrteliusOval(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
        this.addParameter(this.globalParam_);
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        super.parameterChanged(e);
        this.setGlobal(this.globalParam_.isSelected());
    }

    public void setGlobal(boolean b) {
        this.global_ = b;
        this.autoscale();
    }

    @Override
    protected void prepareScaling() {
        if (this.global_) {
            this.setSizeFactors(Math.PI, 1.5707963267948966);
        } else {
            this.setSizeFactor(1.5707963267948966);
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        if (this.global_) {
            super.drawBorderLines(g2d);
            return;
        }
        ProjectionUtils.drawEllipse(g2d, this.outCenterX_, this.outCenterY_, this.ymRS_, this.ymRS_);
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double phiRad = Math.toRadians(lat);
        double lambdaRad = this.lonToLambdaRad(lon);
        double absLambdaRad = Math.abs(lambdaRad);
        double x = 1.0;
        if (lambdaRad == 0.0) {
            x = 0.0;
        } else {
            if (!this.global_ && absLambdaRad > 1.5707963267948966) {
                return null;
            }
            double f = absLambdaRad <= 1.5707963267948966 ? 0.5 * (absLambdaRad + 2.4674011002723395 / absLambdaRad) : 1.5707963267948966;
            x = absLambdaRad - f + Math.sqrt(f * f - phiRad * phiRad);
            if (lambdaRad < 0.0) {
                x *= -1.0;
            }
        }
        double y = phiRad;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double phiRad = y * this.invRS_;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double rho2 = x * x + y * y;
        double rhoMax = this.ymRS_;
        double rhoMax2 = rhoMax * rhoMax;
        double r2s2 = this.rS_ * this.rS_;
        if (x == 0.0) {
            lambdaRad = 0.0;
        } else if (y == 0.0) {
            lambdaRad = x * this.invRS_;
        } else if (rho2 > rhoMax2) {
            lambdaRad = x * this.invRS_ + 1.5707963267948966 - Math.sqrt(2.4674011002723395 - phiRad * phiRad);
        } else {
            double b = -(rho2 - r2s2 * 2.4674011002723395) / (x * this.rS_);
            double c = -2.4674011002723395;
            lambdaRad = 0.5 * (-b + Math.sqrt(b * b - -9.869604401089358));
        }
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        if (!this.global_ && Math.abs(lambdaRad) > 1.5707963267948966) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        double rhoMax = this.ymRS_;
        double rhoMax2 = rhoMax * rhoMax;
        double r2s2 = this.rS_ * this.rS_;
        OrteliusOval orteliusOval = this;
        synchronized (orteliusOval) {
            block3: for (int iy = 0; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double y2 = y * y;
                double phiRad = y * this.invRS_;
                if (phiRad > 1.5707963267948966) continue;
                double phi = Math.toDegrees(phiRad);
                double phiRad2 = phiRad * phiRad;
                double xFactor = 1.5707963267948966 - Math.sqrt(2.4674011002723395 - phiRad2);
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double lambdaRad;
                    double x = (double)ix + 0.5;
                    double rho2 = x * x + y2;
                    if (x == 0.0) {
                        lambdaRad = 0.0;
                    } else if (y == 0.0) {
                        lambdaRad = x * this.invRS_;
                    } else if (rho2 > rhoMax2) {
                        lambdaRad = x * this.invRS_ + xFactor;
                    } else {
                        double b = -(rho2 - r2s2 * 2.4674011002723395) / (x * this.rS_);
                        double c = -2.4674011002723395;
                        lambdaRad = 0.5 * (-b + Math.sqrt(b * b - -9.869604401089358));
                    }
                    if (lambdaRad > Math.PI) continue;
                    if (!this.global_ && lambdaRad > 1.5707963267948966) continue block3;
                    this.set4SymmetricPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

