/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.AzimuthalProjection;
import java.awt.Dimension;
import java.awt.Graphics2D;

public class Orthographic
extends AzimuthalProjection {
    public static final String PROJECTION_NAME = "Orthographic";
    private static final double DEFAULT_RADIUS = 90.0;
    private static final double MAX_RADIUS = 90.0;

    public Orthographic(int width, int height) {
        this(width, height, 0, 0);
    }

    public Orthographic(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Orthographic(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x200040, width, height, xmargin, ymargin, 1.0, 1.0);
        this.addEdgeRadiusParameter(90.0, 90.0, true);
        this.setFillCorners(false);
        this.parameterChanged(null);
    }

    @Override
    public void setEdgeRadius(double r) {
        this.radiusDeg_ = r;
        this.radiusRad_ = Math.toRadians(this.radiusDeg_);
        this.autoscale();
    }

    @Override
    protected void prepareScaling() {
        double rhoMaxOverR = Math.sin(this.radiusRad_);
        this.setSizeFactor(rhoMaxOverR);
    }

    @Override
    protected final void finishScaling() {
        this.rhoBorder_ = this.rS_;
        this.rhoBorder2_ = this.rS_ * this.rS_;
        this.fillCorners_ = this.radiusDeg_ < 90.0;
    }

    @Override
    protected double getKForCosZ(double cosZ) {
        if (cosZ < 0.0) {
            return -1.0;
        }
        return 1.0;
    }

    @Override
    protected final double getZForRhoRS(double rhoRS) {
        double sinZ = rhoRS * this.invRS_;
        return Math.asin(sinZ);
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        double lambda;
        if (this.phiC_ == 0.0 && Math.abs(90.0 - (lambda = Math.abs(this.lonToLambda(lon)))) < 1.0E-5) {
            return;
        }
        super.drawMeridian(g2d, lon, label);
    }
}

