/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.ProjectionUtils;
import gov.nasa.giss.math.Elliptic;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeirceQuincuncial
extends AbstractProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Peirce Quincuncial";
    public static final int PROPERTIES = 12288;
    private static final double MODULUS = 0.7071067811865476;
    private static final double MODULUS2 = 0.5000000000000001;
    private static final double CAP_K = 1.854074677301372;
    private static final double TWO_K = 3.708149354602744;
    private static final double INV_CAP_K = 0.5393526011883794;
    private static final double INV_2K = 0.2696763005941897;
    private static final double REFERENCE_LON = -25.0;
    private static final double DIAGONAL_LON = 20.0;
    private static final double WIDTH_FACTOR = 1.0;
    private static final double HEIGHT_FACTOR = 1.0;

    public PeirceQuincuncial(int width, int height) {
        this(width, height, 0, 0);
    }

    public PeirceQuincuncial(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public PeirceQuincuncial(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 12288, width, height, xmargin, ymargin, 1.0, 1.0);
    }

    @Override
    public void setCenter(double lon) {
        LOGGER.trace("Projection does not support changing center.");
    }

    @Override
    public void setCenter(PointLL pt) {
        LOGGER.trace("Projection does not support changing center.");
    }

    @Override
    public void setCenter(double lon, double lat) {
        LOGGER.trace("Projection does not support changing center.");
    }

    @Override
    public boolean isRecenterableLon() {
        return false;
    }

    @Override
    public boolean isRecenterableLat() {
        return false;
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        Point2D.Double p2d = this.transformLL2XY0(lon, lat);
        if (p2d == null) {
            return null;
        }
        double x = (double)this.outCenterX_ + p2d.x;
        double y = (double)this.outCenterY_ - p2d.y;
        return new Point2D.Double(x, y);
    }

    private Point2D.Double transformLL2XY0(double lon, double lat) {
        double y;
        double x;
        boolean bneg;
        double vstar;
        double ustar;
        double lambdaRad;
        for (lambdaRad = Math.toRadians(lon - -25.0); lambdaRad < 0.0; lambdaRad += Math.PI * 2) {
        }
        while (lambdaRad >= Math.PI * 2) {
            lambdaRad -= Math.PI * 2;
        }
        double origLambdaRad = lambdaRad;
        double sinLambda = Math.sin(lambdaRad %= 1.5707963267948966);
        double cosLambda = Math.cos(lambdaRad);
        double chiRad = Math.toRadians(90.0 - lat);
        double halfChiRad = 0.5 * chiRad;
        double tanHalfChi = Math.tan(halfChiRad);
        double xq = tanHalfChi * cosLambda;
        double yq = tanHalfChi * sinLambda;
        double a = xq * xq + yq * yq;
        double b = xq * xq - yq * yq;
        double twoA = 2.0 * a;
        double twoB = 2.0 * b;
        double a2 = a * a;
        double b2 = b * b;
        double onePlusA2 = 1.0 + a2;
        double sqrtTerm = Math.sqrt(onePlusA2 * onePlusA2 - 4.0 * b2);
        double cc = 1.0 + twoB - a2;
        double ee = twoA - sqrtTerm;
        double ff = twoA + sqrtTerm;
        double cosAlpha = ee / cc;
        double cosBeta = cc / ff;
        double alphaRad = Math.acos(Math.abs(cosAlpha));
        double betaRad = Math.acos(Math.abs(cosBeta));
        try {
            double ellAlpha = Elliptic.ellipticF(alphaRad, 0.5000000000000001);
            double ellBeta = Elliptic.ellipticF(betaRad, 0.5000000000000001);
            ustar = 1.0 - ellAlpha * 0.2696763005941897;
            vstar = ellBeta * 0.2696763005941897;
        }
        catch (Exception exc) {
            return null;
        }
        boolean aneg = cosAlpha < 0.0;
        boolean bl = bneg = cosBeta < 0.0;
        if (aneg) {
            ustar = 1.0 - ustar;
        }
        if (bneg) {
            vstar = 1.0 - vstar;
        }
        int quadrant = (int)(origLambdaRad / 1.5707963267948966);
        switch (quadrant) {
            case 1: {
                x = -vstar;
                y = ustar;
                break;
            }
            case 2: {
                x = -ustar;
                y = -vstar;
                break;
            }
            case 3: {
                x = vstar;
                y = -ustar;
                break;
            }
            default: {
                x = ustar;
                y = vstar;
            }
        }
        return new Point2D.Double(x * this.rS_, y * this.rS_);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > this.rS_ || Math.abs(y) > this.rS_) {
            return null;
        }
        return this.transformXY2LL0(x, y);
    }

    private PointLL transformXY2LL0(double xx, double yy) {
        double[] lambdaPhi;
        double tt;
        boolean south;
        boolean diagflip;
        double vstar;
        double ustar;
        int quadrant;
        double x = xx * this.invRS_;
        double y = yy * this.invRS_;
        if (x >= 0.0 && y >= 0.0) {
            quadrant = 0;
            ustar = x;
            vstar = y;
        } else if (x < 0.0 && y >= 0.0) {
            quadrant = 1;
            ustar = y;
            vstar = -x;
        } else if (x < 0.0 && y < 0.0) {
            quadrant = 2;
            ustar = -x;
            vstar = -y;
        } else {
            quadrant = 3;
            ustar = -y;
            vstar = x;
        }
        boolean bl = diagflip = vstar > ustar;
        if (diagflip) {
            double tt2 = ustar;
            ustar = vstar;
            vstar = tt2;
        }
        boolean bl2 = south = ustar + vstar > 1.0;
        if (south && (ustar = 1.0 - vstar) + (vstar = 1.0 - (tt = ustar)) > 1.0) {
            double diff = 0.5 * (ustar + vstar - 1.0) + 1.0E-8;
            ustar -= diff;
            vstar -= diff;
        }
        if ((lambdaPhi = this.iterateUV2LambdaPhi(ustar, vstar)) == null) {
            return null;
        }
        double lambda = lambdaPhi[0] + -25.0;
        double phi = lambdaPhi[1];
        if (south) {
            phi = -phi;
        }
        if (diagflip) {
            double dlambda = 20.0 - lambda;
            lambda = 20.0 + dlambda;
        }
        return new PointLL(lambda += (double)quadrant * 90.0, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        PeirceQuincuncial peirceQuincuncial = this;
        synchronized (peirceQuincuncial) {
            for (int ix = 0; ix < this.dxMax_; ++ix) {
                double x = (double)ix + 0.5;
                double ustar = x * this.invRS_;
                double xinv = (1.0 - ustar) * this.rS_;
                for (int iy = 0; (double)iy < x && iy <= this.dyMax_; ++iy) {
                    double y = (double)iy + 0.5;
                    double vstar = y * this.invRS_;
                    double yinv = (1.0 - vstar) * this.rS_;
                    double[] lambdaPhi = this.iterateUV2LambdaPhi(ustar, vstar);
                    if (lambdaPhi == null) continue;
                    double lambda = lambdaPhi[0] + -25.0;
                    double phi = lambdaPhi[1];
                    this.set8SymmetricPoints(ix, iy, lambda, phi);
                    double xlambda = 20.0 - lambda;
                    lambda = 20.0 + xlambda;
                    phi = -phi;
                    this.set8SymmetricPoints((int)xinv, (int)yinv, lambda, phi);
                }
            }
        }
    }

    private double[] iterateUV2LambdaPhi(double ustarx, double vstarx) {
        double lambdaRad;
        double b;
        double a;
        double tt;
        double excess;
        boolean south;
        if (ustarx < 0.0 || vstarx < 0.0 || ustarx > 1.0 || vstarx > 1.0) {
            return null;
        }
        double ustar = ustarx;
        double vstar = vstarx;
        boolean bl = south = ustar + vstar > 1.0;
        if (south && (excess = (ustar = 1.0 - vstar) + (vstar = 1.0 - (tt = ustar)) - 1.0) > 0.0) {
            double diff = 0.5 * excess + 1.0E-8;
            ustar -= diff;
            vstar -= diff;
        }
        boolean aneg = ustar < 0.5;
        double ellAlpha = aneg ? 3.708149354602744 * ustar : 3.708149354602744 * (1.0 - ustar);
        double ellBeta = 3.708149354602744 * vstar;
        double[] jacobiA = Elliptic.jacobiSnCnDn(ellAlpha, 0.5000000000000001);
        double[] jacobiB = Elliptic.jacobiSnCnDn(ellBeta, 0.5000000000000001);
        double cosAlpha = aneg ? -jacobiA[1] : jacobiA[1];
        double cosBeta = jacobiB[1];
        if (Math.abs(1.0 - ustar - vstar) < 1.0E-5) {
            if (vstar == 0.0) {
                return new double[]{0.0, 0.0};
            }
            if (vstar == 0.5) {
                return new double[]{45.0, 0.0};
            }
            double cacb = cosAlpha * cosBeta;
            double lambdaMinusQPi = Math.atan(-Math.sqrt(cacb));
            double lambdaRad2 = lambdaMinusQPi + 0.7853981633974483;
            double lambda = Math.toDegrees(lambdaRad2);
            return new double[]{lambda, 0.0};
        }
        if (ustar < 0.5) {
            a = 0.16;
            b = 0.13;
        } else if (ustar > 0.97) {
            a = 0.999;
            b = 0.999;
        } else if (ustar > 0.85) {
            a = 0.975;
            b = 0.975;
        } else if (ustar > 0.67) {
            b = a = ustar + 0.5 * (1.0 - ustar);
        } else {
            a = 0.7;
            b = 0.6;
        }
        int iterc = -1;
        for (int iter = 0; iter < 33; ++iter) {
            double twoA = 2.0 * a;
            double twoB = 2.0 * b;
            double a2 = a * a;
            double onePlusA2 = 1.0 + a2;
            double b2 = b * b;
            double sqrtTermA = onePlusA2 * onePlusA2 - 4.0 * b2;
            if (sqrtTermA < 0.0) {
                sqrtTermA = 1.0E-12;
            }
            double sqrtTerm = Math.sqrt(sqrtTermA);
            double cc = 1.0 + twoB - a2;
            if (cc == 0.0) {
                return null;
            }
            double ff = twoA + sqrtTerm;
            if (ff == 0.0) {
                return null;
            }
            double dsqrtda = 0.5 * (4.0 * a * onePlusA2) / sqrtTerm;
            double dsqrtdb = 0.5 * (-8.0 * b) / sqrtTerm;
            double deeda = 2.0 - dsqrtda;
            double deedb = -dsqrtdb;
            double dffda = 2.0 + dsqrtda;
            double dffdb = dsqrtdb;
            double invcc = 1.0 / cc;
            double invff = 1.0 / ff;
            double f1 = (twoA - sqrtTerm) / cc - cosAlpha;
            double f2 = cc / (twoA + sqrtTerm) - cosBeta;
            double ee = twoA - sqrtTerm;
            double dccda = -twoA;
            double dccdb = 2.0;
            double df1da = (deeda - ee * dccda * invcc) * invcc;
            double df2db = (2.0 - cc * dffdb * invff) * invff;
            double df2da = (dccda - cc * dffda * invff) * invff;
            double df1db = (deedb - ee * 2.0 * invcc) * invcc;
            double denom = df1da * df2db - df2da * df1db;
            if (denom == 0.0) {
                return null;
            }
            double da = (f1 * df2db - f2 * df1db) / denom;
            double db = (f2 * df1da - f1 * df2da) / denom;
            a -= da;
            b -= db;
            if (!(Math.abs(da) < 1.0E-5) || !(Math.abs(db) < 1.0E-5)) continue;
            iterc = iter;
            break;
        }
        if (iterc < 0) {
            return null;
        }
        if (a > 1.0 && a - 1.0 < 1.0E-5) {
            a = 1.0;
        }
        if (b > 1.0 && b - 1.0 < 1.0E-5) {
            b = 1.0;
        }
        double x2 = 0.5 * (a + b);
        double tanHalfChi = Math.sqrt(a);
        double x = Math.sqrt(x2);
        double cosLambda = x / tanHalfChi;
        if (cosLambda > 1.0 && cosLambda < 1.00001) {
            cosLambda = 1.0;
        }
        if (Double.isNaN(lambdaRad = Math.acos(cosLambda))) {
            return null;
        }
        double chiRad = 2.0 * Math.atan(tanHalfChi);
        double chi = Math.toDegrees(chiRad);
        double lambda = Math.toDegrees(lambdaRad);
        double phi = south ? chi - 90.0 : 90.0 - chi;
        return new double[]{lambda, phi};
    }

    protected void set8SymmetricPoints(int ix, int iy, double lambda, double phi) {
        int col0 = this.outCenterX_ + ix;
        int col1 = this.outCenterX_ + iy;
        int col2 = this.outCenterX_ - 1 - iy;
        int col3 = this.outCenterX_ - 1 - ix;
        int row0 = this.outCenterY_ - 1 - iy;
        int row1 = this.outCenterY_ - 1 - ix;
        int row4 = this.outCenterY_ + iy;
        int row5 = this.outCenterY_ + ix;
        double dlambda = 20.0 - lambda;
        double lambda1 = 20.0 + dlambda;
        int index0 = row0 * this.outWidth_ + col0;
        int index1 = row1 * this.outWidth_ + col1;
        int index2 = row1 * this.outWidth_ + col2;
        int index3 = row0 * this.outWidth_ + col3;
        int index4 = row4 * this.outWidth_ + col3;
        int index5 = row5 * this.outWidth_ + col2;
        int index6 = row5 * this.outWidth_ + col1;
        int index7 = row4 * this.outWidth_ + col0;
        this.invArrayLon_[index0] = MapUtils.normalize360(lambda);
        this.invArrayLon_[index1] = MapUtils.normalize360(lambda1);
        this.invArrayLon_[index2] = MapUtils.normalize360(lambda + 90.0);
        this.invArrayLon_[index3] = MapUtils.normalize360(lambda1 + 90.0);
        this.invArrayLon_[index4] = MapUtils.normalize360(lambda + 180.0);
        this.invArrayLon_[index5] = MapUtils.normalize360(lambda1 + 180.0);
        this.invArrayLon_[index6] = MapUtils.normalize360(lambda - 90.0);
        this.invArrayLon_[index7] = MapUtils.normalize360(lambda1 - 90.0);
        this.invArrayLat_[index0] = phi;
        this.invArrayLat_[index1] = phi;
        this.invArrayLat_[index2] = phi;
        this.invArrayLat_[index3] = phi;
        this.invArrayLat_[index4] = phi;
        this.invArrayLat_[index5] = phi;
        this.invArrayLat_[index6] = phi;
        this.invArrayLat_[index7] = phi;
        int srcY = this.getSrcPixelY(phi);
        if (srcY > -1) {
            int srcX0 = this.getSrcPixelX(this.invArrayLon_[index0]);
            int srcX1 = this.getSrcPixelX(this.invArrayLon_[index1]);
            int srcX2 = this.getSrcPixelX(this.invArrayLon_[index2]);
            int srcX3 = this.getSrcPixelX(this.invArrayLon_[index3]);
            int srcX4 = this.getSrcPixelX(this.invArrayLon_[index4]);
            int srcX5 = this.getSrcPixelX(this.invArrayLon_[index5]);
            int srcX6 = this.getSrcPixelX(this.invArrayLon_[index6]);
            int srcX7 = this.getSrcPixelX(this.invArrayLon_[index7]);
            if (srcX0 > -1) {
                this.invArray_[index0] = srcY * this.srcWidth_ + srcX0;
            }
            if (srcX1 > -1) {
                this.invArray_[index1] = srcY * this.srcWidth_ + srcX1;
            }
            if (srcX2 > -1) {
                this.invArray_[index2] = srcY * this.srcWidth_ + srcX2;
            }
            if (srcX3 > -1) {
                this.invArray_[index3] = srcY * this.srcWidth_ + srcX3;
            }
            if (srcX4 > -1) {
                this.invArray_[index4] = srcY * this.srcWidth_ + srcX4;
            }
            if (srcX5 > -1) {
                this.invArray_[index5] = srcY * this.srcWidth_ + srcX5;
            }
            if (srcX6 > -1) {
                this.invArray_[index6] = srcY * this.srcWidth_ + srcX6;
            }
            if (srcX7 > -1) {
                this.invArray_[index7] = srcY * this.srcWidth_ + srcX7;
            }
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        double dd = this.rS_;
        ProjectionUtils.drawRectBorder(g2d, (double)this.outCenterX_ - dd, (double)this.outCenterY_ - dd, 2.0 * dd, 2.0 * dd);
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        if (lat == 0.0) {
            double dd = this.rS_ * 0.7071067811865476;
            g2d.translate(this.outCenterX_, this.outCenterY_);
            g2d.rotate(0.7853981633974483);
            ProjectionUtils.drawRect(g2d, -dd, -dd, 2.0 * dd, 2.0 * dd);
            g2d.rotate(-0.7853981633974483);
            g2d.translate(-this.outCenterX_, -this.outCenterY_);
        } else {
            super.drawParallel(g2d, lat, label);
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        double llon;
        for (llon = lon; llon < 0.0; llon += 360.0) {
        }
        int quad = (int)((llon - -25.0) / 90.0);
        double remain = (llon - -25.0) % 90.0;
        double dd = this.rS_;
        if (Math.abs(remain) < 1.0E-5) {
            switch (quad) {
                case 0: 
                case 4: {
                    GraphicUtils.drawLine(g2d, this.outCenterX_, this.outCenterY_, (double)this.outCenterX_ + dd, this.outCenterY_);
                    break;
                }
                case 1: {
                    GraphicUtils.drawLine(g2d, this.outCenterX_, this.outCenterY_, this.outCenterX_, (double)this.outCenterY_ - dd);
                    break;
                }
                case 2: {
                    GraphicUtils.drawLine(g2d, this.outCenterX_, this.outCenterY_, (double)this.outCenterX_ - dd, this.outCenterY_);
                    break;
                }
                case 3: {
                    GraphicUtils.drawLine(g2d, this.outCenterX_, this.outCenterY_, this.outCenterX_, (double)this.outCenterY_ + dd);
                    break;
                }
            }
            return;
        }
        if (Math.abs(remain - 45.0) < 1.0E-5) {
            switch (quad) {
                case 0: {
                    GraphicUtils.drawLine(g2d, this.outCenterX_, this.outCenterY_, (double)this.outCenterX_ + dd, (double)this.outCenterY_ - dd);
                    break;
                }
                case 1: {
                    GraphicUtils.drawLine(g2d, this.outCenterX_, this.outCenterY_, (double)this.outCenterX_ - dd, (double)this.outCenterY_ - dd);
                    break;
                }
                case 2: {
                    GraphicUtils.drawLine(g2d, this.outCenterX_, this.outCenterY_, (double)this.outCenterX_ - dd, (double)this.outCenterY_ + dd);
                    break;
                }
                case 3: {
                    GraphicUtils.drawLine(g2d, this.outCenterX_, this.outCenterY_, (double)this.outCenterX_ + dd, (double)this.outCenterY_ + dd);
                    break;
                }
            }
            return;
        }
        super.drawMeridian(g2d, lon, label);
    }
}

