/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.AzimuthalProjection;
import java.awt.Dimension;

public class Stereographic
extends AzimuthalProjection {
    public static final String PROJECTION_NAME = "Stereographic";
    public static final int PROPERTIES = 2101312;
    private static final double MAX_RADIUS = 150.0;
    private static final double DEFAULT_RADIUS = 90.0;

    public Stereographic(int width, int height) {
        this(width, height, 0, 0);
    }

    public Stereographic(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Stereographic(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 2101312, width, height, xmargin, ymargin, 1.0, 1.0);
        this.addEdgeRadiusParameter(90.0, 150.0, true);
        this.addFillParameter();
        this.parameterChanged(null);
    }

    @Override
    public void setEdgeRadius(double r) {
        this.radiusDeg_ = r;
        this.radiusRad_ = Math.toRadians(this.radiusDeg_);
        this.autoscale();
    }

    @Override
    protected void prepareScaling() {
        double rhoMaxOverR = 2.0 * Math.tan(0.5 * this.radiusRad_);
        this.setSizeFactor(rhoMaxOverR);
    }

    @Override
    protected final void finishScaling() {
        if (this.fillCorners_) {
            double rhoBOverR = 2.0 * Math.tan(0.5 * Math.toRadians(150.0));
            this.rhoBorder_ = rhoBOverR * this.rS_;
        } else {
            this.rhoBorder_ = this.xmRS_;
        }
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
    }

    @Override
    protected double getKForCosZ(double cosZ) {
        if (cosZ == -1.0) {
            return -1.0;
        }
        return 2.0 / (1.0 + cosZ);
    }

    @Override
    protected double getZForRhoRS(double rhoRS) {
        return 2.0 * Math.atan(0.5 * rhoRS * this.invRS_);
    }
}

