/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.ConcavePoleProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class StrebeEqualArea
extends ConcavePoleProjection {
    public static final String PROJECTION_NAME = "Strebe Equal-Area";
    public static final int PROPERTIES = 32;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    private static final double KG = 1.35;
    private static final double CONST1 = 7.141592653589793;
    private static final double CONST2 = 22.43597501544853;
    private static final double SQRT_C1 = Math.sqrt(7.141592653589793);
    private static final double SQRT_C2 = Math.sqrt(22.43597501544853);

    public StrebeEqualArea(int width, int height) {
        this(width, height, 0, 0);
    }

    public StrebeEqualArea(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public StrebeEqualArea(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 32, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double cosTheta;
        double sinTheta;
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double sinPhi = Math.sin(phiRad);
        double phiFactor = 3.5707963267948966 * sinPhi;
        double thetaRad = 0.5 * phiRad;
        for (int iter = 0; iter < 33; ++iter) {
            sinTheta = Math.sin(thetaRad);
            cosTheta = Math.cos(thetaRad);
            double func = thetaRad + sinTheta * (2.0 + cosTheta) - phiFactor;
            double dfunc = 2.0 * cosTheta * (1.0 + cosTheta);
            double dthetaRad = -func / dfunc;
            thetaRad += dthetaRad;
            if (Math.abs(dthetaRad) < 1.0E-5) break;
        }
        sinTheta = Math.sin(thetaRad);
        cosTheta = Math.cos(thetaRad);
        double xe = 2.7 * lambdaRad * (1.0 + cosTheta) / SQRT_C2;
        double ye = 3.544907701811032 * sinTheta / (1.35 * SQRT_C1);
        double r = Math.sqrt(2.0 - ye * ye);
        double lambdaPRad = 0.7853981633974483 * xe / r;
        double sinLambdaP = Math.sin(lambdaPRad);
        double cosLambdaP = Math.cos(lambdaPRad);
        double sinPhiP = (2.0 * Math.asin(ye * 0.7071067811865476) + r * ye) * 0.3183098861837907;
        double cosPhiP = Math.sqrt(1.0 - sinPhiP * sinPhiP);
        double d = Math.sqrt(2.0 / (1.0 + cosPhiP * cosLambdaP));
        double x = 2.0 * d / 1.35 * cosPhiP * sinLambdaP;
        double y = 1.35 * d * sinPhiP;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double cosTheta;
        double r;
        double r2;
        double lambdaPRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        if (x == 0.0 && y == 0.0) {
            return new PointLL(this.lambdaC_, 0.0);
        }
        double xOverRS = x * this.invRS_;
        double yOverRS = y * this.invRS_;
        double sinHalfBeta = 0.5 * Math.hypot(0.5 * xOverRS * 1.35, yOverRS / 1.35);
        if (Math.abs(sinHalfBeta) > 1.0) {
            return null;
        }
        double halfBetaRad = Math.asin(sinHalfBeta);
        double cosHalfBeta = Math.cos(halfBetaRad);
        double phiPRad = Math.asin(cosHalfBeta * yOverRS / 1.35);
        if (Math.abs(phiPRad) > 1.5707963267948966) {
            return null;
        }
        double cosBeta = Math.cos(2.0 * halfBetaRad);
        double d = lambdaPRad = phiPRad == 1.5707963267948966 ? 0.0 : Math.atan2(0.675 * cosHalfBeta * xOverRS, cosBeta);
        if (Math.abs(lambdaPRad) > Math.PI) {
            return null;
        }
        double phiPFactor = Math.PI * Math.sin(phiPRad);
        double ye = 0.5;
        for (int iter = 0; iter < 33; ++iter) {
            r2 = 2.0 - ye * ye;
            r = Math.sqrt(r2);
            double func = 2.0 * Math.asin(ye * 0.7071067811865476) + ye * r - phiPFactor;
            double dfunc = 2.8284271247461903 / r2 - ye * ye / r + r;
            double dye = -func / dfunc;
            ye += dye;
            if (Math.abs(dye) < 1.0E-5) break;
        }
        r2 = 2.0 - ye * ye;
        r = Math.sqrt(r2);
        double sinTheta = 0.675 * ye * SQRT_C1 / 1.772453850905516;
        if (Math.abs(sinTheta) > 1.0) {
            return null;
        }
        double thetaRad = Math.asin(0.675 * ye * SQRT_C1 / 1.772453850905516);
        double phiRad = Math.asin((thetaRad + sinTheta * (2.0 + (cosTheta = Math.cos(thetaRad)))) * 2.0 / 7.141592653589793);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double xe = 4.0 * r * lambdaPRad * 0.3183098861837907;
        double lambdaRad = 0.37037037037037035 * xe * SQRT_C2 / (1.0 + cosTheta);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        StrebeEqualArea strebeEqualArea = this;
        synchronized (strebeEqualArea) {
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double lambdaRad;
                    double cosTheta;
                    double thetaRad;
                    double phiRad;
                    double r;
                    double r2;
                    double lambdaPRad;
                    double x = (double)ix + 0.5;
                    double xOverRS = x * this.invRS_;
                    double sinHalfBeta = 0.5 * Math.hypot(0.5 * xOverRS * 1.35, yOverRS / 1.35);
                    if (Math.abs(sinHalfBeta) > 1.0) continue;
                    double halfBetaRad = Math.asin(sinHalfBeta);
                    double cosHalfBeta = Math.cos(halfBetaRad);
                    double cosBeta = Math.cos(2.0 * halfBetaRad);
                    double phiPRad = Math.asin(cosHalfBeta * yOverRS / 1.35);
                    if (Math.abs(phiPRad) > 1.5707963267948966) continue;
                    double d = lambdaPRad = phiPRad == 1.5707963267948966 ? 0.0 : Math.atan2(0.675 * cosHalfBeta * xOverRS, cosBeta);
                    if (Math.abs(lambdaPRad) > Math.PI) continue;
                    double phiPFactor = Math.PI * Math.sin(phiPRad);
                    double ye = 0.5;
                    for (int iter = 0; iter < 33; ++iter) {
                        r2 = 2.0 - ye * ye;
                        r = Math.sqrt(r2);
                        double func = 2.0 * Math.asin(ye * 0.7071067811865476) + ye * r - phiPFactor;
                        double dfunc = 2.8284271247461903 / r2 - ye * ye / r + r;
                        double dye = -func / dfunc;
                        ye += dye;
                        if (Math.abs(dye) < 1.0E-5) break;
                    }
                    r2 = 2.0 - ye * ye;
                    r = Math.sqrt(r2);
                    double xe = 4.0 * r * lambdaPRad * 0.3183098861837907;
                    double sinTheta = 0.675 * ye * SQRT_C1 / 1.772453850905516;
                    if (Math.abs(sinTheta) > 1.0 || Math.abs(phiRad = Math.asin(((thetaRad = Math.asin(0.675 * ye * SQRT_C1 / 1.772453850905516)) + (sinTheta = Math.sin(thetaRad)) * (2.0 + (cosTheta = Math.cos(thetaRad)))) * 2.0 / 7.141592653589793)) > 1.5707963267948966 || Math.abs(lambdaRad = 0.37037037037037035 * xe * SQRT_C2 / (1.0 + cosTheta)) > Math.PI) continue;
                    this.set4SymmetricPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }
}

